/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.crac.resources.datasources.resolver;

import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.crac.CracConfiguration;
import io.micronaut.crac.resources.datasources.resolver.DataSourceResourceResolver;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import org.crac.Resource;

@Primary
@Singleton
public class CompositeDataSourceResolver
implements DataSourceResourceResolver {
    private final List<DataSourceResourceResolver> resolvers;

    public CompositeDataSourceResolver(List<DataSourceResourceResolver> resolvers) {
        this.resolvers = resolvers;
    }

    @Override
    @NonNull
    public Optional<Resource> resolve(@NonNull DataSource dataSource, @NonNull CracConfiguration configuration) {
        return this.resolvers.stream().map(resolver -> resolver.resolve(dataSource, configuration)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }
}

