/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.crac.resources;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.crac.CracConfiguration;
import io.micronaut.crac.CracEventPublisher;
import io.micronaut.crac.CracResourceRegistrar;
import io.micronaut.crac.OrderedResource;
import io.micronaut.crac.resources.datasources.UnknownDataSourceResource;
import io.micronaut.crac.resources.datasources.resolver.DataSourceResourceResolver;
import javax.sql.DataSource;
import org.crac.Context;
import org.crac.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EachBean(value=DataSource.class)
@Requirements(value={@Requires(classes={DataSource.class}), @Requires(bean=CracResourceRegistrar.class)})
public class DataSourceResource
implements OrderedResource {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceResource.class);
    private final CracEventPublisher eventPublisher;
    private final Resource handler;
    private final DataSourceResourceResolver dataSourceResolver;

    public DataSourceResource(CracConfiguration configuration, CracEventPublisher eventPublisher, DataSource dataSource, DataSourceResourceResolver dataSourceResolver) {
        this.eventPublisher = eventPublisher;
        this.dataSourceResolver = dataSourceResolver;
        this.handler = this.getHandler(dataSource, configuration);
    }

    private Resource getHandler(DataSource dataSource, CracConfiguration configuration) {
        return this.dataSourceResolver.resolve(dataSource, configuration).orElseGet(() -> {
            if (LOG.isWarnEnabled()) {
                LOG.warn("DataSource {} is not currently supported by CRaC", (Object)dataSource.getClass().getName());
            }
            return new UnknownDataSourceResource(dataSource);
        });
    }

    public void beforeCheckpoint(Context<? extends Resource> context) throws Exception {
        this.eventPublisher.fireBeforeCheckpointEvents(this, () -> {
            long beforeStart;
            block2: {
                beforeStart = System.nanoTime();
                try {
                    this.handler.beforeCheckpoint(context);
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block2;
                    LOG.error("Error stopping datasource {}", (Object)this.handler, (Object)e);
                }
            }
            return System.nanoTime() - beforeStart;
        });
    }

    public void afterRestore(Context<? extends Resource> context) throws Exception {
        this.eventPublisher.fireAfterRestoreEvents(this, () -> {
            long beforeStart;
            block2: {
                beforeStart = System.nanoTime();
                try {
                    this.handler.afterRestore(context);
                }
                catch (Exception e) {
                    if (!LOG.isErrorEnabled()) break block2;
                    LOG.error("Error restoring datasource {}", (Object)this.handler, (Object)e);
                }
            }
            return System.nanoTime() - beforeStart;
        });
    }
}

