/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.crac.test;

import io.micronaut.context.annotation.Requires;
import io.micronaut.crac.OrderedResource;
import io.micronaut.crac.test.CheckpointSimulator;
import jakarta.inject.Singleton;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(env={"test"})
public class DefaultCheckpointSimulator
implements CheckpointSimulator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCheckpointSimulator.class);
    private final List<OrderedResource> resources;

    public DefaultCheckpointSimulator(List<OrderedResource> resources) {
        this.resources = resources;
    }

    @Override
    public void runBeforeCheckpoint() {
        for (int i = this.resources.size() - 1; i >= 0; --i) {
            OrderedResource resource = this.resources.get(i);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Running before checkpoint for resource: {} ({})", (Object)resource, (Object)resource.getOrder());
            }
            try {
                resource.beforeCheckpoint(null);
                continue;
            }
            catch (Exception e) {
                throw new SimulatorException(e);
            }
        }
    }

    @Override
    public void runAfterRestore() {
        this.resources.forEach(DefaultCheckpointSimulator::internalAfterRestore);
    }

    private static void internalAfterRestore(OrderedResource resource) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Running after restore for resource: {} ({})", (Object)resource, (Object)resource.getOrder());
            }
            resource.afterRestore(null);
        }
        catch (Exception e) {
            throw new SimulatorException(e);
        }
    }

    static class SimulatorException
    extends RuntimeException {
        public SimulatorException(Throwable cause) {
            super(cause);
        }
    }
}

