/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.connection;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Order;
import io.micronaut.data.connection.ConnectionDefinition;
import io.micronaut.data.connection.ConnectionOperations;
import io.micronaut.data.connection.ConnectionStatus;
import io.micronaut.data.connection.jdbc.operations.DefaultDataSourceConnectionOperations;
import io.micronaut.data.connection.support.DefaultConnectionStatus;
import io.micronaut.data.hibernate.conf.RequiresSyncHibernate;
import io.micronaut.data.hibernate.connection.HibernateConnectionOperations;
import java.sql.Connection;
import java.util.Optional;
import java.util.function.Function;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;

@Order(value=200)
@Internal
@RequiresSyncHibernate
@EachBean(value=HibernateConnectionOperations.class)
@Replaces(value=DefaultDataSourceConnectionOperations.class)
public final class HibernateConnectionConnectionOperations
implements ConnectionOperations<Connection> {
    private final HibernateConnectionOperations hibernateConnectionOperations;

    public HibernateConnectionConnectionOperations(HibernateConnectionOperations hibernateConnectionOperations) {
        this.hibernateConnectionOperations = hibernateConnectionOperations;
    }

    public Optional<ConnectionStatus<Connection>> findConnectionStatus() {
        return this.hibernateConnectionOperations.findConnectionStatus().map(this::createConnectionStatus);
    }

    public <R> R execute(ConnectionDefinition definition, Function<ConnectionStatus<Connection>, R> callback) {
        return (R)this.hibernateConnectionOperations.execute(definition, connectionStatus -> callback.apply(this.createConnectionStatus((ConnectionStatus<Session>)connectionStatus)));
    }

    private ConnectionStatus<Connection> createConnectionStatus(ConnectionStatus<Session> connectionStatus) {
        return new DefaultConnectionStatus((Object)this.getConnection((Session)connectionStatus.getConnection()), connectionStatus.getDefinition(), connectionStatus.isNew());
    }

    private Connection getConnection(Session session) {
        return ((SessionImplementor)session).getJdbcCoordinator().getLogicalConnection().getPhysicalConnection();
    }
}

