/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.event;

import io.micronaut.context.annotation.Primary;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.DateCreated;
import io.micronaut.data.annotation.DateUpdated;
import io.micronaut.data.runtime.date.DateTimeProvider;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;
import org.hibernate.boot.Metadata;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.AbstractPreDatabaseOperationEvent;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.hibernate.tuple.entity.EntityMetamodel;

@Primary
@Singleton
public class EventIntegrator
implements Integrator {
    private final DateTimeProvider dateTimeProvider;

    public EventIntegrator(@NotNull DateTimeProvider dateTimeProvider) {
        this.dateTimeProvider = dateTimeProvider;
    }

    public void integrate(Metadata metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        EventListenerRegistry eventListenerRegistry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
        Collection entityBindings = metadata.getEntityBindings();
        HashMap lastUpdates = new HashMap(entityBindings.size());
        HashMap dateCreated = new HashMap(entityBindings.size());
        entityBindings.forEach(e -> {
            Class mappedClass = e.getMappedClass();
            BeanIntrospection introspection = BeanIntrospector.SHARED.findIntrospection(mappedClass).orElse(null);
            if (introspection != null) {
                introspection.getIndexedProperty(DateCreated.class).ifPresent(bp -> dateCreated.put(mappedClass, bp));
                introspection.getIndexedProperty(DateUpdated.class).ifPresent(bp -> lastUpdates.put(mappedClass, bp));
            }
        });
        ConversionService conversionService = ConversionService.SHARED;
        if (CollectionUtils.isNotEmpty(dateCreated)) {
            eventListenerRegistry.getEventListenerGroup(EventType.PRE_INSERT).appendListener((PreInsertEventListener & Serializable)event -> {
                Object[] state = event.getState();
                this.timestampIfNecessary(dateCreated, lastUpdates, conversionService, (AbstractPreDatabaseOperationEvent)event, state, true);
                return false;
            });
        }
        if (CollectionUtils.isNotEmpty(lastUpdates)) {
            eventListenerRegistry.getEventListenerGroup(EventType.PRE_UPDATE).appendListener((PreUpdateEventListener & Serializable)event -> {
                this.timestampIfNecessary(dateCreated, lastUpdates, conversionService, (AbstractPreDatabaseOperationEvent)event, event.getState(), false);
                return false;
            });
        }
    }

    private void timestampIfNecessary(Map<Class, BeanProperty> dateCreated, Map<Class, BeanProperty> lastUpdates, ConversionService<?> conversionService, AbstractPreDatabaseOperationEvent event, Object[] state, boolean isInsert) {
        BeanProperty lastUpdatedProp;
        BeanProperty dateCreatedProp;
        Object entity = event.getEntity();
        Object now = null;
        if (isInsert && (dateCreatedProp = dateCreated.get(entity.getClass())) != null) {
            now = this.dateTimeProvider.getNow();
            conversionService.convert(now, dateCreatedProp.getType()).ifPresent(o -> {
                dateCreatedProp.set(entity, o);
                EntityMetamodel entityMetamodel = event.getPersister().getEntityMetamodel();
                int i = entityMetamodel.getPropertyIndex(dateCreatedProp.getName());
                state[i] = o;
            });
        }
        if ((lastUpdatedProp = lastUpdates.get(entity.getClass())) != null) {
            now = now != null ? now : this.dateTimeProvider.getNow();
            conversionService.convert(now, lastUpdatedProp.getType()).ifPresent(o -> {
                lastUpdatedProp.set(entity, o);
                EntityMetamodel entityMetamodel = event.getPersister().getEntityMetamodel();
                int i = entityMetamodel.getPropertyIndex(lastUpdatedProp.getName());
                state[i] = o;
            });
        }
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }
}

