/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.operations;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.QueryHint;
import io.micronaut.data.jpa.annotation.EntityGraph;
import io.micronaut.data.jpa.operations.JpaRepositoryOperations;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.builder.jpa.JpaQueryBuilder;
import io.micronaut.data.model.runtime.BatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.async.AsyncCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveRepositoryOperations;
import io.micronaut.data.runtime.mapper.BeanIntrospectionMapper;
import io.micronaut.data.runtime.operations.ExecutorAsyncOperations;
import io.micronaut.data.runtime.operations.ExecutorReactiveOperations;
import io.micronaut.jdbc.spring.HibernatePresenceCondition;
import io.micronaut.transaction.TransactionOperations;
import java.io.Serializable;
import java.sql.Connection;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.Tuple;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.graph.RootGraph;
import org.hibernate.query.Query;

@EachBean(value=SessionFactory.class)
@TypeHint(value={HibernatePresenceCondition.class})
public class HibernateJpaOperations
implements JpaRepositoryOperations,
AsyncCapableRepository,
ReactiveCapableRepository {
    private static final String ENTITY_GRAPH_FETCH = "javax.persistence.fetchgraph";
    private static final String ENTITY_GRAPH_LOAD = "javax.persistence.loadgraph";
    private static final JpaQueryBuilder QUERY_BUILDER = new JpaQueryBuilder();
    private final SessionFactory sessionFactory;
    private final TransactionOperations<Connection> transactionOperations;
    private ExecutorAsyncOperations asyncOperations;
    private ExecutorService executorService;

    protected HibernateJpaOperations(@NonNull SessionFactory sessionFactory, @Parameter @NonNull TransactionOperations<Connection> transactionOperations, @Named(value="io") @Nullable ExecutorService executorService) {
        ArgumentUtils.requireNonNull((String)"sessionFactory", (Object)sessionFactory);
        this.sessionFactory = sessionFactory;
        this.transactionOperations = transactionOperations;
        this.executorService = executorService;
    }

    @NonNull
    public Map<String, Object> getQueryHints(@NonNull StoredQuery<?, ?> storedQuery) {
        AnnotationMetadata annotationMetadata = storedQuery.getAnnotationMetadata();
        if (annotationMetadata.hasAnnotation(EntityGraph.class)) {
            String hint = annotationMetadata.stringValue(EntityGraph.class, "hint").orElse(ENTITY_GRAPH_FETCH);
            Object[] paths = annotationMetadata.stringValues(EntityGraph.class, "attributePaths");
            if (ArrayUtils.isNotEmpty((Object[])paths)) {
                return Collections.singletonMap(hint, paths);
            }
        }
        return Collections.emptyMap();
    }

    @Nullable
    public <T> T findOne(@NonNull Class<T> type, @NonNull Serializable id) {
        return (T)this.transactionOperations.executeRead(status -> {
            Session session = this.sessionFactory.getCurrentSession();
            return session.byId(type).load(id);
        });
    }

    @Nullable
    public <T, R> R findOne(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (R)this.transactionOperations.executeRead(status -> {
            Class resultType = preparedQuery.getResultType();
            String query = preparedQuery.getQuery();
            Session currentSession = this.sessionFactory.getCurrentSession();
            if (preparedQuery.isDtoProjection()) {
                Object q = preparedQuery.isNative() ? currentSession.createNativeQuery(query, Tuple.class) : currentSession.createQuery(query, Tuple.class);
                this.bindParameters((Query<?>)q, preparedQuery, query);
                this.bindQueryHints((Query<?>)q, (PagedQuery)preparedQuery, currentSession);
                q.setMaxResults(1);
                return q.uniqueResultOptional().map(tuple -> ((BeanIntrospectionMapper)Tuple::get).map(tuple, resultType)).orElse(null);
            }
            Object q = preparedQuery.isNative() ? currentSession.createNativeQuery(query, resultType) : currentSession.createQuery(query, resultType);
            this.bindParameters((Query<?>)q, preparedQuery, query);
            this.bindQueryHints((Query<?>)q, (PagedQuery)preparedQuery, currentSession);
            q.setMaxResults(1);
            return q.uniqueResultOptional().orElse(null);
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T, R> void bindParameters(Query<?> q, @NonNull PreparedQuery<T, R> preparedQuery, String query) {
        String[] parameterNames = preparedQuery.getParameterNames();
        Object[] parameterArray = preparedQuery.getParameterArray();
        int[] indexedParameterBinding = preparedQuery.getIndexedParameterBinding();
        for (int i = 0; i < parameterNames.length; ++i) {
            Object value;
            String parameterName = parameterNames[i];
            int parameterIndex = indexedParameterBinding[i];
            if (parameterIndex > -1) {
                value = parameterArray[parameterIndex];
            } else {
                String propertyPath;
                String[] indexedParameterPaths = preparedQuery.getIndexedParameterPaths();
                String string = propertyPath = i < indexedParameterPaths.length ? indexedParameterPaths[i] : null;
                if (propertyPath == null) throw new IllegalStateException("Invalid query [" + query + "]. Unable to establish parameter value for parameter at name: " + parameterName);
                String lastUpdatedProperty = preparedQuery.getLastUpdatedProperty();
                if (lastUpdatedProperty != null && lastUpdatedProperty.equals(propertyPath)) {
                    Class lastUpdatedType = preparedQuery.getLastUpdatedType();
                    if (lastUpdatedType == null) {
                        throw new IllegalStateException("Could not establish last updated time for entity: " + preparedQuery.getRootEntity());
                    }
                    Object timestamp = ConversionService.SHARED.convert((Object)OffsetDateTime.now(), lastUpdatedType).orElse(null);
                    if (timestamp == null) {
                        throw new IllegalStateException("Unsupported date type: " + lastUpdatedType);
                    }
                    value = timestamp;
                } else {
                    int j = propertyPath.indexOf(46);
                    if (j <= -1) throw new IllegalStateException("Invalid query [" + query + "]. Unable to establish parameter value for parameter at position: " + (i + 1));
                    String subProp = propertyPath.substring(j + 1);
                    value = parameterArray[Integer.valueOf(propertyPath.substring(0, j))];
                    value = BeanWrapper.getWrapper((Object)value).getRequiredProperty(subProp, Argument.OBJECT_ARGUMENT);
                }
            }
            q.setParameter(parameterName, value);
        }
    }

    public <T, R> boolean exists(@NonNull PreparedQuery<T, R> preparedQuery) {
        return this.findOne(preparedQuery) != null;
    }

    @NonNull
    public <T> Iterable<T> findAll(@NonNull PagedQuery<T> query) {
        return (Iterable)this.transactionOperations.executeRead(status -> {
            Session session = this.getCurrentSession();
            CriteriaBuilder criteriaBuilder = session.getCriteriaBuilder();
            Query q = this.buildCriteriaQuery(session, query.getRootEntity(), criteriaBuilder, query.getPageable());
            this.bindQueryHints(q, query, session);
            return q.list();
        });
    }

    public <T> long count(PagedQuery<T> pagedQuery) {
        return (Long)this.transactionOperations.executeRead(status -> {
            Session session = this.getCurrentSession();
            CriteriaBuilder criteriaBuilder = session.getCriteriaBuilder();
            CriteriaQuery query = criteriaBuilder.createQuery(Long.class);
            Root root = query.from(pagedQuery.getRootEntity());
            query = query.select((Selection)criteriaBuilder.count((Expression)root));
            Query q = session.createQuery(query);
            Pageable pageable = pagedQuery.getPageable();
            this.bindCriteriaSort(query, root, criteriaBuilder, (Sort)pageable);
            this.bindPageable(q, pageable);
            this.bindQueryHints(q, pagedQuery, session);
            return (Long)q.getSingleResult();
        });
    }

    @NonNull
    public <T, R> Iterable<R> findAll(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (Iterable)this.transactionOperations.executeRead(status -> {
            Sort sort;
            Session entityManager = this.sessionFactory.getCurrentSession();
            String queryStr = preparedQuery.getQuery();
            Pageable pageable = preparedQuery.getPageable();
            if (pageable != Pageable.UNPAGED && (sort = pageable.getSort()).isSorted()) {
                queryStr = queryStr + QUERY_BUILDER.buildOrderBy((PersistentEntity)this.getEntity(preparedQuery.getRootEntity()), sort).getQuery();
            }
            if (preparedQuery.isDtoProjection()) {
                Object q = preparedQuery.isNative() ? entityManager.createNativeQuery(queryStr, Tuple.class) : entityManager.createQuery(queryStr, Tuple.class);
                this.bindPreparedQuery((Query<?>)q, preparedQuery, entityManager, queryStr);
                return q.stream().map(tuple -> ((BeanIntrospectionMapper)Tuple::get).map(tuple, preparedQuery.getResultType())).collect(Collectors.toList());
            }
            Class wrapperType = ReflectionUtils.getWrapperType((Class)preparedQuery.getResultType());
            Object q = preparedQuery.isNative() ? entityManager.createNativeQuery(queryStr, wrapperType) : entityManager.createQuery(queryStr, wrapperType);
            this.bindPreparedQuery((Query<?>)q, preparedQuery, entityManager, queryStr);
            return q.list();
        });
    }

    private <T, R> void bindPreparedQuery(Query<?> q, @NonNull PreparedQuery<T, R> preparedQuery, Session currentSession, String query) {
        this.bindParameters(q, preparedQuery, query);
        this.bindPageable(q, preparedQuery.getPageable());
        this.bindQueryHints(q, (PagedQuery<T>)preparedQuery, currentSession);
    }

    private <T> void bindQueryHints(Query<?> q, @NonNull PagedQuery<T> preparedQuery, @NonNull Session session) {
        Map queryHints = preparedQuery.getQueryHints();
        if (CollectionUtils.isNotEmpty((Map)queryHints)) {
            for (Map.Entry entry : queryHints.entrySet()) {
                String hintName = (String)entry.getKey();
                Object value = entry.getValue();
                if (ENTITY_GRAPH_FETCH.equals(hintName) || ENTITY_GRAPH_LOAD.equals(hintName)) {
                    Object[] paths;
                    String graphName = preparedQuery.getAnnotationMetadata().stringValue(EntityGraph.class).orElse(null);
                    if (graphName != null) {
                        RootGraph entityGraph = session.getEntityGraph(graphName);
                        q.setHint(hintName, (Object)entityGraph);
                        continue;
                    }
                    if (!(value instanceof String[]) || !ArrayUtils.isNotEmpty((Object[])(paths = (String[])value))) continue;
                    RootGraph entityGraph = session.createEntityGraph(preparedQuery.getRootEntity());
                    entityGraph.addAttributeNodes((String[])paths);
                    q.setHint(hintName, (Object)entityGraph);
                    continue;
                }
                q.setHint(hintName, value);
            }
        }
    }

    public <T> T persist(@NonNull InsertOperation<T> operation) {
        return (T)this.transactionOperations.executeWrite(status -> {
            Object entity = operation.getEntity();
            Session entityManager = this.sessionFactory.getCurrentSession();
            entityManager.persist(entity);
            this.flushIfNecessary((EntityManager)entityManager, operation.getAnnotationMetadata());
            return entity;
        });
    }

    @NonNull
    public <T> T update(@NonNull UpdateOperation<T> operation) {
        return (T)this.transactionOperations.executeWrite(status -> {
            Object entity = operation.getEntity();
            Session session = this.sessionFactory.getCurrentSession();
            entity = session.merge(entity);
            this.flushIfNecessary((EntityManager)session, operation.getAnnotationMetadata());
            return entity;
        });
    }

    @NonNull
    public <T> Iterable<T> persistAll(@NonNull BatchOperation<T> operation) {
        return (Iterable)this.transactionOperations.executeWrite(status -> {
            if (operation != null) {
                Session entityManager = this.sessionFactory.getCurrentSession();
                for (Object entity : operation) {
                    entityManager.persist(entity);
                }
                AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
                this.flushIfNecessary((EntityManager)entityManager, annotationMetadata);
                return operation;
            }
            return Collections.emptyList();
        });
    }

    private void flushIfNecessary(EntityManager entityManager, AnnotationMetadata annotationMetadata) {
        FlushModeType flushModeType;
        if (annotationMetadata.hasAnnotation(QueryHint.class) && (flushModeType = this.getFlushModeType(annotationMetadata)) == FlushModeType.AUTO) {
            entityManager.flush();
        }
    }

    @NonNull
    public Optional<Number> executeUpdate(@NonNull PreparedQuery<?, Number> preparedQuery) {
        return (Optional)this.transactionOperations.executeWrite(status -> {
            String query = preparedQuery.getQuery();
            Query q = this.getCurrentSession().createQuery(query);
            this.bindParameters(q, preparedQuery, query);
            return Optional.of(q.executeUpdate());
        });
    }

    public <T> Optional<Number> deleteAll(@NonNull BatchOperation<T> operation) {
        if (operation.all()) {
            return (Optional)this.transactionOperations.executeWrite(status -> {
                Class entityType = operation.getRootEntity();
                Session session = this.getCurrentSession();
                CriteriaDelete criteriaDelete = session.getCriteriaBuilder().createCriteriaDelete(entityType);
                criteriaDelete.from(entityType);
                Query query = session.createQuery(criteriaDelete);
                return Optional.of(query.executeUpdate());
            });
        }
        Integer result = (Integer)this.transactionOperations.executeWrite(status -> {
            int i = 0;
            Session session = this.getCurrentSession();
            for (Object entity : operation) {
                session.remove(entity);
                ++i;
            }
            return i;
        });
        return Optional.ofNullable(result);
    }

    @NonNull
    public <T, R> Stream<R> findStream(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (Stream)this.transactionOperations.executeRead(status -> {
            String query = preparedQuery.getQuery();
            Map parameterValues = preparedQuery.getParameterValues();
            Pageable pageable = preparedQuery.getPageable();
            Session currentSession = this.getCurrentSession();
            if (preparedQuery.isDtoProjection()) {
                Object q = preparedQuery.isNative() ? currentSession.createNativeQuery(query, Tuple.class) : currentSession.createQuery(query, Tuple.class);
                this.bindParameters((Query<?>)q, preparedQuery, query);
                this.bindPageable((Query)q, pageable);
                return q.stream().map(tuple -> ((BeanIntrospectionMapper)Tuple::get).map(tuple, preparedQuery.getResultType()));
            }
            Class wrapperType = ReflectionUtils.getWrapperType((Class)preparedQuery.getResultType());
            Object q = preparedQuery.isNative() ? currentSession.createNativeQuery(query, wrapperType) : currentSession.createQuery(query, wrapperType);
            this.bindParameters((Query<?>)q, preparedQuery, query);
            this.bindPageable((Query)q, pageable);
            return q.stream();
        });
    }

    @NonNull
    public <T> Stream<T> findStream(@NonNull PagedQuery<T> pagedQuery) {
        Session session = this.getCurrentSession();
        Class entity = pagedQuery.getRootEntity();
        CriteriaQuery query = session.getCriteriaBuilder().createQuery(entity);
        query.from(entity);
        Query q = session.createQuery(query);
        this.bindPageable(q, pagedQuery.getPageable());
        return q.stream();
    }

    public <R> Page<R> findPage(@NonNull PagedQuery<R> query) {
        return (Page)this.transactionOperations.executeRead(status -> {
            Session session = this.getCurrentSession();
            CriteriaBuilder criteriaBuilder = session.getCriteriaBuilder();
            Class entity = query.getRootEntity();
            Pageable pageable = query.getPageable();
            Query q = this.buildCriteriaQuery(session, entity, criteriaBuilder, pageable);
            List resultList = q.list();
            CriteriaQuery countQuery = criteriaBuilder.createQuery(Long.class);
            countQuery.select((Selection)criteriaBuilder.count((Expression)countQuery.from(entity)));
            Long total = (Long)session.createQuery(countQuery).getSingleResult();
            return Page.of((List)resultList, (Pageable)pageable, (long)total);
        });
    }

    private Session getCurrentSession() {
        return this.sessionFactory.getCurrentSession();
    }

    private FlushModeType getFlushModeType(AnnotationMetadata annotationMetadata) {
        return annotationMetadata.getAnnotationValuesByType(QueryHint.class).stream().filter(av -> FlushModeType.class.getName().equals(av.stringValue("name").orElse(null))).map(av -> av.enumValue("value", FlushModeType.class)).findFirst().orElse(Optional.empty()).orElse(null);
    }

    private <T> Query<T> buildCriteriaQuery(Session session, @NonNull Class<T> rootEntity, CriteriaBuilder criteriaBuilder, @NonNull Pageable pageable) {
        CriteriaQuery query = criteriaBuilder.createQuery(rootEntity);
        Root root = query.from(rootEntity);
        this.bindCriteriaSort(query, root, criteriaBuilder, (Sort)pageable);
        Query q = session.createQuery(query);
        this.bindPageable(q, pageable);
        return q;
    }

    private <T> void bindPageable(Query<T> q, @NonNull Pageable pageable) {
        long offset;
        if (pageable == Pageable.UNPAGED) {
            return;
        }
        int max = pageable.getSize();
        if (max > 0) {
            q.setMaxResults(max);
        }
        if ((offset = pageable.getOffset()) > 0L) {
            q.setFirstResult((int)offset);
        }
    }

    private <T> void bindCriteriaSort(CriteriaQuery<T> criteriaQuery, Root<?> root, CriteriaBuilder builder, @NonNull Sort sort) {
        block3: for (Sort.Order order : sort.getOrderBy()) {
            Path path = root.get(order.getProperty());
            Path expression = order.isIgnoreCase() ? builder.lower((Expression)path) : path;
            switch (order.getDirection()) {
                case DESC: {
                    criteriaQuery.orderBy(new Order[]{builder.desc((Expression)expression)});
                    continue block3;
                }
            }
            criteriaQuery.orderBy(new Order[]{builder.asc((Expression)expression)});
        }
    }

    @NonNull
    private ExecutorService newLocalThreadPool() {
        this.executorService = Executors.newCachedThreadPool();
        return this.executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ExecutorAsyncOperations async() {
        ExecutorAsyncOperations asyncOperations = this.asyncOperations;
        if (asyncOperations == null) {
            HibernateJpaOperations hibernateJpaOperations = this;
            synchronized (hibernateJpaOperations) {
                asyncOperations = this.asyncOperations;
                if (asyncOperations == null) {
                    this.asyncOperations = asyncOperations = new ExecutorAsyncOperations((RepositoryOperations)this, (Executor)(this.executorService != null ? this.executorService : this.newLocalThreadPool()));
                }
            }
        }
        return asyncOperations;
    }

    @NonNull
    public ReactiveRepositoryOperations reactive() {
        return new ExecutorReactiveOperations(this.async());
    }

    @Override
    @NonNull
    public EntityManager getCurrentEntityManager() {
        return this.sessionFactory.getCurrentSession();
    }

    @Override
    @NonNull
    public EntityManagerFactory getEntityManagerFactory() {
        return this.sessionFactory;
    }

    @Override
    public void flush() {
        this.transactionOperations.executeWrite(status -> {
            this.sessionFactory.getCurrentSession().flush();
            return null;
        });
    }
}

