/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.runtime;

import io.micronaut.configuration.hibernate.jpa.EntityManagerFactoryBean;
import io.micronaut.configuration.hibernate.jpa.JpaConfiguration;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.transaction.hibernate5.MicronautSessionContext;
import io.micronaut.transaction.jdbc.DelegatingDataSource;
import java.util.LinkedHashMap;
import javax.sql.DataSource;
import org.hibernate.boot.registry.StandardServiceRegistry;

@Factory
public class DataEntityManagerFactoryBean {
    private final JpaConfiguration jpaConfiguration;
    private final BeanLocator beanLocator;

    public DataEntityManagerFactoryBean(JpaConfiguration jpaConfiguration, BeanLocator beanLocator) {
        this.jpaConfiguration = jpaConfiguration;
        this.beanLocator = beanLocator;
    }

    @EachBean(value=DataSource.class)
    @Replaces(factory=EntityManagerFactoryBean.class, bean=StandardServiceRegistry.class)
    @Requires(missingClasses={"org.springframework.orm.hibernate5.HibernateTransactionManager"})
    protected StandardServiceRegistry hibernateStandardServiceRegistry(@Parameter String dataSourceName, DataSource dataSource) {
        if (dataSource instanceof DelegatingDataSource) {
            dataSource = ((DelegatingDataSource)dataSource).getTargetDataSource();
        }
        LinkedHashMap<String, Object> additionalSettings = new LinkedHashMap<String, Object>();
        additionalSettings.put("hibernate.connection.datasource", dataSource);
        additionalSettings.put("hibernate.current_session_context_class", MicronautSessionContext.class.getName());
        additionalSettings.put("hibernate.session_factory_name", dataSourceName);
        additionalSettings.put("hibernate.session_factory_name_is_jndi", false);
        JpaConfiguration jpaConfiguration = this.beanLocator.findBean(JpaConfiguration.class, Qualifiers.byName((String)dataSourceName)).orElse(this.jpaConfiguration);
        return jpaConfiguration.buildStandardServiceRegistry(additionalSettings);
    }
}

