/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.event;

import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.data.event.EntityEventListener;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.runtime.event.DefaultEntityEventContext;
import java.io.Serializable;
import javax.inject.Singleton;
import org.hibernate.boot.Metadata;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.AbstractPreDatabaseOperationEvent;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.event.spi.PreDeleteEventListener;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.hibernate.tuple.entity.EntityMetamodel;

@Primary
@Singleton
@Internal
public class EventIntegrator
implements Integrator {
    private final RuntimeEntityRegistry entityRegistry;

    public EventIntegrator(RuntimeEntityRegistry entityRegistry) {
        this.entityRegistry = entityRegistry;
    }

    public void integrate(Metadata metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        EventListenerRegistry eventListenerRegistry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
        final EntityEventListener entityEventListener = this.entityRegistry.getEntityEventListener();
        eventListenerRegistry.getEventListenerGroup(EventType.PRE_INSERT).appendListener((PreInsertEventListener & Serializable)event -> {
            Class mappedClass = event.getPersister().getMappedClass();
            if (EventIntegrator.isNotSupportedMappedClass(mappedClass)) {
                return false;
            }
            RuntimePersistentEntity entity = this.entityRegistry.getEntity(mappedClass);
            if (entity.hasPrePersistEventListeners()) {
                Object[] state = event.getState();
                StatefulHibernateEventContext context = new StatefulHibernateEventContext(entity, (AbstractPreDatabaseOperationEvent)event, state);
                return !entityEventListener.prePersist(context);
            }
            return false;
        });
        eventListenerRegistry.getEventListenerGroup(EventType.POST_INSERT).appendListener((Object)new PostInsertEventListener(){

            public void onPostInsert(PostInsertEvent event) {
                Class mappedClass = event.getPersister().getMappedClass();
                if (EventIntegrator.isNotSupportedMappedClass(mappedClass)) {
                    return;
                }
                RuntimePersistentEntity entity = EventIntegrator.this.entityRegistry.getEntity(mappedClass);
                if (entity.hasPostPersistEventListeners()) {
                    SimpleHibernateEventContext<Object> context = new SimpleHibernateEventContext<Object>(entity, event.getEntity());
                    entityEventListener.postPersist(context);
                }
            }

            public boolean requiresPostCommitHanding(EntityPersister persister) {
                return false;
            }
        });
        eventListenerRegistry.getEventListenerGroup(EventType.PRE_DELETE).appendListener((PreDeleteEventListener & Serializable)event -> {
            Class mappedClass = event.getPersister().getMappedClass();
            if (EventIntegrator.isNotSupportedMappedClass(mappedClass)) {
                return false;
            }
            RuntimePersistentEntity entity = this.entityRegistry.getEntity(mappedClass);
            if (entity.hasPreRemoveEventListeners()) {
                Object[] state = event.getDeletedState();
                StatefulHibernateEventContext context = new StatefulHibernateEventContext(entity, (AbstractPreDatabaseOperationEvent)event, state);
                return !entityEventListener.preRemove(context);
            }
            return false;
        });
        eventListenerRegistry.getEventListenerGroup(EventType.POST_DELETE).appendListener((Object)new PostDeleteEventListener(){

            public boolean requiresPostCommitHanding(EntityPersister persister) {
                return false;
            }

            public void onPostDelete(PostDeleteEvent event) {
                Class mappedClass = event.getPersister().getMappedClass();
                if (EventIntegrator.isNotSupportedMappedClass(mappedClass)) {
                    return;
                }
                RuntimePersistentEntity entity = EventIntegrator.this.entityRegistry.getEntity(mappedClass);
                if (entity.hasPostPersistEventListeners()) {
                    SimpleHibernateEventContext<Object> context = new SimpleHibernateEventContext<Object>(entity, event.getEntity());
                    entityEventListener.postRemove(context);
                }
            }
        });
        eventListenerRegistry.getEventListenerGroup(EventType.PRE_UPDATE).appendListener((PreUpdateEventListener & Serializable)event -> {
            Class mappedClass = event.getPersister().getMappedClass();
            if (EventIntegrator.isNotSupportedMappedClass(mappedClass)) {
                return false;
            }
            RuntimePersistentEntity entity = this.entityRegistry.getEntity(mappedClass);
            if (entity.hasPreUpdateEventListeners()) {
                Object[] state = event.getState();
                StatefulHibernateEventContext context = new StatefulHibernateEventContext(entity, (AbstractPreDatabaseOperationEvent)event, state);
                return !entityEventListener.preUpdate(context);
            }
            return false;
        });
        eventListenerRegistry.getEventListenerGroup(EventType.POST_UPDATE).appendListener((Object)new PostUpdateEventListener(){

            public boolean requiresPostCommitHanding(EntityPersister persister) {
                return false;
            }

            public void onPostUpdate(PostUpdateEvent event) {
                Class mappedClass = event.getPersister().getMappedClass();
                if (EventIntegrator.isNotSupportedMappedClass(mappedClass)) {
                    return;
                }
                RuntimePersistentEntity entity = EventIntegrator.this.entityRegistry.getEntity(mappedClass);
                if (entity.hasPostPersistEventListeners()) {
                    SimpleHibernateEventContext<Object> context = new SimpleHibernateEventContext<Object>(entity, event.getEntity());
                    entityEventListener.postUpdate(context);
                }
            }
        });
        eventListenerRegistry.getEventListenerGroup(EventType.POST_LOAD).appendListener((PostLoadEventListener & Serializable)event -> {
            Class mappedClass = event.getPersister().getMappedClass();
            if (EventIntegrator.isNotSupportedMappedClass(mappedClass)) {
                return;
            }
            RuntimePersistentEntity entity = this.entityRegistry.getEntity(mappedClass);
            if (entity.hasPreUpdateEventListeners()) {
                SimpleHibernateEventContext<Object> context = new SimpleHibernateEventContext<Object>(entity, event.getEntity());
                entityEventListener.postLoad(context);
            }
        });
    }

    private static boolean isNotSupportedMappedClass(Class<?> clazz) {
        return !BeanIntrospector.SHARED.findIntrospection(clazz).isPresent();
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    private static class SimpleHibernateEventContext<T>
    extends DefaultEntityEventContext<T> {
        public SimpleHibernateEventContext(RuntimePersistentEntity<T> entity, T object) {
            super(entity, object);
        }

        public final boolean supportsEventSystem() {
            return false;
        }
    }

    private static class StatefulHibernateEventContext<T>
    extends DefaultEntityEventContext<T> {
        private final AbstractPreDatabaseOperationEvent event;
        private final Object[] state;

        public StatefulHibernateEventContext(RuntimePersistentEntity<T> entity, AbstractPreDatabaseOperationEvent event, Object[] state) {
            super(entity, event.getEntity());
            this.event = event;
            this.state = state;
        }

        public <P> void setProperty(BeanProperty<T, P> property, P newValue) {
            super.setProperty(property, newValue);
            EntityMetamodel entityMetamodel = this.event.getPersister().getEntityMetamodel();
            int i = entityMetamodel.getPropertyIndex(property.getName());
            this.state[i] = newValue;
        }

        public final boolean supportsEventSystem() {
            return false;
        }
    }
}

