/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.operations;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.annotation.QueryHint;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.jpa.annotation.EntityGraph;
import io.micronaut.data.jpa.operations.JpaRepositoryOperations;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.builder.jpa.JpaQueryBuilder;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.async.AsyncCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveRepositoryOperations;
import io.micronaut.data.runtime.mapper.BeanIntrospectionMapper;
import io.micronaut.data.runtime.operations.ExecutorAsyncOperations;
import io.micronaut.data.runtime.operations.ExecutorReactiveOperations;
import io.micronaut.jdbc.spring.HibernatePresenceCondition;
import io.micronaut.transaction.TransactionOperations;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.SubGraph;
import org.hibernate.query.NativeQuery;
import org.hibernate.type.Type;

@EachBean(value=SessionFactory.class)
@TypeHint(value={HibernatePresenceCondition.class})
public class HibernateJpaOperations
implements JpaRepositoryOperations,
AsyncCapableRepository,
ReactiveCapableRepository {
    private static final String ENTITY_GRAPH_FETCH = "javax.persistence.fetchgraph";
    private static final String ENTITY_GRAPH_LOAD = "javax.persistence.loadgraph";
    private static final JpaQueryBuilder QUERY_BUILDER = new JpaQueryBuilder();
    private final SessionFactory sessionFactory;
    private final TransactionOperations<Connection> transactionOperations;
    private final RuntimeEntityRegistry runtimeEntityRegistry;
    private ExecutorAsyncOperations asyncOperations;
    private ExecutorService executorService;

    protected HibernateJpaOperations(@NonNull SessionFactory sessionFactory, @NonNull @Parameter TransactionOperations<Connection> transactionOperations, @Named(value="io") @Nullable ExecutorService executorService, RuntimeEntityRegistry runtimeEntityRegistry) {
        ArgumentUtils.requireNonNull((String)"sessionFactory", (Object)sessionFactory);
        this.runtimeEntityRegistry = runtimeEntityRegistry;
        this.sessionFactory = sessionFactory;
        this.transactionOperations = transactionOperations;
        this.executorService = executorService;
    }

    public ApplicationContext getApplicationContext() {
        return this.runtimeEntityRegistry.getApplicationContext();
    }

    @NonNull
    public Map<String, Object> getQueryHints(@NonNull StoredQuery<?, ?> storedQuery) {
        AnnotationMetadata annotationMetadata = storedQuery.getAnnotationMetadata();
        if (annotationMetadata.hasAnnotation(EntityGraph.class)) {
            String hint = annotationMetadata.stringValue(EntityGraph.class, "hint").orElse(ENTITY_GRAPH_FETCH);
            Object[] paths = annotationMetadata.stringValues(EntityGraph.class, "attributePaths");
            if (ArrayUtils.isNotEmpty((Object[])paths)) {
                return Collections.singletonMap(hint, paths);
            }
        }
        return Collections.emptyMap();
    }

    @Nullable
    public <T> T findOne(@NonNull Class<T> type, @NonNull Serializable id) {
        return (T)this.transactionOperations.executeRead(status -> {
            Session session = this.sessionFactory.getCurrentSession();
            return session.byId(type).load(id);
        });
    }

    @Override
    @NonNull
    public <T> T load(@NonNull Class<T> type, @NonNull Serializable id) {
        return (T)this.transactionOperations.executeRead(status -> {
            Session session = this.sessionFactory.getCurrentSession();
            return session.load(type, id);
        });
    }

    @Nullable
    public <T, R> R findOne(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (R)this.transactionOperations.executeRead(status -> {
            Class resultType = preparedQuery.getResultType();
            String query = preparedQuery.getQuery();
            Session currentSession = this.sessionFactory.getCurrentSession();
            if (preparedQuery.isDtoProjection()) {
                NativeQuery q;
                if (preparedQuery.isNative()) {
                    q = currentSession.createNativeQuery(query, Tuple.class);
                } else {
                    if (query.toLowerCase(Locale.ENGLISH).startsWith("select new ")) {
                        org.hibernate.query.Query dtoQuery = currentSession.createQuery(query, resultType);
                        this.bindParameters(dtoQuery, preparedQuery, query);
                        this.bindQueryHints((org.hibernate.query.Query<?>)dtoQuery, (PagedQuery)preparedQuery, currentSession);
                        return dtoQuery.uniqueResult();
                    }
                    q = currentSession.createQuery(query, Tuple.class);
                }
                this.bindParameters((org.hibernate.query.Query<?>)q, preparedQuery, query);
                this.bindQueryHints((org.hibernate.query.Query<?>)q, (PagedQuery)preparedQuery, currentSession);
                Tuple tuple = (Tuple)this.first(q.list().iterator());
                if (tuple != null) {
                    return ((BeanIntrospectionMapper)Tuple::get).map((Object)tuple, resultType);
                }
                return null;
            }
            Object q = preparedQuery.isNative() ? (DataType.ENTITY.equals((Object)preparedQuery.getResultDataType()) ? currentSession.createNativeQuery(query, resultType) : currentSession.createNativeQuery(query)) : currentSession.createQuery(query, resultType);
            this.bindParameters((org.hibernate.query.Query<?>)q, preparedQuery, query);
            this.bindQueryHints((org.hibernate.query.Query<?>)q, (PagedQuery)preparedQuery, currentSession);
            return this.first(q.list().iterator());
        });
    }

    private <T> T first(Iterator<T> iterator) {
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    private <T, R> void bindParameters(org.hibernate.query.Query<?> q, @NonNull PreparedQuery<T, R> preparedQuery, String query) {
        String[] parameterNames = preparedQuery.getParameterNames();
        Object[] parameterArray = preparedQuery.getParameterArray();
        int[] indexedParameterBinding = preparedQuery.getIndexedParameterBinding();
        for (int i = 0; i < parameterNames.length; ++i) {
            Object value;
            String parameterName = parameterNames[i];
            int parameterIndex = indexedParameterBinding[i];
            if (parameterIndex > -1) {
                value = parameterArray[parameterIndex];
            } else {
                String[] indexedParameterAutoPopulatedPropertyPaths = preparedQuery.getIndexedParameterAutoPopulatedPropertyPaths();
                String[] indexedParameterPaths = preparedQuery.getIndexedParameterPaths();
                String propertyPath = i < indexedParameterPaths.length ? indexedParameterPaths[i] : null;
                String autoPopulatedPropertyPath = indexedParameterAutoPopulatedPropertyPaths[i];
                if (autoPopulatedPropertyPath != null) {
                    RuntimePersistentEntity persistentEntity = this.getEntity(preparedQuery.getRootEntity());
                    RuntimePersistentProperty persistentProperty = persistentEntity.getPropertyByName(autoPopulatedPropertyPath);
                    if (persistentProperty == null) {
                        throw new IllegalStateException("Cannot find auto populated property: " + autoPopulatedPropertyPath);
                    }
                    Object previousValue = null;
                    if (propertyPath != null) {
                        previousValue = this.resolveQueryParameterByPath(query, i, parameterArray, propertyPath);
                    }
                    value = this.runtimeEntityRegistry.autoPopulateRuntimeProperty(persistentProperty, previousValue);
                } else if (propertyPath != null) {
                    value = this.resolveQueryParameterByPath(query, i, parameterArray, propertyPath);
                } else {
                    throw new IllegalStateException("Invalid query [" + query + "]. Unable to establish parameter value for parameter at name: " + parameterName);
                }
            }
            if (preparedQuery.isNative()) {
                Argument argument = preparedQuery.getArguments()[parameterIndex];
                Class argumentType = argument.getType();
                if (Collection.class.isAssignableFrom(argumentType)) {
                    Type valueType = this.sessionFactory.getTypeHelper().heuristicType(argument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT).getType().getName());
                    if (valueType != null) {
                        q.setParameterList(parameterName, value == null ? Collections.emptyList() : (Collection)value, valueType);
                        return;
                    }
                } else {
                    Type type;
                    if (Object[].class.isAssignableFrom(argumentType)) {
                        q.setParameterList(parameterName, value == null ? ArrayUtils.EMPTY_OBJECT_ARRAY : (Object[])value);
                        return;
                    }
                    if (value == null && (type = this.sessionFactory.getTypeHelper().heuristicType(argumentType.getName())) != null) {
                        q.setParameter(parameterName, null, type);
                        return;
                    }
                }
            }
            q.setParameter(parameterName, value);
        }
    }

    private Object resolveQueryParameterByPath(String query, int i, Object[] queryParameters, String propertyPath) {
        int j = propertyPath.indexOf(46);
        if (j > -1) {
            String subProp = propertyPath.substring(j + 1);
            Object indexedValue = queryParameters[Integer.parseInt(propertyPath.substring(0, j))];
            return BeanWrapper.getWrapper((Object)indexedValue).getRequiredProperty(subProp, Argument.OBJECT_ARGUMENT);
        }
        throw new IllegalStateException("Invalid query [" + query + "]. Unable to establish parameter value for parameter at position: " + (i + 1));
    }

    public <T> boolean exists(@NonNull PreparedQuery<T, Boolean> preparedQuery) {
        return this.findOne(preparedQuery) != null;
    }

    @NonNull
    public <T> Iterable<T> findAll(@NonNull PagedQuery<T> query) {
        return (Iterable)this.transactionOperations.executeRead(status -> {
            Session session = this.getCurrentSession();
            CriteriaBuilder criteriaBuilder = session.getCriteriaBuilder();
            org.hibernate.query.Query q = this.buildCriteriaQuery(session, query.getRootEntity(), criteriaBuilder, query.getPageable());
            this.bindQueryHints(q, query, session);
            return q.list();
        });
    }

    public <T> long count(PagedQuery<T> pagedQuery) {
        return (Long)this.transactionOperations.executeRead(status -> {
            Session session = this.getCurrentSession();
            CriteriaBuilder criteriaBuilder = session.getCriteriaBuilder();
            CriteriaQuery query = criteriaBuilder.createQuery(Long.class);
            Root root = query.from(pagedQuery.getRootEntity());
            query = query.select((Selection)criteriaBuilder.count((Expression)root));
            org.hibernate.query.Query q = session.createQuery(query);
            Pageable pageable = pagedQuery.getPageable();
            this.bindCriteriaSort(query, root, criteriaBuilder, (Sort)pageable);
            this.bindPageable(q, pageable);
            this.bindQueryHints(q, pagedQuery, session);
            return (Long)q.getSingleResult();
        });
    }

    @NonNull
    public <T, R> Iterable<R> findAll(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (Iterable)this.transactionOperations.executeRead(status -> {
            Sort sort;
            Session entityManager = this.sessionFactory.getCurrentSession();
            String queryStr = preparedQuery.getQuery();
            Pageable pageable = preparedQuery.getPageable();
            if (pageable != Pageable.UNPAGED && (sort = pageable.getSort()).isSorted()) {
                queryStr = queryStr + QUERY_BUILDER.buildOrderBy((PersistentEntity)this.getEntity(preparedQuery.getRootEntity()), sort).getQuery();
            }
            if (preparedQuery.isDtoProjection()) {
                NativeQuery q;
                if (preparedQuery.isNative()) {
                    q = entityManager.createNativeQuery(queryStr, Tuple.class);
                } else {
                    if (queryStr.toLowerCase(Locale.ENGLISH).startsWith("select new ")) {
                        Class wrapperType = ReflectionUtils.getWrapperType((Class)preparedQuery.getResultType());
                        org.hibernate.query.Query query = entityManager.createQuery(queryStr, wrapperType);
                        this.bindPreparedQuery(query, preparedQuery, entityManager, queryStr);
                        return query.list();
                    }
                    q = entityManager.createQuery(queryStr, Tuple.class);
                }
                this.bindPreparedQuery((org.hibernate.query.Query<?>)q, preparedQuery, entityManager, queryStr);
                return q.stream().map(tuple -> {
                    Set properties = tuple.getElements().stream().map(TupleElement::getAlias).collect(Collectors.toSet());
                    return ((BeanIntrospectionMapper)(tuple1, alias) -> {
                        if (!properties.contains(alias)) {
                            return null;
                        }
                        return tuple1.get(alias);
                    }).map(tuple, preparedQuery.getResultType());
                }).collect(Collectors.toList());
            }
            Class wrapperType = ReflectionUtils.getWrapperType((Class)preparedQuery.getResultType());
            Object q = preparedQuery.isNative() ? entityManager.createNativeQuery(queryStr, wrapperType) : entityManager.createQuery(queryStr, wrapperType);
            this.bindPreparedQuery((org.hibernate.query.Query<?>)q, preparedQuery, entityManager, queryStr);
            return q.list();
        });
    }

    private <T, R> void bindPreparedQuery(org.hibernate.query.Query<?> q, @NonNull PreparedQuery<T, R> preparedQuery, Session currentSession, String query) {
        this.bindParameters(q, preparedQuery, query);
        this.bindPageable(q, preparedQuery.getPageable());
        this.bindQueryHints(q, (PagedQuery<T>)preparedQuery, currentSession);
    }

    private <T> void bindQueryHints(org.hibernate.query.Query<?> q, @NonNull PagedQuery<T> preparedQuery, @NonNull Session session) {
        Map queryHints = preparedQuery.getQueryHints();
        if (CollectionUtils.isNotEmpty((Map)queryHints)) {
            for (Map.Entry entry : queryHints.entrySet()) {
                String hintName = (String)entry.getKey();
                Object value = entry.getValue();
                if (ENTITY_GRAPH_FETCH.equals(hintName) || ENTITY_GRAPH_LOAD.equals(hintName)) {
                    Object[] pathsDefinitions;
                    String graphName = preparedQuery.getAnnotationMetadata().stringValue(EntityGraph.class).orElse(null);
                    if (graphName != null) {
                        RootGraph entityGraph = session.getEntityGraph(graphName);
                        q.setHint(hintName, (Object)entityGraph);
                        continue;
                    }
                    if (!(value instanceof String[]) || !ArrayUtils.isNotEmpty((Object[])(pathsDefinitions = (String[])value))) continue;
                    RootGraph entityGraph = session.createEntityGraph(preparedQuery.getRootEntity());
                    for (Object pathsDefinition : pathsDefinitions) {
                        String[] paths = ((String)pathsDefinition).split("\\.");
                        if (paths.length == 1) {
                            entityGraph.addAttributeNode(paths[0]);
                            continue;
                        }
                        SubGraph subGraph = null;
                        for (int i = 0; i < paths.length; ++i) {
                            String path = paths[i];
                            if (subGraph == null) {
                                if (i + 1 == paths.length) {
                                    entityGraph.addAttributeNode(path);
                                    continue;
                                }
                                subGraph = entityGraph.addSubGraph(path);
                                continue;
                            }
                            if (i + 1 == paths.length) {
                                subGraph.addAttributeNode(path);
                                continue;
                            }
                            subGraph = subGraph.addSubGraph(path);
                        }
                    }
                    q.setHint(hintName, (Object)entityGraph);
                    continue;
                }
                q.setHint(hintName, value);
            }
        }
    }

    public <T> T persist(@NonNull InsertOperation<T> operation) {
        return (T)this.transactionOperations.executeWrite(status -> {
            Object entity = operation.getEntity();
            Session entityManager = this.sessionFactory.getCurrentSession();
            entityManager.persist(entity);
            this.flushIfNecessary((EntityManager)entityManager, operation.getAnnotationMetadata());
            return entity;
        });
    }

    @NonNull
    public <T> T update(@NonNull UpdateOperation<T> operation) {
        AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
        String queryString = annotationMetadata.stringValue(Query.class).orElse(null);
        return (T)this.transactionOperations.executeWrite(status -> {
            if (queryString != null) {
                this.executeEntityUpdate(annotationMetadata, queryString, operation.getEntity());
                return operation.getEntity();
            }
            Object entity = operation.getEntity();
            Session session = this.sessionFactory.getCurrentSession();
            entity = session.merge(entity);
            this.flushIfNecessary((EntityManager)session, operation.getAnnotationMetadata());
            return entity;
        });
    }

    @NonNull
    public <T> Iterable<T> updateAll(@NonNull UpdateBatchOperation<T> operation) {
        AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
        String queryString = annotationMetadata.stringValue(Query.class).orElse(null);
        return (Iterable)this.transactionOperations.executeWrite(status -> {
            if (queryString != null) {
                for (Object entity : operation) {
                    this.executeEntityUpdate(annotationMetadata, queryString, entity);
                }
                return operation;
            }
            Session entityManager = this.sessionFactory.getCurrentSession();
            for (Object entity : operation) {
                entityManager.merge(entity);
            }
            this.flushIfNecessary((EntityManager)entityManager, operation.getAnnotationMetadata());
            return operation;
        });
    }

    @NonNull
    public <T> Iterable<T> persistAll(@NonNull InsertBatchOperation<T> operation) {
        return (Iterable)this.transactionOperations.executeWrite(status -> {
            if (operation != null) {
                Session entityManager = this.sessionFactory.getCurrentSession();
                for (Object entity : operation) {
                    entityManager.persist(entity);
                }
                this.flushIfNecessary((EntityManager)entityManager, operation.getAnnotationMetadata());
                return operation;
            }
            return Collections.emptyList();
        });
    }

    private void flushIfNecessary(EntityManager entityManager, AnnotationMetadata annotationMetadata) {
        FlushModeType flushModeType;
        if (annotationMetadata.hasAnnotation(QueryHint.class) && (flushModeType = this.getFlushModeType(annotationMetadata)) == FlushModeType.AUTO) {
            entityManager.flush();
        }
    }

    @NonNull
    public Optional<Number> executeUpdate(@NonNull PreparedQuery<?, Number> preparedQuery) {
        return (Optional)this.transactionOperations.executeWrite(status -> {
            String query = preparedQuery.getQuery();
            org.hibernate.query.Query q = this.getCurrentSession().createQuery(query);
            this.bindParameters(q, preparedQuery, query);
            return Optional.of(q.executeUpdate());
        });
    }

    public <T> int delete(@NonNull DeleteOperation<T> operation) {
        AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
        String queryString = annotationMetadata.stringValue(Query.class).orElse(null);
        return (Integer)this.transactionOperations.executeWrite(status -> {
            if (queryString != null) {
                return this.executeEntityUpdate(annotationMetadata, queryString, operation.getEntity());
            }
            this.getCurrentSession().remove(operation.getEntity());
            return 1;
        });
    }

    public <T> Optional<Number> deleteAll(@NonNull DeleteBatchOperation<T> operation) {
        AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
        String queryString = annotationMetadata.stringValue(Query.class).orElse(null);
        Integer result = (Integer)this.transactionOperations.executeWrite(status -> {
            if (queryString != null) {
                int i = 0;
                for (Object entity : operation) {
                    i += this.executeEntityUpdate(annotationMetadata, queryString, entity);
                }
                return i;
            }
            int i = 0;
            Session session = this.getCurrentSession();
            for (Object entity : operation) {
                session.remove(entity);
                ++i;
            }
            return i;
        });
        return Optional.ofNullable(result);
    }

    private int executeEntityUpdate(AnnotationMetadata annotationMetadata, String queryString, Object entity) {
        String[] parameters = annotationMetadata.stringValues(DataMethod.class, "parameterBindingPaths");
        org.hibernate.query.Query query = this.getCurrentSession().createQuery(queryString);
        for (String parameter : parameters) {
            query.setParameter(parameter, this.getParameterValue(parameter, entity));
        }
        return query.executeUpdate();
    }

    private Object getParameterValue(String propertyName, Object value) {
        for (String property : propertyName.split("\\.")) {
            value = BeanWrapper.getWrapper((Object)value).getRequiredProperty(property, Argument.OBJECT_ARGUMENT);
        }
        return value;
    }

    @NonNull
    public <T, R> Stream<R> findStream(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (Stream)this.transactionOperations.executeRead(status -> {
            org.hibernate.query.Query q;
            String query = preparedQuery.getQuery();
            Pageable pageable = preparedQuery.getPageable();
            Session currentSession = this.getCurrentSession();
            Class resultType = preparedQuery.getResultType();
            boolean isNativeQuery = preparedQuery.isNative();
            if (preparedQuery.isDtoProjection()) {
                Object q2 = isNativeQuery ? currentSession.createNativeQuery(query, Tuple.class) : currentSession.createQuery(query, Tuple.class);
                this.bindParameters((org.hibernate.query.Query<?>)q2, preparedQuery, query);
                this.bindPageable((org.hibernate.query.Query)q2, pageable);
                return q2.stream().map(tuple -> ((BeanIntrospectionMapper)Tuple::get).map(tuple, resultType));
            }
            Class wrapperType = ReflectionUtils.getWrapperType((Class)resultType);
            if (isNativeQuery) {
                Class rootEntity = preparedQuery.getRootEntity();
                if (wrapperType != rootEntity) {
                    NativeQuery nativeQuery = currentSession.createNativeQuery(query, Tuple.class);
                    this.bindParameters((org.hibernate.query.Query<?>)nativeQuery, preparedQuery, query);
                    this.bindPageable((org.hibernate.query.Query)nativeQuery, pageable);
                    return nativeQuery.stream().map(tuple -> {
                        Object o = tuple.get(0);
                        if (wrapperType.isInstance(o)) {
                            return o;
                        }
                        return ConversionService.SHARED.convertRequired(o, wrapperType);
                    });
                }
                q = currentSession.createNativeQuery(query, wrapperType);
            } else {
                q = currentSession.createQuery(query, wrapperType);
            }
            this.bindParameters(q, preparedQuery, query);
            this.bindPageable(q, pageable);
            return q.stream();
        });
    }

    @NonNull
    public <T> Stream<T> findStream(@NonNull PagedQuery<T> pagedQuery) {
        Session session = this.getCurrentSession();
        Class entity = pagedQuery.getRootEntity();
        CriteriaQuery query = session.getCriteriaBuilder().createQuery(entity);
        query.from(entity);
        org.hibernate.query.Query q = session.createQuery(query);
        this.bindPageable(q, pagedQuery.getPageable());
        return q.stream();
    }

    public <R> Page<R> findPage(@NonNull PagedQuery<R> query) {
        return (Page)this.transactionOperations.executeRead(status -> {
            Session session = this.getCurrentSession();
            CriteriaBuilder criteriaBuilder = session.getCriteriaBuilder();
            Class entity = query.getRootEntity();
            Pageable pageable = query.getPageable();
            org.hibernate.query.Query q = this.buildCriteriaQuery(session, entity, criteriaBuilder, pageable);
            List resultList = q.list();
            CriteriaQuery countQuery = criteriaBuilder.createQuery(Long.class);
            countQuery.select((Selection)criteriaBuilder.count((Expression)countQuery.from(entity)));
            Long total = (Long)session.createQuery(countQuery).getSingleResult();
            return Page.of((List)resultList, (Pageable)pageable, (long)total);
        });
    }

    private Session getCurrentSession() {
        return this.sessionFactory.getCurrentSession();
    }

    private FlushModeType getFlushModeType(AnnotationMetadata annotationMetadata) {
        return annotationMetadata.getAnnotationValuesByType(QueryHint.class).stream().filter(av -> FlushModeType.class.getName().equals(av.stringValue("name").orElse(null))).map(av -> av.enumValue("value", FlushModeType.class)).findFirst().orElse(Optional.empty()).orElse(null);
    }

    private <T> org.hibernate.query.Query<T> buildCriteriaQuery(Session session, @NonNull Class<T> rootEntity, CriteriaBuilder criteriaBuilder, @NonNull Pageable pageable) {
        CriteriaQuery query = criteriaBuilder.createQuery(rootEntity);
        Root root = query.from(rootEntity);
        this.bindCriteriaSort(query, root, criteriaBuilder, (Sort)pageable);
        org.hibernate.query.Query q = session.createQuery(query);
        this.bindPageable(q, pageable);
        return q;
    }

    private <T> void bindPageable(org.hibernate.query.Query<T> q, @NonNull Pageable pageable) {
        long offset;
        if (pageable == Pageable.UNPAGED) {
            return;
        }
        int max = pageable.getSize();
        if (max > 0) {
            q.setMaxResults(max);
        }
        if ((offset = pageable.getOffset()) > 0L) {
            q.setFirstResult((int)offset);
        }
    }

    private <T> void bindCriteriaSort(CriteriaQuery<T> criteriaQuery, Root<?> root, CriteriaBuilder builder, @NonNull Sort sort) {
        ArrayList<Order> orders = new ArrayList<Order>();
        block3: for (Sort.Order order : sort.getOrderBy()) {
            Path path = root.get(order.getProperty());
            Path expression = order.isIgnoreCase() ? builder.lower((Expression)path) : path;
            switch (order.getDirection()) {
                case DESC: {
                    orders.add(builder.desc((Expression)expression));
                    continue block3;
                }
            }
            orders.add(builder.asc((Expression)expression));
        }
        criteriaQuery.orderBy(orders);
    }

    @NonNull
    private ExecutorService newLocalThreadPool() {
        this.executorService = Executors.newCachedThreadPool();
        return this.executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ExecutorAsyncOperations async() {
        ExecutorAsyncOperations asyncOperations = this.asyncOperations;
        if (asyncOperations == null) {
            HibernateJpaOperations hibernateJpaOperations = this;
            synchronized (hibernateJpaOperations) {
                asyncOperations = this.asyncOperations;
                if (asyncOperations == null) {
                    this.asyncOperations = asyncOperations = new ExecutorAsyncOperations((RepositoryOperations)this, (Executor)(this.executorService != null ? this.executorService : this.newLocalThreadPool()));
                }
            }
        }
        return asyncOperations;
    }

    @NonNull
    public ReactiveRepositoryOperations reactive() {
        return new ExecutorReactiveOperations(this.async());
    }

    @Override
    @NonNull
    public EntityManager getCurrentEntityManager() {
        return this.sessionFactory.getCurrentSession();
    }

    @Override
    @NonNull
    public EntityManagerFactory getEntityManagerFactory() {
        return this.sessionFactory;
    }

    @Override
    public void flush() {
        this.transactionOperations.executeWrite(status -> {
            this.sessionFactory.getCurrentSession().flush();
            return null;
        });
    }
}

