/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.operations;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.beans.exceptions.IntrospectionException;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.QueryHint;
import io.micronaut.data.jpa.annotation.EntityGraph;
import io.micronaut.data.jpa.operations.JpaRepositoryOperations;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.builder.jpa.JpaQueryBuilder;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.async.AsyncCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveRepositoryOperations;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.mapper.BeanIntrospectionMapper;
import io.micronaut.data.runtime.operations.ExecutorAsyncOperations;
import io.micronaut.data.runtime.operations.ExecutorReactiveOperations;
import io.micronaut.jdbc.spring.HibernatePresenceCondition;
import io.micronaut.transaction.TransactionOperations;
import jakarta.inject.Named;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.Tuple;
import javax.persistence.TupleElement;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.graph.AttributeNode;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.SubGraph;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.type.Type;

@EachBean(value=SessionFactory.class)
@TypeHint(value={HibernatePresenceCondition.class})
public class HibernateJpaOperations
implements JpaRepositoryOperations,
AsyncCapableRepository,
ReactiveCapableRepository {
    private static final String ENTITY_GRAPH_FETCH = "javax.persistence.fetchgraph";
    private static final String ENTITY_GRAPH_LOAD = "javax.persistence.loadgraph";
    private static final JpaQueryBuilder QUERY_BUILDER = new JpaQueryBuilder();
    private final SessionFactory sessionFactory;
    private final TransactionOperations<Connection> transactionOperations;
    private final RuntimeEntityRegistry runtimeEntityRegistry;
    private ExecutorAsyncOperations asyncOperations;
    private ExecutorService executorService;
    private final ConversionService<?> dataConversionService;

    @Deprecated
    protected HibernateJpaOperations(@NonNull SessionFactory sessionFactory, @NonNull @Parameter TransactionOperations<Connection> transactionOperations, @Named(value="io") @Nullable ExecutorService executorService, RuntimeEntityRegistry runtimeEntityRegistry) {
        this(sessionFactory, transactionOperations, executorService, runtimeEntityRegistry, null);
    }

    @Creator
    protected HibernateJpaOperations(@NonNull SessionFactory sessionFactory, @NonNull @Parameter TransactionOperations<Connection> transactionOperations, @Named(value="io") @Nullable ExecutorService executorService, RuntimeEntityRegistry runtimeEntityRegistry, DataConversionService<?> dataConversionService) {
        ArgumentUtils.requireNonNull((String)"sessionFactory", (Object)sessionFactory);
        this.runtimeEntityRegistry = runtimeEntityRegistry;
        this.sessionFactory = sessionFactory;
        this.transactionOperations = transactionOperations;
        this.executorService = executorService;
        this.dataConversionService = dataConversionService == null ? ConversionService.SHARED : dataConversionService;
    }

    public ApplicationContext getApplicationContext() {
        return this.runtimeEntityRegistry.getApplicationContext();
    }

    public ConversionService<?> getConversionService() {
        return this.dataConversionService;
    }

    @NonNull
    public Map<String, Object> getQueryHints(@NonNull StoredQuery<?, ?> storedQuery) {
        AnnotationMetadata annotationMetadata = storedQuery.getAnnotationMetadata();
        if (annotationMetadata.hasAnnotation(EntityGraph.class)) {
            String hint = annotationMetadata.stringValue(EntityGraph.class, "hint").orElse(ENTITY_GRAPH_FETCH);
            String graphName = annotationMetadata.stringValue(EntityGraph.class).orElse(null);
            Object[] paths = annotationMetadata.stringValues(EntityGraph.class, "attributePaths");
            if (graphName != null) {
                return Collections.singletonMap(hint, graphName);
            }
            if (ArrayUtils.isNotEmpty((Object[])paths)) {
                return Collections.singletonMap(hint, paths);
            }
        }
        return Collections.emptyMap();
    }

    @Nullable
    public <T> T findOne(@NonNull Class<T> type, @NonNull Serializable id) {
        return (T)this.transactionOperations.executeRead(status -> {
            Session session = this.sessionFactory.getCurrentSession();
            return session.byId(type).load(id);
        });
    }

    @Override
    @NonNull
    public <T> T load(@NonNull Class<T> type, @NonNull Serializable id) {
        return (T)this.transactionOperations.executeRead(status -> {
            Session session = this.sessionFactory.getCurrentSession();
            return session.load(type, id);
        });
    }

    @Nullable
    public <T, R> R findOne(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (R)this.transactionOperations.executeRead(status -> {
            Class resultType = preparedQuery.getResultType();
            String query = preparedQuery.getQuery();
            Session currentSession = this.sessionFactory.getCurrentSession();
            if (preparedQuery.isDtoProjection()) {
                NativeQuery q;
                if (preparedQuery.isNative()) {
                    q = currentSession.createNativeQuery(query, Tuple.class);
                } else {
                    if (query.toLowerCase(Locale.ENGLISH).startsWith("select new ")) {
                        Query dtoQuery = currentSession.createQuery(query, resultType);
                        this.bindParameters(dtoQuery, preparedQuery, query);
                        this.bindQueryHints((Query<?>)dtoQuery, (PagedQuery)preparedQuery, currentSession);
                        return dtoQuery.uniqueResult();
                    }
                    q = currentSession.createQuery(query, Tuple.class);
                }
                this.bindParameters((Query<?>)q, preparedQuery, query);
                this.bindQueryHints((Query<?>)q, (PagedQuery)preparedQuery, currentSession);
                Tuple tuple = (Tuple)this.first(q.list().iterator());
                if (tuple != null) {
                    return new BeanIntrospectionMapper<Tuple, R>(){

                        public Object read(Tuple tuple1, String alias) {
                            return tuple1.get(alias);
                        }

                        public ConversionService<?> getConversionService() {
                            return HibernateJpaOperations.this.dataConversionService;
                        }
                    }.map((Object)tuple, resultType);
                }
                return null;
            }
            Object q = preparedQuery.isNative() ? (DataType.ENTITY.equals((Object)preparedQuery.getResultDataType()) ? currentSession.createNativeQuery(query, resultType) : currentSession.createNativeQuery(query)) : currentSession.createQuery(query, resultType);
            this.bindParameters((Query<?>)q, preparedQuery, query);
            this.bindQueryHints((Query<?>)q, (PagedQuery)preparedQuery, currentSession);
            return this.first(q.list().iterator());
        });
    }

    private <T> T first(Iterator<T> iterator) {
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    private <T, R> void bindParameters(Query<?> q, @NonNull PreparedQuery<T, R> preparedQuery, String query) {
        for (QueryParameterBinding queryParameterBinding : preparedQuery.getQueryBindings()) {
            Object value;
            String parameterName = Objects.requireNonNull(queryParameterBinding.getName(), "Parameter name cannot be null!");
            if (queryParameterBinding.getParameterIndex() != -1) {
                value = this.resolveParameterValue(queryParameterBinding, preparedQuery.getParameterArray());
            } else if (queryParameterBinding.isAutoPopulated()) {
                CharSequence[] propertyPath = queryParameterBinding.getRequiredPropertyPath();
                RuntimePersistentEntity persistentEntity = this.getEntity(preparedQuery.getRootEntity());
                PersistentPropertyPath pp = persistentEntity.getPropertyPath((String[])propertyPath);
                if (pp == null) {
                    throw new IllegalStateException("Cannot find auto populated property: " + String.join((CharSequence)".", propertyPath));
                }
                RuntimePersistentProperty persistentProperty = (RuntimePersistentProperty)pp.getProperty();
                Object previousValue = null;
                QueryParameterBinding previousPopulatedValueParameter = queryParameterBinding.getPreviousPopulatedValueParameter();
                if (previousPopulatedValueParameter != null) {
                    if (previousPopulatedValueParameter.getParameterIndex() == -1) {
                        throw new IllegalStateException("Previous value parameter cannot be bind!");
                    }
                    previousValue = this.resolveParameterValue(previousPopulatedValueParameter, preparedQuery.getParameterArray());
                }
                value = this.runtimeEntityRegistry.autoPopulateRuntimeProperty(persistentProperty, previousValue);
            } else {
                throw new IllegalStateException("Invalid query [" + query + "]. Unable to establish parameter value for parameter at name: " + parameterName);
            }
            if (preparedQuery.isNative()) {
                int parameterIndex = queryParameterBinding.getParameterIndex();
                Argument argument = preparedQuery.getArguments()[parameterIndex];
                Class argumentType = argument.getType();
                if (Collection.class.isAssignableFrom(argumentType)) {
                    Type valueType = this.sessionFactory.getTypeHelper().heuristicType(argument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT).getType().getName());
                    if (valueType != null) {
                        q.setParameterList(parameterName, value == null ? Collections.emptyList() : (Collection)value, valueType);
                        continue;
                    }
                } else {
                    Type type;
                    if (Object[].class.isAssignableFrom(argumentType)) {
                        q.setParameterList(parameterName, value == null ? ArrayUtils.EMPTY_OBJECT_ARRAY : (Object[])value);
                        continue;
                    }
                    if (value == null && (type = this.sessionFactory.getTypeHelper().heuristicType(argumentType.getName())) != null) {
                        q.setParameter(parameterName, null, type);
                        continue;
                    }
                }
            }
            q.setParameter(parameterName, value);
        }
    }

    private Object resolveParameterValue(QueryParameterBinding queryParameterBinding, Object[] queryParameters) {
        Object value = queryParameters[queryParameterBinding.getParameterIndex()];
        String[] parameterBindingPath = queryParameterBinding.getParameterBindingPath();
        if (parameterBindingPath != null) {
            for (String prop : parameterBindingPath) {
                if (value == null) break;
                value = BeanWrapper.getWrapper((Object)value).getRequiredProperty(prop, Argument.OBJECT_ARGUMENT);
            }
        }
        return value;
    }

    public <T> boolean exists(@NonNull PreparedQuery<T, Boolean> preparedQuery) {
        return this.findOne(preparedQuery) != null;
    }

    @NonNull
    public <T> Iterable<T> findAll(@NonNull PagedQuery<T> query) {
        return (Iterable)this.transactionOperations.executeRead(status -> {
            Session session = this.getCurrentSession();
            CriteriaBuilder criteriaBuilder = session.getCriteriaBuilder();
            Query q = this.buildCriteriaQuery(session, query.getRootEntity(), criteriaBuilder, query.getPageable());
            this.bindQueryHints(q, query, session);
            return q.list();
        });
    }

    public <T> long count(PagedQuery<T> pagedQuery) {
        return (Long)this.transactionOperations.executeRead(status -> {
            Session session = this.getCurrentSession();
            CriteriaBuilder criteriaBuilder = session.getCriteriaBuilder();
            CriteriaQuery query = criteriaBuilder.createQuery(Long.class);
            Root root = query.from(pagedQuery.getRootEntity());
            query = query.select((Selection)criteriaBuilder.count((Expression)root));
            Query q = session.createQuery(query);
            Pageable pageable = pagedQuery.getPageable();
            this.bindCriteriaSort(query, root, criteriaBuilder, (Sort)pageable);
            this.bindPageable(q, pageable);
            this.bindQueryHints(q, pagedQuery, session);
            return (Long)q.getSingleResult();
        });
    }

    @NonNull
    public <T, R> Iterable<R> findAll(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (Iterable)this.transactionOperations.executeRead(status -> {
            Sort sort;
            Session entityManager = this.sessionFactory.getCurrentSession();
            String queryStr = preparedQuery.getQuery();
            Pageable pageable = preparedQuery.getPageable();
            if (pageable != Pageable.UNPAGED && (sort = pageable.getSort()).isSorted()) {
                queryStr = queryStr + QUERY_BUILDER.buildOrderBy(queryStr, (PersistentEntity)this.getEntity(preparedQuery.getRootEntity()), sort).getQuery();
            }
            if (preparedQuery.isDtoProjection()) {
                NativeQuery q;
                if (preparedQuery.isNative()) {
                    q = entityManager.createNativeQuery(queryStr, Tuple.class);
                } else {
                    if (queryStr.toLowerCase(Locale.ENGLISH).startsWith("select new ")) {
                        Class wrapperType = ReflectionUtils.getWrapperType((Class)preparedQuery.getResultType());
                        Query query = entityManager.createQuery(queryStr, wrapperType);
                        this.bindPreparedQuery(query, preparedQuery, entityManager, queryStr);
                        return query.list();
                    }
                    q = entityManager.createQuery(queryStr, Tuple.class);
                }
                this.bindPreparedQuery((Query<?>)q, preparedQuery, entityManager, queryStr);
                return q.stream().map(tuple -> {
                    final Set properties = tuple.getElements().stream().map(TupleElement::getAlias).collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER)));
                    return new BeanIntrospectionMapper<Tuple, R>(){

                        public Object read(Tuple tuple1, String alias) {
                            if (!properties.contains(alias)) {
                                return null;
                            }
                            return tuple1.get(alias);
                        }

                        public ConversionService<?> getConversionService() {
                            return HibernateJpaOperations.this.dataConversionService;
                        }
                    }.map(tuple, preparedQuery.getResultType());
                }).collect(Collectors.toList());
            }
            Class wrapperType = ReflectionUtils.getWrapperType((Class)preparedQuery.getResultType());
            Object q = preparedQuery.isNative() ? (DataType.ENTITY.equals((Object)preparedQuery.getResultDataType()) ? entityManager.createNativeQuery(queryStr, wrapperType) : entityManager.createNativeQuery(queryStr)) : entityManager.createQuery(queryStr, wrapperType);
            this.bindPreparedQuery((Query<?>)q, preparedQuery, entityManager, queryStr);
            return q.list();
        });
    }

    private <T, R> void bindPreparedQuery(Query<?> q, @NonNull PreparedQuery<T, R> preparedQuery, Session currentSession, String query) {
        this.bindParameters(q, preparedQuery, query);
        this.bindPageable(q, preparedQuery.getPageable());
        this.bindQueryHints(q, (PagedQuery<T>)preparedQuery, currentSession);
    }

    private <T> void bindQueryHints(Query<?> q, @NonNull PagedQuery<T> preparedQuery, @NonNull Session session) {
        Map queryHints = preparedQuery.getQueryHints();
        if (CollectionUtils.isNotEmpty((Map)queryHints)) {
            for (Map.Entry entry : queryHints.entrySet()) {
                String hintName = (String)entry.getKey();
                Object value = entry.getValue();
                if (ENTITY_GRAPH_FETCH.equals(hintName) || ENTITY_GRAPH_LOAD.equals(hintName)) {
                    Object[] pathsDefinitions;
                    String graphName = preparedQuery.getAnnotationMetadata().stringValue(EntityGraph.class).orElse(null);
                    if (graphName != null) {
                        RootGraph entityGraph = session.getEntityGraph(graphName);
                        q.setHint(hintName, (Object)entityGraph);
                        continue;
                    }
                    if (!(value instanceof String[]) || !ArrayUtils.isNotEmpty((Object[])(pathsDefinitions = (String[])value))) continue;
                    RootGraph<T> entityGraph = HibernateJpaOperations.createGraph((String[])pathsDefinitions, session, preparedQuery.getRootEntity());
                    q.setHint(hintName, entityGraph);
                    continue;
                }
                q.setHint(hintName, value);
            }
        }
    }

    private static <T> RootGraph<T> createGraph(@NonNull String[] paths, @NonNull Session session, @NonNull Class<T> rootEntity) {
        RootGraph rootGraph = session.createEntityGraph(rootEntity);
        for (String path : paths) {
            if (path.trim().equals("")) continue;
            String[] parts = path.split("\\.");
            if (parts.length == 1) {
                AttributeNode attrNode = rootGraph.findAttributeNode(path);
                if (attrNode != null) continue;
                rootGraph.addAttributeNode(path);
                continue;
            }
            RootGraph graph = rootGraph;
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                AttributeNode attrNode = graph.findAttributeNode(part);
                if (attrNode != null) {
                    SubGraph subGraph;
                    SubGraph subGraph2 = subGraph = attrNode.getSubGraphs().isEmpty() ? null : (SubGraph)attrNode.getSubGraphs().values().iterator().next();
                    if (subGraph == null && i < parts.length - 1) {
                        graph = graph.addSubGraph(part);
                        continue;
                    }
                    if (subGraph == null) continue;
                    graph = subGraph;
                    continue;
                }
                if (i == parts.length - 1) {
                    graph.addAttributeNode(part);
                    continue;
                }
                graph = graph.addSubGraph(part);
            }
        }
        return rootGraph;
    }

    public <T> T persist(@NonNull InsertOperation<T> operation) {
        return (T)this.transactionOperations.executeWrite(status -> {
            Object entity = operation.getEntity();
            Session entityManager = this.sessionFactory.getCurrentSession();
            entityManager.persist(entity);
            this.flushIfNecessary((EntityManager)entityManager, operation.getAnnotationMetadata());
            return entity;
        });
    }

    @NonNull
    public <T> T update(@NonNull UpdateOperation<T> operation) {
        StoredQuery storedQuery = operation.getStoredQuery();
        return (T)this.transactionOperations.executeWrite(status -> {
            if (storedQuery != null) {
                this.executeEntityUpdate(storedQuery, operation.getEntity());
                return operation.getEntity();
            }
            Object entity = operation.getEntity();
            Session session = this.sessionFactory.getCurrentSession();
            entity = session.merge(entity);
            this.flushIfNecessary((EntityManager)session, operation.getAnnotationMetadata());
            return entity;
        });
    }

    @NonNull
    public <T> Iterable<T> updateAll(@NonNull UpdateBatchOperation<T> operation) {
        StoredQuery storedQuery = operation.getStoredQuery();
        return (Iterable)this.transactionOperations.executeWrite(status -> {
            if (storedQuery != null) {
                for (Object entity : operation) {
                    this.executeEntityUpdate(storedQuery, entity);
                }
                return operation;
            }
            Session entityManager = this.sessionFactory.getCurrentSession();
            ArrayList<Object> results = new ArrayList<Object>();
            for (Object entity : operation) {
                Object merge = entityManager.merge(entity);
                results.add(merge);
            }
            this.flushIfNecessary((EntityManager)entityManager, operation.getAnnotationMetadata());
            return results;
        });
    }

    @NonNull
    public <T> Iterable<T> persistAll(@NonNull InsertBatchOperation<T> operation) {
        return (Iterable)this.transactionOperations.executeWrite(status -> {
            if (operation != null) {
                Session entityManager = this.sessionFactory.getCurrentSession();
                for (Object entity : operation) {
                    entityManager.persist(entity);
                }
                this.flushIfNecessary((EntityManager)entityManager, operation.getAnnotationMetadata());
                return operation;
            }
            return Collections.emptyList();
        });
    }

    private void flushIfNecessary(EntityManager entityManager, AnnotationMetadata annotationMetadata) {
        FlushModeType flushModeType;
        if (annotationMetadata.hasAnnotation(QueryHint.class) && (flushModeType = this.getFlushModeType(annotationMetadata)) == FlushModeType.AUTO) {
            entityManager.flush();
        }
    }

    @NonNull
    public Optional<Number> executeUpdate(@NonNull PreparedQuery<?, Number> preparedQuery) {
        return (Optional)this.transactionOperations.executeWrite(status -> {
            String query = preparedQuery.getQuery();
            Query q = this.getCurrentSession().createQuery(query);
            this.bindParameters(q, preparedQuery, query);
            return Optional.of(q.executeUpdate());
        });
    }

    public <T> int delete(@NonNull DeleteOperation<T> operation) {
        StoredQuery storedQuery = operation.getStoredQuery();
        return (Integer)this.transactionOperations.executeWrite(status -> {
            if (storedQuery != null) {
                return this.executeEntityUpdate(storedQuery, operation.getEntity());
            }
            this.getCurrentSession().remove(operation.getEntity());
            return 1;
        });
    }

    public <T> Optional<Number> deleteAll(@NonNull DeleteBatchOperation<T> operation) {
        StoredQuery storedQuery = operation.getStoredQuery();
        Integer result = (Integer)this.transactionOperations.executeWrite(status -> {
            if (storedQuery != null) {
                int i = 0;
                for (Object entity : operation) {
                    i += this.executeEntityUpdate(storedQuery, entity);
                }
                return i;
            }
            int i = 0;
            Session session = this.getCurrentSession();
            for (Object entity : operation) {
                session.remove(entity);
                ++i;
            }
            return i;
        });
        return Optional.ofNullable(result);
    }

    private int executeEntityUpdate(StoredQuery<?, ?> storedQuery, Object entity) {
        Query query = this.getCurrentSession().createQuery(storedQuery.getQuery());
        for (QueryParameterBinding queryParameterBinding : storedQuery.getQueryBindings()) {
            query.setParameter(queryParameterBinding.getRequiredName(), this.getParameterValue(queryParameterBinding.getRequiredPropertyPath(), entity));
        }
        return query.executeUpdate();
    }

    private Object getParameterValue(String[] propertyPath, Object value) {
        for (String property : propertyPath) {
            Object finalValue = value;
            BeanProperty beanProperty = (BeanProperty)BeanIntrospection.getIntrospection(value.getClass()).getProperty(property).orElseThrow(() -> new IntrospectionException("Cannot find a property: '" + property + "' on bean: " + finalValue));
            if ((value = beanProperty.get(value)) != null) continue;
            return null;
        }
        return value;
    }

    @NonNull
    public <T, R> Stream<R> findStream(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (Stream)this.transactionOperations.executeRead(status -> {
            Query q;
            String query = preparedQuery.getQuery();
            Pageable pageable = preparedQuery.getPageable();
            Session currentSession = this.getCurrentSession();
            Class resultType = preparedQuery.getResultType();
            boolean isNativeQuery = preparedQuery.isNative();
            if (preparedQuery.isDtoProjection()) {
                Object q2 = isNativeQuery ? currentSession.createNativeQuery(query, Tuple.class) : currentSession.createQuery(query, Tuple.class);
                this.bindParameters((Query<?>)q2, preparedQuery, query);
                this.bindPageable((Query)q2, pageable);
                return q2.stream().map(tuple -> new BeanIntrospectionMapper<Tuple, R>(){

                    public Object read(Tuple tuple1, String alias) {
                        return tuple1.get(alias);
                    }

                    public ConversionService<?> getConversionService() {
                        return HibernateJpaOperations.this.dataConversionService;
                    }
                }.map(tuple, resultType));
            }
            Class wrapperType = ReflectionUtils.getWrapperType((Class)resultType);
            if (isNativeQuery) {
                Class rootEntity = preparedQuery.getRootEntity();
                if (wrapperType != rootEntity) {
                    NativeQuery nativeQuery = currentSession.createNativeQuery(query, Tuple.class);
                    this.bindParameters((Query<?>)nativeQuery, preparedQuery, query);
                    this.bindPageable((Query)nativeQuery, pageable);
                    return nativeQuery.stream().map(tuple -> {
                        Object o = tuple.get(0);
                        if (wrapperType.isInstance(o)) {
                            return o;
                        }
                        return this.dataConversionService.convertRequired(o, wrapperType);
                    });
                }
                q = currentSession.createNativeQuery(query, wrapperType);
            } else {
                q = currentSession.createQuery(query, wrapperType);
            }
            this.bindParameters(q, preparedQuery, query);
            this.bindPageable(q, pageable);
            return q.stream();
        });
    }

    @NonNull
    public <T> Stream<T> findStream(@NonNull PagedQuery<T> pagedQuery) {
        Session session = this.getCurrentSession();
        Class entity = pagedQuery.getRootEntity();
        CriteriaQuery query = session.getCriteriaBuilder().createQuery(entity);
        query.from(entity);
        Query q = session.createQuery(query);
        this.bindPageable(q, pagedQuery.getPageable());
        return q.stream();
    }

    public <R> Page<R> findPage(@NonNull PagedQuery<R> query) {
        return (Page)this.transactionOperations.executeRead(status -> {
            Session session = this.getCurrentSession();
            CriteriaBuilder criteriaBuilder = session.getCriteriaBuilder();
            Class entity = query.getRootEntity();
            Pageable pageable = query.getPageable();
            Query q = this.buildCriteriaQuery(session, entity, criteriaBuilder, pageable);
            List resultList = q.list();
            CriteriaQuery countQuery = criteriaBuilder.createQuery(Long.class);
            countQuery.select((Selection)criteriaBuilder.count((Expression)countQuery.from(entity)));
            Long total = (Long)session.createQuery(countQuery).getSingleResult();
            return Page.of((List)resultList, (Pageable)pageable, (long)total);
        });
    }

    private Session getCurrentSession() {
        return this.sessionFactory.getCurrentSession();
    }

    private FlushModeType getFlushModeType(AnnotationMetadata annotationMetadata) {
        return annotationMetadata.getAnnotationValuesByType(QueryHint.class).stream().filter(av -> FlushModeType.class.getName().equals(av.stringValue("name").orElse(null))).map(av -> av.enumValue("value", FlushModeType.class)).findFirst().orElse(Optional.empty()).orElse(null);
    }

    private <T> Query<T> buildCriteriaQuery(Session session, @NonNull Class<T> rootEntity, CriteriaBuilder criteriaBuilder, @NonNull Pageable pageable) {
        CriteriaQuery query = criteriaBuilder.createQuery(rootEntity);
        Root root = query.from(rootEntity);
        this.bindCriteriaSort(query, root, criteriaBuilder, (Sort)pageable);
        Query q = session.createQuery(query);
        this.bindPageable(q, pageable);
        return q;
    }

    private <T> void bindPageable(Query<T> q, @NonNull Pageable pageable) {
        long offset;
        if (pageable == Pageable.UNPAGED) {
            return;
        }
        int max = pageable.getSize();
        if (max > 0) {
            q.setMaxResults(max);
        }
        if ((offset = pageable.getOffset()) > 0L) {
            q.setFirstResult((int)offset);
        }
    }

    private <T> void bindCriteriaSort(CriteriaQuery<T> criteriaQuery, Root<?> root, CriteriaBuilder builder, @NonNull Sort sort) {
        ArrayList<Order> orders = new ArrayList<Order>();
        block3: for (Sort.Order order : sort.getOrderBy()) {
            Path path = root.get(order.getProperty());
            Path expression = order.isIgnoreCase() ? builder.lower((Expression)path) : path;
            switch (order.getDirection()) {
                case DESC: {
                    orders.add(builder.desc((Expression)expression));
                    continue block3;
                }
            }
            orders.add(builder.asc((Expression)expression));
        }
        criteriaQuery.orderBy(orders);
    }

    @NonNull
    private ExecutorService newLocalThreadPool() {
        this.executorService = Executors.newCachedThreadPool();
        return this.executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ExecutorAsyncOperations async() {
        ExecutorAsyncOperations asyncOperations = this.asyncOperations;
        if (asyncOperations == null) {
            HibernateJpaOperations hibernateJpaOperations = this;
            synchronized (hibernateJpaOperations) {
                asyncOperations = this.asyncOperations;
                if (asyncOperations == null) {
                    this.asyncOperations = asyncOperations = new ExecutorAsyncOperations((RepositoryOperations)this, (Executor)(this.executorService != null ? this.executorService : this.newLocalThreadPool()));
                }
            }
        }
        return asyncOperations;
    }

    @NonNull
    public ReactiveRepositoryOperations reactive() {
        if (this.dataConversionService instanceof DataConversionService) {
            return new ExecutorReactiveOperations(this.async(), (DataConversionService)this.dataConversionService);
        }
        return new ExecutorReactiveOperations(this.async(), null);
    }

    @Override
    @NonNull
    public EntityManager getCurrentEntityManager() {
        return this.sessionFactory.getCurrentSession();
    }

    @Override
    @NonNull
    public EntityManagerFactory getEntityManagerFactory() {
        return this.sessionFactory;
    }

    @Override
    public void flush() {
        this.transactionOperations.executeWrite(status -> {
            this.sessionFactory.getCurrentSession().flush();
            return null;
        });
    }
}

