/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jpa.repository.criteria;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.jpa.repository.criteria.Specification;
import java.io.Serializable;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

class SpecificationComposition {
    SpecificationComposition() {
    }

    @NonNull
    static <T> Specification<T> composed(@Nullable Specification<T> lhs, @Nullable Specification<T> rhs, Combiner combiner) {
        return (root, query, builder) -> {
            Predicate otherPredicate = SpecificationComposition.toPredicate(lhs, root, query, builder);
            Predicate thisPredicate = SpecificationComposition.toPredicate(rhs, root, query, builder);
            if (thisPredicate == null) {
                return otherPredicate;
            }
            return otherPredicate == null ? thisPredicate : combiner.combine(builder, thisPredicate, otherPredicate);
        };
    }

    @Nullable
    private static <T> Predicate toPredicate(@Nullable Specification<T> specification, @NonNull Root<T> root, @NonNull CriteriaQuery<?> query, @NonNull CriteriaBuilder builder) {
        return specification == null ? null : specification.toPredicate(root, query, builder);
    }

    static interface Combiner
    extends Serializable {
        @NonNull
        public Predicate combine(@NonNull CriteriaBuilder var1, @Nullable Predicate var2, @Nullable Predicate var3);
    }
}

