/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.operations;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.annotation.QueryHint;
import io.micronaut.data.hibernate.operations.AbstractHibernateOperations;
import io.micronaut.data.jpa.operations.JpaRepositoryOperations;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.async.AsyncCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveRepositoryOperations;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.operations.ExecutorAsyncOperations;
import io.micronaut.data.runtime.operations.ExecutorReactiveOperations;
import io.micronaut.jdbc.spring.HibernatePresenceCondition;
import io.micronaut.transaction.TransactionOperations;
import jakarta.inject.Named;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.Tuple;
import javax.persistence.criteria.CriteriaQuery;
import javax.sql.DataSource;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.graph.RootGraph;
import org.hibernate.query.Query;
import org.hibernate.type.Type;

@EachBean(value=DataSource.class)
@TypeHint(value={HibernatePresenceCondition.class})
public class HibernateJpaOperations
extends AbstractHibernateOperations<Session, Query<?>>
implements JpaRepositoryOperations,
AsyncCapableRepository,
ReactiveCapableRepository {
    private final SessionFactory sessionFactory;
    private final TransactionOperations<Connection> transactionOperations;
    private ExecutorAsyncOperations asyncOperations;
    private ExecutorService executorService;

    @Deprecated
    protected HibernateJpaOperations(@NonNull SessionFactory sessionFactory, @NonNull @Parameter TransactionOperations<Connection> transactionOperations, @Named(value="io") @Nullable ExecutorService executorService, RuntimeEntityRegistry runtimeEntityRegistry) {
        this(sessionFactory, transactionOperations, executorService, runtimeEntityRegistry, null);
    }

    @Creator
    public HibernateJpaOperations(@NonNull @Parameter SessionFactory sessionFactory, @NonNull @Parameter TransactionOperations<Connection> transactionOperations, @Named(value="io") @Nullable ExecutorService executorService, RuntimeEntityRegistry runtimeEntityRegistry, DataConversionService<?> dataConversionService) {
        super(runtimeEntityRegistry, dataConversionService);
        ArgumentUtils.requireNonNull((String)"sessionFactory", (Object)sessionFactory);
        this.sessionFactory = sessionFactory;
        this.transactionOperations = transactionOperations;
        this.executorService = executorService;
    }

    @Override
    public <T> RuntimePersistentEntity<T> getEntity(Class<T> type) {
        return this.runtimeEntityRegistry.getEntity(type);
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return super.getApplicationContext();
    }

    @Override
    public ConversionService<?> getConversionService() {
        return super.getConversionService();
    }

    @Override
    protected void setParameter(Query<?> query, String parameterName, Object value) {
        query.setParameter(parameterName, value);
    }

    @Override
    protected void setParameter(Query<?> query, String parameterName, Object value, Argument argument) {
        if (value == null) {
            Type valueType = this.sessionFactory.getTypeHelper().heuristicType(argument.getType().getName());
            query.setParameter(parameterName, null, valueType);
        } else {
            query.setParameter(parameterName, value);
        }
    }

    @Override
    protected void setParameterList(Query<?> query, String parameterName, Collection<Object> value) {
        query.setParameterList(parameterName, value);
    }

    @Override
    protected void setParameterList(Query<?> query, String parameterName, Collection<Object> value, Argument argument) {
        Type valueType = this.sessionFactory.getTypeHelper().heuristicType(argument.getType().getName());
        if (value == null) {
            value = Collections.emptyList();
        }
        if (valueType != null) {
            query.setParameterList(parameterName, value, valueType);
        } else {
            query.setParameterList(parameterName, value);
        }
    }

    @Override
    protected void setHint(Query<?> query, String hintName, Object value) {
        query.setHint(hintName, value);
    }

    @Override
    protected <T> RootGraph<T> getEntityGraph(Session session, Class<T> entityType, String graphName) {
        return session.getEntityGraph(graphName);
    }

    @Override
    protected <T> RootGraph<T> createEntityGraph(Session session, Class<T> entityType) {
        return session.createEntityGraph(entityType);
    }

    @Override
    protected Query<?> createQuery(Session session, String query, Class<?> resultType) {
        if (resultType == null) {
            return session.createQuery(query);
        }
        return session.createQuery(query, resultType);
    }

    @Override
    protected Query<?> createNativeQuery(Session session, String query, Class<?> resultType) {
        if (resultType == null) {
            return session.createNativeQuery(query);
        }
        return session.createNativeQuery(query, resultType);
    }

    @Override
    protected Query<?> createQuery(Session session, CriteriaQuery<?> criteriaQuery) {
        return session.createQuery(criteriaQuery);
    }

    @Override
    protected void setOffset(Query<?> query, int offset) {
        query.setFirstResult(offset);
    }

    @Override
    protected void setMaxResults(Query<?> query, int max) {
        query.setMaxResults(max);
    }

    @Override
    @NonNull
    public Map<String, Object> getQueryHints(@NonNull StoredQuery<?, ?> storedQuery) {
        return super.getQueryHints(storedQuery);
    }

    @Nullable
    public <T> T findOne(@NonNull Class<T> type, @NonNull Serializable id) {
        return (T)this.transactionOperations.executeRead(status -> this.sessionFactory.getCurrentSession().byId(type).load(id));
    }

    @Override
    @NonNull
    public <T> T load(@NonNull Class<T> type, @NonNull Serializable id) {
        return (T)this.transactionOperations.executeRead(status -> this.sessionFactory.getCurrentSession().load(type, id));
    }

    @Nullable
    public <T, R> R findOne(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (R)this.transactionOperations.executeRead(status -> {
            FirstResultCollector collector = new FirstResultCollector();
            this.collectFindOne(this.sessionFactory.getCurrentSession(), preparedQuery, collector);
            return collector.result;
        });
    }

    public <T> boolean exists(@NonNull PreparedQuery<T, Boolean> preparedQuery) {
        return this.findOne(preparedQuery) != null;
    }

    @NonNull
    public <T> Iterable<T> findAll(@NonNull PagedQuery<T> pagedQuery) {
        return (Iterable)this.transactionOperations.executeRead(status -> this.findPaged(this.getCurrentSession(), pagedQuery));
    }

    @NonNull
    public <T> Stream<T> findStream(@NonNull PagedQuery<T> pagedQuery) {
        return (Stream)this.transactionOperations.executeRead(status -> {
            StreamResultCollector collector = new StreamResultCollector();
            this.collectPagedResults(this.sessionFactory.getCriteriaBuilder(), this.getCurrentSession(), pagedQuery, collector);
            return collector.result;
        });
    }

    public <R> Page<R> findPage(@NonNull PagedQuery<R> pagedQuery) {
        return (Page)this.transactionOperations.executeRead(status -> {
            Session session = this.getCurrentSession();
            return Page.of(this.findPaged(session, pagedQuery), (Pageable)pagedQuery.getPageable(), (long)this.countOf(session, pagedQuery, pagedQuery.getPageable()));
        });
    }

    public <T> long count(PagedQuery<T> pagedQuery) {
        return (Long)this.transactionOperations.executeRead(status -> this.countOf(this.getCurrentSession(), pagedQuery, null));
    }

    private <T> List<T> findPaged(Session session, PagedQuery<T> pagedQuery) {
        ListResultCollector collector = new ListResultCollector();
        this.collectPagedResults(this.sessionFactory.getCriteriaBuilder(), session, pagedQuery, collector);
        return collector.result;
    }

    private <T> Long countOf(Session session, PagedQuery<T> pagedQuery, @Nullable Pageable pageable) {
        SingleResultCollector<Long> collector = new SingleResultCollector<Long>();
        this.collectCountOf(this.sessionFactory.getCriteriaBuilder(), session, pagedQuery.getRootEntity(), pageable, collector);
        return (Long)((SingleResultCollector)collector).result;
    }

    @NonNull
    public <T, R> Iterable<R> findAll(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (Iterable)this.transactionOperations.executeRead(status -> {
            ListResultCollector resultCollector = new ListResultCollector();
            this.collectFindAll(this.sessionFactory.getCurrentSession(), preparedQuery, resultCollector);
            return resultCollector.result;
        });
    }

    public <T> T persist(@NonNull InsertOperation<T> operation) {
        return (T)this.transactionOperations.executeWrite(status -> {
            Object entity = operation.getEntity();
            Session entityManager = this.sessionFactory.getCurrentSession();
            entityManager.persist(entity);
            this.flushIfNecessary((EntityManager)entityManager, operation.getAnnotationMetadata());
            return entity;
        });
    }

    @NonNull
    public <T> T update(@NonNull UpdateOperation<T> operation) {
        StoredQuery storedQuery = operation.getStoredQuery();
        return (T)this.transactionOperations.executeWrite(status -> {
            if (storedQuery != null) {
                this.executeEntityUpdate(storedQuery, operation.getEntity());
                return operation.getEntity();
            }
            Object entity = operation.getEntity();
            Session session = this.sessionFactory.getCurrentSession();
            entity = session.merge(entity);
            this.flushIfNecessary((EntityManager)session, operation.getAnnotationMetadata());
            return entity;
        });
    }

    @NonNull
    public <T> Iterable<T> updateAll(@NonNull UpdateBatchOperation<T> operation) {
        StoredQuery storedQuery = operation.getStoredQuery();
        return (Iterable)this.transactionOperations.executeWrite(status -> {
            if (storedQuery != null) {
                for (Object entity : operation) {
                    this.executeEntityUpdate(storedQuery, entity);
                }
                return operation;
            }
            Session entityManager = this.sessionFactory.getCurrentSession();
            ArrayList<Object> results = new ArrayList<Object>();
            for (Object entity : operation) {
                Object merge = entityManager.merge(entity);
                results.add(merge);
            }
            this.flushIfNecessary((EntityManager)entityManager, operation.getAnnotationMetadata());
            return results;
        });
    }

    @NonNull
    public <T> Iterable<T> persistAll(@NonNull InsertBatchOperation<T> operation) {
        return (Iterable)this.transactionOperations.executeWrite(status -> {
            if (operation != null) {
                Session entityManager = this.sessionFactory.getCurrentSession();
                for (Object entity : operation) {
                    entityManager.persist(entity);
                }
                this.flushIfNecessary((EntityManager)entityManager, operation.getAnnotationMetadata());
                return operation;
            }
            return Collections.emptyList();
        });
    }

    private void flushIfNecessary(EntityManager entityManager, AnnotationMetadata annotationMetadata) {
        FlushModeType flushModeType;
        if (annotationMetadata.hasAnnotation(QueryHint.class) && (flushModeType = this.getFlushModeType(annotationMetadata)) == FlushModeType.AUTO) {
            entityManager.flush();
        }
    }

    @NonNull
    public Optional<Number> executeUpdate(@NonNull PreparedQuery<?, Number> preparedQuery) {
        return (Optional)this.transactionOperations.executeWrite(status -> {
            String query = preparedQuery.getQuery();
            Query q = this.getCurrentSession().createQuery(query);
            this.bindParameters(q, preparedQuery, query);
            return Optional.of(q.executeUpdate());
        });
    }

    public <T> int delete(@NonNull DeleteOperation<T> operation) {
        StoredQuery storedQuery = operation.getStoredQuery();
        return (Integer)this.transactionOperations.executeWrite(status -> {
            if (storedQuery != null) {
                return this.executeEntityUpdate(storedQuery, operation.getEntity());
            }
            this.getCurrentSession().remove(operation.getEntity());
            return 1;
        });
    }

    public <T> Optional<Number> deleteAll(@NonNull DeleteBatchOperation<T> operation) {
        StoredQuery storedQuery = operation.getStoredQuery();
        Integer result = (Integer)this.transactionOperations.executeWrite(status -> {
            if (storedQuery != null) {
                int i = 0;
                for (Object entity : operation) {
                    i += this.executeEntityUpdate(storedQuery, entity);
                }
                return i;
            }
            int i = 0;
            Session session = this.getCurrentSession();
            for (Object entity : operation) {
                session.remove(entity);
                ++i;
            }
            return i;
        });
        return Optional.ofNullable(result);
    }

    private int executeEntityUpdate(StoredQuery<?, ?> storedQuery, Object entity) {
        Query query = this.getCurrentSession().createQuery(storedQuery.getQuery());
        for (QueryParameterBinding queryParameterBinding : storedQuery.getQueryBindings()) {
            query.setParameter(queryParameterBinding.getRequiredName(), this.getParameterValue(queryParameterBinding.getRequiredPropertyPath(), entity));
        }
        return query.executeUpdate();
    }

    @NonNull
    public <T, R> Stream<R> findStream(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (Stream)this.transactionOperations.executeRead(status -> {
            StreamResultCollector resultCollector = new StreamResultCollector();
            this.collectFindAll(this.sessionFactory.getCurrentSession(), preparedQuery, resultCollector);
            return resultCollector.result;
        });
    }

    private Session getCurrentSession() {
        return this.sessionFactory.getCurrentSession();
    }

    @NonNull
    private ExecutorService newLocalThreadPool() {
        this.executorService = Executors.newCachedThreadPool();
        return this.executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ExecutorAsyncOperations async() {
        ExecutorAsyncOperations asyncOperations = this.asyncOperations;
        if (asyncOperations == null) {
            HibernateJpaOperations hibernateJpaOperations = this;
            synchronized (hibernateJpaOperations) {
                asyncOperations = this.asyncOperations;
                if (asyncOperations == null) {
                    this.asyncOperations = asyncOperations = new ExecutorAsyncOperations((RepositoryOperations)this, (Executor)(this.executorService != null ? this.executorService : this.newLocalThreadPool()));
                }
            }
        }
        return asyncOperations;
    }

    @NonNull
    public ReactiveRepositoryOperations reactive() {
        if (this.dataConversionService instanceof DataConversionService) {
            return new ExecutorReactiveOperations(this.async(), (DataConversionService)this.dataConversionService);
        }
        return new ExecutorReactiveOperations(this.async(), null);
    }

    @Override
    @NonNull
    public EntityManager getCurrentEntityManager() {
        return this.sessionFactory.getCurrentSession();
    }

    @Override
    @NonNull
    public EntityManagerFactory getEntityManagerFactory() {
        return this.sessionFactory;
    }

    @Override
    public void flush() {
        this.transactionOperations.executeWrite(status -> {
            this.sessionFactory.getCurrentSession().flush();
            return null;
        });
    }

    private final class FirstResultCollector<R>
    extends AbstractHibernateOperations.ResultCollector<R> {
        private R result;

        private FirstResultCollector() {
            super(HibernateJpaOperations.this);
        }

        @Override
        protected void collectTuple(Query<?> query, Function<Tuple, R> fn) {
            Tuple tuple = (Tuple)this.getFirst(query);
            if (tuple != null) {
                this.result = fn.apply(tuple);
            }
        }

        @Override
        protected void collect(Query<?> query) {
            this.result = this.getFirst(query);
        }

        private <T> T getFirst(Query<T> q) {
            q.setMaxResults(1);
            Iterator iterator = q.list().iterator();
            if (iterator.hasNext()) {
                return (T)iterator.next();
            }
            return null;
        }
    }

    private final class SingleResultCollector<R>
    extends AbstractHibernateOperations.ResultCollector<R> {
        private R result;

        private SingleResultCollector() {
            super(HibernateJpaOperations.this);
        }

        @Override
        protected void collectTuple(Query<?> query, Function<Tuple, R> fn) {
            Tuple tuple = (Tuple)query.getSingleResult();
            if (tuple != null) {
                this.result = fn.apply(tuple);
            }
        }

        @Override
        protected void collect(Query<?> query) {
            this.result = query.getSingleResult();
        }
    }

    private final class StreamResultCollector<R>
    extends AbstractHibernateOperations.ResultCollector<R> {
        private Stream<R> result;

        private StreamResultCollector() {
            super(HibernateJpaOperations.this);
        }

        @Override
        protected void collectTuple(Query<?> query, Function<Tuple, R> fn) {
            this.result = query.stream().map(fn);
        }

        @Override
        protected void collect(Query<?> query) {
            this.result = query.stream();
        }
    }

    private final class ListResultCollector<R>
    extends AbstractHibernateOperations.ResultCollector<R> {
        private List<R> result;

        private ListResultCollector() {
            super(HibernateJpaOperations.this);
        }

        @Override
        protected void collectTuple(Query<?> query, Function<Tuple, R> fn) {
            this.result = query.list().stream().map(fn).collect(Collectors.toList());
        }

        @Override
        protected void collect(Query<?> query) {
            this.result = query.list();
        }
    }
}

