/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jpa.repository.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.jpa.repository.criteria.Specification;
import io.micronaut.data.model.Sort;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;

public abstract class AbstractSpecificationInterceptor<T, R>
extends AbstractQueryInterceptor<T, R> {
    protected AbstractSpecificationInterceptor(RepositoryOperations operations) {
        super(operations);
    }

    protected Specification getSpecification(MethodInvocationContext<?, ?> context) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof Specification) {
            return (Specification)parameterValue;
        }
        throw new IllegalArgumentException("Argument must be an instance of: " + Specification.class);
    }

    protected final List<Order> getOrders(Sort sort, Root<?> root, CriteriaBuilder cb) {
        ArrayList<Order> orders = new ArrayList<Order>();
        for (Sort.Order order : sort.getOrderBy()) {
            Path propertyPath = root;
            for (String path : StringUtils.splitOmitEmptyStrings((CharSequence)order.getProperty(), (char)'.')) {
                propertyPath = propertyPath.get(path);
            }
            Path expression = order.isIgnoreCase() ? cb.lower(propertyPath.as(String.class)) : propertyPath;
            orders.add(order.isAscending() ? cb.asc((Expression)expression) : cb.desc((Expression)expression));
        }
        return orders;
    }
}

