/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jpa.repository.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.jpa.operations.JpaRepositoryOperations;
import io.micronaut.data.jpa.repository.criteria.Specification;
import io.micronaut.data.jpa.repository.intercept.AbstractSpecificationInterceptor;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import io.micronaut.data.operations.RepositoryOperations;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

@Internal
public class FindPageSpecificationInterceptor
extends AbstractSpecificationInterceptor<Object, Object> {
    private final JpaRepositoryOperations jpaOperations;

    protected FindPageSpecificationInterceptor(@NonNull RepositoryOperations operations) {
        super(operations);
        if (!(operations instanceof JpaRepositoryOperations)) {
            throw new IllegalStateException("Repository operations must be na instance of JpaRepositoryOperations");
        }
        this.jpaOperations = (JpaRepositoryOperations)operations;
    }

    protected final Pageable getPageable(MethodInvocationContext<?, ?> context) {
        Object parameterValue = context.getParameterValues()[1];
        if (parameterValue instanceof Pageable) {
            return (Pageable)parameterValue;
        }
        return Pageable.UNPAGED;
    }

    public Page intercept(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        Class rootEntity;
        EntityManager entityManager;
        CriteriaBuilder criteriaBuilder;
        CriteriaQuery query;
        Root root;
        if (context.getParameterValues().length != 2) {
            throw new IllegalStateException("Expected exactly 2 arguments to method");
        }
        Specification specification = this.getSpecification(context);
        Predicate predicate = specification.toPredicate(root = (query = (criteriaBuilder = (entityManager = this.jpaOperations.getCurrentEntityManager()).getCriteriaBuilder()).createQuery(rootEntity = this.getRequiredRootEntity(context))).from(rootEntity), query, criteriaBuilder);
        if (predicate != null) {
            query.where((Expression)predicate);
        }
        query.select((Selection)root);
        Pageable pageable = this.getPageable(context);
        Sort sort = pageable.getSort();
        if (sort.isSorted()) {
            query.orderBy(this.getOrders(sort, root, criteriaBuilder));
        }
        TypedQuery typedQuery = entityManager.createQuery(query);
        if (pageable.isUnpaged()) {
            List resultList = typedQuery.getResultList();
            return Page.of((List)resultList, (Pageable)pageable, (long)resultList.size());
        }
        typedQuery.setFirstResult((int)pageable.getOffset());
        typedQuery.setMaxResults(pageable.getSize());
        List results = typedQuery.getResultList();
        CriteriaQuery countQuery = criteriaBuilder.createQuery(Long.class);
        Root countRoot = countQuery.from(rootEntity);
        Predicate countPredicate = specification.toPredicate(countRoot, countQuery, criteriaBuilder);
        if (countPredicate != null) {
            countQuery.where((Expression)countPredicate);
        }
        countQuery.select((Selection)criteriaBuilder.count((Expression)countRoot));
        Long singleResult = (Long)entityManager.createQuery(countQuery).getSingleResult();
        return Page.of((List)results, (Pageable)pageable, (long)singleResult);
    }
}

