/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.jakarta.data;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.runtime.support.exceptions.jakarta.data.JakartaDataInsertExceptionConverter;
import jakarta.data.exceptions.DataException;
import jakarta.data.exceptions.EntityExistsException;
import jakarta.data.exceptions.OptimisticLockingFailureException;
import jakarta.inject.Singleton;
import jakarta.persistence.OptimisticLockException;
import jakarta.persistence.PersistenceException;
import org.hibernate.StaleStateException;
import org.hibernate.exception.ConstraintViolationException;

@Internal
@Singleton
@Requires(classes={OptimisticLockingFailureException.class})
final class HibernateJakartaDataPersistExceptionConverter
implements JakartaDataInsertExceptionConverter {
    HibernateJakartaDataPersistExceptionConverter() {
    }

    public Exception convert(Exception exception) {
        if (exception instanceof ConstraintViolationException) {
            throw new EntityExistsException(exception.getMessage(), (Throwable)exception);
        }
        if (exception instanceof StaleStateException || exception instanceof OptimisticLockException) {
            throw new EntityExistsException(exception.getMessage(), (Throwable)exception);
        }
        if (exception instanceof PersistenceException) {
            return new DataException(exception.getMessage(), (Throwable)exception);
        }
        return exception;
    }
}

