/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.jakarta.data;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.runtime.support.exceptions.jakarta.data.JakartaDataUpdateExceptionConverter;
import jakarta.data.exceptions.DataException;
import jakarta.data.exceptions.EmptyResultException;
import jakarta.data.exceptions.OptimisticLockingFailureException;
import jakarta.inject.Singleton;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.OptimisticLockException;
import jakarta.persistence.PersistenceException;
import org.hibernate.StaleStateException;

@Internal
@Singleton
@Requires(classes={OptimisticLockingFailureException.class})
final class HibernateJakartaDataUpdateExceptionConverter
implements JakartaDataUpdateExceptionConverter {
    HibernateJakartaDataUpdateExceptionConverter() {
    }

    public Exception convert(Exception exception) {
        if (exception instanceof NonUniqueResultException) {
            throw new jakarta.data.exceptions.NonUniqueResultException(exception.getMessage(), (Throwable)exception);
        }
        if (exception instanceof NoResultException) {
            throw new EmptyResultException(exception.getMessage(), (Throwable)exception);
        }
        if (exception instanceof StaleStateException || exception instanceof OptimisticLockException) {
            throw new OptimisticLockingFailureException(exception.getMessage(), (Throwable)exception);
        }
        if (exception instanceof PersistenceException) {
            return new DataException(exception.getMessage(), (Throwable)exception);
        }
        return exception;
    }
}

