/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.jakarta.data;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.runtime.support.exceptions.jakarta.data.JakartaDataExceptionConverter;
import jakarta.data.exceptions.DataException;
import jakarta.data.exceptions.EmptyResultException;
import jakarta.data.exceptions.OptimisticLockingFailureException;
import jakarta.inject.Singleton;
import jakarta.persistence.NoResultException;
import jakarta.persistence.PersistenceException;
import org.hibernate.NonUniqueResultException;

@Internal
@Singleton
@Requires(classes={OptimisticLockingFailureException.class})
final class HibernateJakartaDataExceptionConverter
implements JakartaDataExceptionConverter {
    HibernateJakartaDataExceptionConverter() {
    }

    public Exception convert(Exception exception) {
        if (exception instanceof jakarta.persistence.NonUniqueResultException || exception instanceof NonUniqueResultException) {
            throw new jakarta.data.exceptions.NonUniqueResultException(exception.getMessage(), (Throwable)exception);
        }
        if (exception instanceof NoResultException) {
            throw new EmptyResultException(exception.getMessage(), (Throwable)exception);
        }
        if (exception instanceof PersistenceException) {
            return new DataException(exception.getMessage(), (Throwable)exception);
        }
        return exception;
    }
}

