/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.naming;

import io.micronaut.configuration.hibernate.jpa.JpaConfiguration;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.hibernate.naming.DefaultPhysicalNamingStrategy;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.Objects;
import org.hibernate.boot.model.naming.PhysicalNamingStrategy;

@Internal
@Singleton
class PhysicalNamingStrategyConfiguration
implements BeanCreatedEventListener<JpaConfiguration> {
    private final PhysicalNamingStrategy physicalNamingStrategy;

    public PhysicalNamingStrategyConfiguration(PhysicalNamingStrategy physicalNamingStrategy) {
        Objects.requireNonNull(physicalNamingStrategy, "PhysicalNamingStrategy cannot be null");
        this.physicalNamingStrategy = physicalNamingStrategy;
    }

    public JpaConfiguration onCreated(BeanCreatedEvent<JpaConfiguration> event) {
        JpaConfiguration jpaConfiguration = (JpaConfiguration)event.getBean();
        Map jpaProperties = jpaConfiguration.getProperties();
        jpaProperties.putIfAbsent("hibernate.physical_naming_strategy", this.physicalNamingStrategy);
        if (jpaProperties.get("hibernate.physical_naming_strategy") instanceof DefaultPhysicalNamingStrategy) {
            jpaProperties.putIfAbsent("hibernate.id.db_structure_naming_strategy", "legacy");
        }
        return jpaConfiguration;
    }
}

