/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.operations;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.annotation.QueryHint;
import io.micronaut.data.annotation.sql.Procedure;
import io.micronaut.data.hibernate.conf.RequiresSyncHibernate;
import io.micronaut.data.hibernate.operations.AbstractHibernateOperations;
import io.micronaut.data.jpa.annotation.EntityGraph;
import io.micronaut.data.jpa.operations.JpaRepositoryOperations;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import io.micronaut.data.operations.CriteriaRepositoryOperations;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.async.AsyncCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveRepositoryOperations;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.operations.ExecutorAsyncOperations;
import io.micronaut.data.runtime.operations.ExecutorAsyncOperationsSupportingCriteria;
import io.micronaut.data.runtime.operations.ExecutorReactiveOperationsSupportingCriteria;
import io.micronaut.transaction.TransactionOperations;
import jakarta.inject.Named;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.Parameter;
import jakarta.persistence.ParameterMode;
import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.graph.RootGraph;
import org.hibernate.procedure.ProcedureCall;
import org.hibernate.query.CommonQueryContract;
import org.hibernate.query.MutationQuery;
import org.hibernate.query.Query;

@RequiresSyncHibernate
@EachBean(value=DataSource.class)
final class HibernateJpaOperations
extends AbstractHibernateOperations<Session, CommonQueryContract, Query<?>>
implements JpaRepositoryOperations,
AsyncCapableRepository,
ReactiveCapableRepository,
CriteriaRepositoryOperations {
    private final SessionFactory sessionFactory;
    private final TransactionOperations<Session> transactionOperations;
    private ExecutorAsyncOperations asyncOperations;
    private ExecutorService executorService;

    public HibernateJpaOperations(@NonNull @io.micronaut.context.annotation.Parameter SessionFactory sessionFactory, @NonNull @io.micronaut.context.annotation.Parameter TransactionOperations<Session> transactionOperations, @Named(value="io") @Nullable ExecutorService executorService, RuntimeEntityRegistry runtimeEntityRegistry, DataConversionService dataConversionService) {
        super(runtimeEntityRegistry, dataConversionService);
        ArgumentUtils.requireNonNull((String)"sessionFactory", (Object)sessionFactory);
        this.sessionFactory = sessionFactory;
        this.transactionOperations = transactionOperations;
        this.executorService = executorService;
    }

    @Override
    public <T> RuntimePersistentEntity<T> getEntity(Class<T> type) {
        return this.runtimeEntityRegistry.getEntity(type);
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return super.getApplicationContext();
    }

    @Override
    public ConversionService getConversionService() {
        return super.getConversionService();
    }

    @Override
    protected void setParameter(CommonQueryContract query, String parameterName, Object value) {
        query.setParameter(parameterName, value);
    }

    @Override
    protected void setParameter(CommonQueryContract query, String parameterName, Object value, Argument<?> argument) {
        query.setParameter(parameterName, value);
    }

    @Override
    protected void setParameterList(CommonQueryContract query, String parameterName, Collection<Object> value) {
        query.setParameter(parameterName, value);
    }

    @Override
    protected void setParameterList(CommonQueryContract query, String parameterName, Collection<Object> value, Argument<?> argument) {
        if (value == null) {
            value = Collections.emptyList();
        }
        query.setParameter(parameterName, value);
    }

    @Override
    protected void setParameter(CommonQueryContract query, int parameterIndex, Object value) {
        query.setParameter(parameterIndex, value);
    }

    @Override
    protected void setParameter(CommonQueryContract query, int parameterIndex, Object value, Argument<?> argument) {
        query.setParameter(parameterIndex, value);
    }

    @Override
    protected void setParameterList(CommonQueryContract query, int parameterIndex, Collection<Object> value) {
        query.setParameter(parameterIndex, value);
    }

    @Override
    protected void setParameterList(CommonQueryContract query, int parameterIndex, Collection<Object> value, Argument<?> argument) {
        if (value == null) {
            value = Collections.emptyList();
        }
        query.setParameter(parameterIndex, (Object)parameterIndex);
    }

    @Override
    protected void setHint(Query<?> query, String hintName, Object value) {
        query.setHint(hintName, value);
    }

    @Override
    protected <T> RootGraph<T> getEntityGraph(Session session, Class<T> entityType, String graphName) {
        return session.getEntityGraph(graphName);
    }

    @Override
    protected <T> RootGraph<T> createEntityGraph(Session session, Class<T> entityType) {
        return session.createEntityGraph(entityType);
    }

    @Override
    protected Query<?> createQuery(Session session, String query, Class<?> resultType) {
        return session.createQuery(query, resultType);
    }

    @Override
    protected Query<?> createNativeQuery(Session session, String query, Class<?> resultType) {
        return session.createNativeQuery(query, resultType);
    }

    @Override
    protected Query<?> createQuery(Session session, CriteriaQuery<?> criteriaQuery) {
        return session.createQuery(criteriaQuery);
    }

    @Override
    protected void setOffset(Query<?> query, int offset) {
        query.setFirstResult(offset);
    }

    @Override
    protected void setMaxResults(Query<?> query, int max) {
        query.setMaxResults(max);
    }

    @Override
    @NonNull
    public Map<String, Object> getQueryHints(@NonNull StoredQuery<?, ?> storedQuery) {
        return super.getQueryHints(storedQuery);
    }

    @Nullable
    public <T> T findOne(@NonNull Class<T> type, @NonNull Object id) {
        return (T)this.executeRead(session -> session.byId(type).load(id));
    }

    @NonNull
    public <T> T load(@NonNull Class<T> type, @NonNull Object id) {
        return (T)this.executeRead(session -> session.getReference(type, id));
    }

    public <T> T merge(T entity) {
        return (T)this.executeWrite(session -> session.merge(entity));
    }

    @Nullable
    public <T, R> R findOne(@NonNull PreparedQuery<T, R> preparedQuery) {
        return (R)this.executeRead(session -> {
            boolean limitOne = !preparedQuery.isNative() && !this.hasEntityGraph(preparedQuery.getAnnotationMetadata());
            FirstResultCollector collector = new FirstResultCollector(limitOne);
            this.collectFindOne(session, preparedQuery, collector);
            return collector.result;
        });
    }

    public <T> boolean exists(@NonNull PreparedQuery<T, Boolean> preparedQuery) {
        return this.findOne(preparedQuery) != null;
    }

    @NonNull
    public <T> Iterable<T> findAll(@NonNull PagedQuery<T> pagedQuery) {
        return this.executeRead(session -> this.findPaged((Session)session, pagedQuery));
    }

    @NonNull
    public <T> Stream<T> findStream(@NonNull PagedQuery<T> pagedQuery) {
        return this.executeRead(session -> {
            StreamResultCollector collector = new StreamResultCollector();
            this.collectPagedResults((CriteriaBuilder)this.sessionFactory.getCriteriaBuilder(), session, pagedQuery, collector);
            return collector.result;
        });
    }

    public <R> Page<R> findPage(@NonNull PagedQuery<R> pagedQuery) {
        return this.executeRead(session -> Page.of(this.findPaged((Session)session, (PagedQuery)pagedQuery), (Pageable)pagedQuery.getPageable(), (long)this.countOf((Session)session, (PagedQuery)pagedQuery, pagedQuery.getPageable())));
    }

    public <T> long count(PagedQuery<T> pagedQuery) {
        return this.executeRead(session -> this.countOf((Session)session, pagedQuery, null));
    }

    private <T> List<T> findPaged(Session session, PagedQuery<T> pagedQuery) {
        ListResultCollector collector = new ListResultCollector();
        this.collectPagedResults((CriteriaBuilder)this.sessionFactory.getCriteriaBuilder(), session, pagedQuery, collector);
        return collector.result;
    }

    private <T> Long countOf(Session session, PagedQuery<T> pagedQuery, @Nullable Pageable pageable) {
        SingleResultCollector<Long> collector = new SingleResultCollector<Long>();
        this.collectCountOf((CriteriaBuilder)this.sessionFactory.getCriteriaBuilder(), session, pagedQuery.getRootEntity(), pageable, collector);
        return (Long)collector.result;
    }

    @NonNull
    public <T, R> Iterable<R> findAll(@NonNull PreparedQuery<T, R> preparedQuery) {
        return this.executeRead(session -> {
            ListResultCollector resultCollector = new ListResultCollector();
            this.collectFindAll(session, preparedQuery, resultCollector);
            return resultCollector.result;
        });
    }

    public <T> T persist(@NonNull InsertOperation<T> operation) {
        return (T)this.executeWrite(session -> {
            Object entity = operation.getEntity();
            session.persist(entity);
            this.flushIfNecessary((EntityManager)session, operation.getAnnotationMetadata());
            return entity;
        });
    }

    @NonNull
    public <T> T update(@NonNull UpdateOperation<T> operation) {
        StoredQuery storedQuery = operation.getStoredQuery();
        return (T)this.executeWrite(session -> {
            if (storedQuery != null) {
                this.executeEntityUpdate((Session)session, (StoredQuery<?, ?>)storedQuery, operation.getEntity());
                if (this.flushIfNecessary((EntityManager)session, operation.getAnnotationMetadata())) {
                    session.remove(operation.getEntity());
                }
                return operation.getEntity();
            }
            Object entity = operation.getEntity();
            entity = session.merge(entity);
            this.flushIfNecessary((EntityManager)session, operation.getAnnotationMetadata());
            return entity;
        });
    }

    @NonNull
    public <T> Iterable<T> updateAll(@NonNull UpdateBatchOperation<T> operation) {
        StoredQuery storedQuery = operation.getStoredQuery();
        return this.executeWrite(session -> {
            if (storedQuery != null) {
                for (Object entity : operation) {
                    this.executeEntityUpdate((Session)session, (StoredQuery<?, ?>)storedQuery, entity);
                }
                if (this.flushIfNecessary((EntityManager)session, operation.getAnnotationMetadata())) {
                    for (Object entity : operation) {
                        session.remove(entity);
                    }
                }
                return operation;
            }
            ArrayList<Object> results = new ArrayList<Object>();
            for (Object entity : operation) {
                Object merge = session.merge(entity);
                results.add(merge);
            }
            this.flushIfNecessary((EntityManager)session, operation.getAnnotationMetadata());
            return results;
        });
    }

    @NonNull
    public <T> Iterable<T> persistAll(@NonNull InsertBatchOperation<T> operation) {
        return this.executeWrite(session -> {
            if (operation == null) {
                return Collections.emptyList();
            }
            for (Object entity : operation) {
                session.persist(entity);
            }
            this.flushIfNecessary((EntityManager)session, operation.getAnnotationMetadata());
            return operation;
        });
    }

    private boolean flushIfNecessary(EntityManager entityManager, AnnotationMetadata annotationMetadata) {
        return this.flushIfNecessary(entityManager, annotationMetadata, false);
    }

    private boolean flushIfNecessary(EntityManager entityManager, AnnotationMetadata annotationMetadata, boolean clear) {
        FlushModeType flushModeType;
        if (annotationMetadata.hasAnnotation(QueryHint.class) && (flushModeType = this.getFlushModeType(annotationMetadata)) == FlushModeType.AUTO) {
            entityManager.flush();
            if (clear) {
                entityManager.clear();
            }
            return true;
        }
        return false;
    }

    @NonNull
    public Optional<Number> executeUpdate(@NonNull PreparedQuery<?, Number> preparedQuery) {
        return this.executeWrite(session -> {
            String query = preparedQuery.getQuery();
            MutationQuery q = preparedQuery.isNative() ? session.createNativeMutationQuery(query) : session.createMutationQuery(query);
            this.bindParameters(q, preparedQuery, true);
            int numAffected = q.executeUpdate();
            this.flushIfNecessary((EntityManager)session, preparedQuery.getAnnotationMetadata(), true);
            return Optional.of(numAffected);
        });
    }

    public <R> List<R> execute(PreparedQuery<?, R> preparedQuery) {
        return this.executeWrite(session -> {
            boolean needsOutRegistered = false;
            if (preparedQuery.isProcedure()) {
                ProcedureCall procedureQuery;
                Optional named = preparedQuery.getAnnotationMetadata().stringValue(Procedure.class, "named");
                if (named.isPresent()) {
                    procedureQuery = session.createNamedStoredProcedureQuery((String)named.get());
                } else {
                    String procedureName = preparedQuery.getAnnotationMetadata().stringValue(Procedure.class).orElseGet(() -> ((PreparedQuery)preparedQuery).getName());
                    if (preparedQuery.getResultArgument().isVoid()) {
                        procedureQuery = session.createStoredProcedureQuery(procedureName);
                    } else {
                        procedureQuery = session.createStoredProcedureQuery(procedureName, new Class[]{preparedQuery.getResultArgument().getType()});
                        needsOutRegistered = true;
                    }
                    int index = 1;
                    for (QueryParameterBinding queryBinding : preparedQuery.getQueryBindings()) {
                        int parameterIndex = queryBinding.getParameterIndex();
                        Argument argument = preparedQuery.getArguments()[parameterIndex];
                        procedureQuery.registerStoredProcedureParameter(index++, argument.getType(), ParameterMode.IN);
                    }
                    if (needsOutRegistered) {
                        procedureQuery.registerStoredProcedureParameter(index, preparedQuery.getResultArgument().getType(), ParameterMode.OUT);
                    }
                }
                boolean bindNamed = procedureQuery.getRegisteredParameters().stream().anyMatch(p -> p.getName() != null);
                this.bindParameters(procedureQuery, preparedQuery, bindNamed);
                procedureQuery.execute();
                if (preparedQuery.getResultArgument().isVoid()) {
                    this.flushIfNecessary((EntityManager)session, preparedQuery.getAnnotationMetadata(), true);
                    return List.of();
                }
                Parameter procedureParameter = (Parameter)procedureQuery.getRegisteredParameters().stream().filter(p -> p.getMode() == ParameterMode.OUT).findFirst().orElseThrow(() -> new IllegalStateException("Cannot determine the output parameter!"));
                Object result = bindNamed ? procedureQuery.getOutputParameterValue(procedureParameter.getName()) : procedureQuery.getOutputParameterValue(preparedQuery.getQueryBindings().size() + 1);
                return List.of(result);
            }
            if (preparedQuery.isNative()) {
                Iterable result = this.findAll(preparedQuery);
                return (List)result;
            }
            throw new IllegalStateException("Only native query supports update RETURNING operations.");
        });
    }

    public <T> int delete(@NonNull DeleteOperation<T> operation) {
        StoredQuery storedQuery = operation.getStoredQuery();
        return this.executeWrite(session -> {
            if (storedQuery != null) {
                int numAffected = this.executeEntityUpdate((Session)session, (StoredQuery<?, ?>)storedQuery, operation.getEntity());
                if (this.flushIfNecessary((EntityManager)session, operation.getAnnotationMetadata())) {
                    session.remove(operation.getEntity());
                }
                return numAffected;
            }
            session.remove(operation.getEntity());
            return 1;
        });
    }

    public <T> Optional<Number> deleteAll(@NonNull DeleteBatchOperation<T> operation) {
        StoredQuery storedQuery = operation.getStoredQuery();
        Integer result = this.executeWrite(session -> {
            if (storedQuery != null) {
                int i = 0;
                for (Object entity : operation) {
                    i += this.executeEntityUpdate((Session)session, (StoredQuery<?, ?>)storedQuery, entity);
                }
                if (this.flushIfNecessary((EntityManager)session, operation.getAnnotationMetadata())) {
                    for (Object entity : operation) {
                        session.remove(entity);
                    }
                }
                return i;
            }
            int i = 0;
            for (Object entity : operation) {
                session.remove(entity);
                ++i;
            }
            return i;
        });
        return Optional.ofNullable(result);
    }

    private int executeEntityUpdate(Session session, StoredQuery<?, ?> storedQuery, Object entity) {
        MutationQuery query = session.createMutationQuery(storedQuery.getQuery());
        for (QueryParameterBinding queryParameterBinding : storedQuery.getQueryBindings()) {
            query.setParameter(queryParameterBinding.getRequiredName(), this.getParameterValue(queryParameterBinding.getRequiredPropertyPath(), entity));
        }
        return query.executeUpdate();
    }

    @NonNull
    public <T, R> Stream<R> findStream(@NonNull PreparedQuery<T, R> preparedQuery) {
        return this.executeRead(session -> {
            StreamResultCollector resultCollector = new StreamResultCollector();
            this.collectFindAll(session, preparedQuery, resultCollector);
            return resultCollector.result;
        });
    }

    private <R> R executeRead(Function<Session, R> callback) {
        return (R)this.transactionOperations.executeRead(status -> callback.apply(this.getCurrentSession()));
    }

    private <R> R executeWrite(Function<Session, R> callback) {
        return (R)this.transactionOperations.executeWrite(status -> callback.apply(this.getCurrentSession()));
    }

    private Session getCurrentSession() {
        return this.sessionFactory.getCurrentSession();
    }

    @NonNull
    private ExecutorService newLocalThreadPool() {
        this.executorService = Executors.newCachedThreadPool();
        return this.executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ExecutorAsyncOperations async() {
        ExecutorAsyncOperations executorAsyncOperations = this.asyncOperations;
        if (executorAsyncOperations == null) {
            HibernateJpaOperations hibernateJpaOperations = this;
            synchronized (hibernateJpaOperations) {
                executorAsyncOperations = this.asyncOperations;
                if (executorAsyncOperations == null) {
                    this.asyncOperations = executorAsyncOperations = new ExecutorAsyncOperationsSupportingCriteria((RepositoryOperations)this, (CriteriaRepositoryOperations)this, (Executor)(this.executorService != null ? this.executorService : this.newLocalThreadPool()));
                }
            }
        }
        return executorAsyncOperations;
    }

    @NonNull
    public ReactiveRepositoryOperations reactive() {
        ConversionService conversionService = this.dataConversionService;
        if (conversionService instanceof DataConversionService) {
            DataConversionService asDataConversionService = (DataConversionService)conversionService;
            return new ExecutorReactiveOperationsSupportingCriteria((ExecutorAsyncOperationsSupportingCriteria)this.async(), asDataConversionService);
        }
        return new ExecutorReactiveOperationsSupportingCriteria((ExecutorAsyncOperationsSupportingCriteria)this.async(), null);
    }

    @NonNull
    public EntityManager getCurrentEntityManager() {
        return this.sessionFactory.getCurrentSession();
    }

    @NonNull
    public EntityManagerFactory getEntityManagerFactory() {
        return this.sessionFactory;
    }

    public void flush() {
        this.executeWrite(session -> {
            session.flush();
            return null;
        });
    }

    private boolean hasEntityGraph(AnnotationMetadata annotationMetadata) {
        return annotationMetadata.hasAnnotation(EntityGraph.class);
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.sessionFactory.getCriteriaBuilder();
    }

    public <R> R findOne(CriteriaQuery<R> query) {
        return (R)this.executeRead(session -> session.createQuery(query).uniqueResult());
    }

    public <T> List<T> findAll(CriteriaQuery<T> query) {
        return this.executeRead(session -> session.createQuery(query).getResultList());
    }

    public <T> List<T> findAll(CriteriaQuery<T> query, int offset, int limit) {
        return this.executeRead(session -> {
            Query sessionQuery = session.createQuery(query);
            if (offset != -1) {
                sessionQuery = sessionQuery.setFirstResult(offset);
            }
            if (limit != -1) {
                sessionQuery = sessionQuery.setMaxResults(limit);
            }
            return sessionQuery.getResultList();
        });
    }

    public Optional<Number> updateAll(CriteriaUpdate<Number> query) {
        return Optional.ofNullable((Number)this.executeWrite(session -> session.createMutationQuery(query).executeUpdate()));
    }

    public Optional<Number> deleteAll(CriteriaDelete<Number> query) {
        return Optional.ofNullable((Number)this.executeWrite(session -> session.createMutationQuery(query).executeUpdate()));
    }

    private final class ListResultCollector<R>
    extends AbstractHibernateOperations.ResultCollector<R> {
        private List<R> result;

        private ListResultCollector() {
        }

        @Override
        protected void collectTuple(Query<?> query, Function<Tuple, R> fn) {
            this.result = query.getResultList().stream().map(fn).toList();
        }

        @Override
        protected void collect(Query<?> query) {
            this.result = query.getResultList();
        }
    }

    private final class SingleResultCollector<R>
    extends AbstractHibernateOperations.ResultCollector<R> {
        private R result;

        private SingleResultCollector() {
        }

        @Override
        protected void collectTuple(Query<?> query, Function<Tuple, R> fn) {
            Tuple tuple = (Tuple)query.getSingleResult();
            if (tuple != null) {
                this.result = fn.apply(tuple);
            }
        }

        @Override
        protected void collect(Query<?> query) {
            this.result = query.getSingleResult();
        }
    }

    private final class StreamResultCollector<R>
    extends AbstractHibernateOperations.ResultCollector<R> {
        private Stream<R> result;

        private StreamResultCollector() {
        }

        @Override
        protected void collectTuple(Query<?> query, Function<Tuple, R> fn) {
            this.result = query.getResultStream().map(fn);
        }

        @Override
        protected void collect(Query<?> query) {
            this.result = query.getResultStream();
        }
    }

    private final class FirstResultCollector<R>
    extends AbstractHibernateOperations.ResultCollector<R> {
        private final boolean limitOne;
        private R result;

        private FirstResultCollector(boolean limitOne) {
            this.limitOne = limitOne;
        }

        @Override
        protected void collectTuple(Query<?> query, Function<Tuple, R> fn) {
            Tuple tuple = (Tuple)this.getFirst(query);
            if (tuple != null) {
                this.result = fn.apply(tuple);
            }
        }

        @Override
        protected void collect(Query<?> query) {
            this.result = this.getFirst(query);
        }

        private <T> T getFirst(Query<?> q) {
            Iterator iterator;
            if (this.limitOne) {
                q.setMaxResults(1);
            }
            if ((iterator = q.getResultList().iterator()).hasNext()) {
                return (T)iterator.next();
            }
            return null;
        }
    }
}

