/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.operations;

import io.micronaut.aop.InvocationContext;
import io.micronaut.context.ApplicationContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.QueryHint;
import io.micronaut.data.jpa.annotation.EntityGraph;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.builder.jpa.JpaQueryBuilder;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.QueryParameterBinding;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.operations.HintsCapableRepository;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.mapper.BeanIntrospectionMapper;
import io.micronaut.data.runtime.operations.internal.query.BindableParametersPreparedQuery;
import io.micronaut.data.runtime.operations.internal.query.BindableParametersStoredQuery;
import io.micronaut.data.runtime.operations.internal.query.DefaultBindableParametersPreparedQuery;
import io.micronaut.data.runtime.operations.internal.query.DefaultBindableParametersStoredQuery;
import io.micronaut.data.runtime.query.PreparedQueryDecorator;
import io.micronaut.data.runtime.query.StoredQueryDecorator;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.Tuple;
import jakarta.persistence.TupleElement;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.graph.AttributeNode;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.SubGraph;

@Internal
public abstract class AbstractHibernateOperations<S, Q, P extends Q>
implements HintsCapableRepository,
PreparedQueryDecorator,
StoredQueryDecorator {
    private static final JpaQueryBuilder QUERY_BUILDER = new JpaQueryBuilder();
    private static final String ENTITY_GRAPH_FETCH = "jakarta.persistence.fetchgraph";
    private static final String ENTITY_GRAPH_LOAD = "jakarta.persistence.loadgraph";
    protected final ConversionService dataConversionService;
    protected final RuntimeEntityRegistry runtimeEntityRegistry;

    protected AbstractHibernateOperations(RuntimeEntityRegistry runtimeEntityRegistry, DataConversionService dataConversionService) {
        this.runtimeEntityRegistry = runtimeEntityRegistry;
        this.dataConversionService = dataConversionService == null ? ConversionService.SHARED : dataConversionService;
    }

    public <E, R> PreparedQuery<E, R> decorate(PreparedQuery<E, R> preparedQuery) {
        return new DefaultBindableParametersPreparedQuery(preparedQuery);
    }

    public <E, R> StoredQuery<E, R> decorate(StoredQuery<E, R> storedQuery) {
        RuntimePersistentEntity runtimePersistentEntity = this.runtimeEntityRegistry.getEntity(storedQuery.getRootEntity());
        return new DefaultBindableParametersStoredQuery(storedQuery, runtimePersistentEntity);
    }

    protected ApplicationContext getApplicationContext() {
        return this.runtimeEntityRegistry.getApplicationContext();
    }

    protected ConversionService getConversionService() {
        return this.dataConversionService;
    }

    @NonNull
    protected abstract <T> RuntimePersistentEntity<T> getEntity(@NonNull Class<T> var1);

    @NonNull
    public Map<String, Object> getQueryHints(@NonNull StoredQuery<?, ?> storedQuery) {
        AnnotationMetadata annotationMetadata = storedQuery.getAnnotationMetadata();
        if (annotationMetadata.hasAnnotation(EntityGraph.class)) {
            String hint = annotationMetadata.stringValue(EntityGraph.class, "hint").orElse(ENTITY_GRAPH_FETCH);
            String graphName = annotationMetadata.stringValue(EntityGraph.class).orElse(null);
            Object[] paths = annotationMetadata.stringValues(EntityGraph.class, "attributePaths");
            if (graphName != null) {
                return Collections.singletonMap(hint, graphName);
            }
            if (ArrayUtils.isNotEmpty((Object[])paths)) {
                return Collections.singletonMap(hint, paths);
            }
        }
        return Collections.emptyMap();
    }

    protected abstract void setParameter(Q var1, String var2, Object var3);

    protected abstract void setParameter(Q var1, String var2, Object var3, Argument<?> var4);

    protected abstract void setParameterList(Q var1, String var2, Collection<Object> var3);

    protected abstract void setParameterList(Q var1, String var2, Collection<Object> var3, Argument<?> var4);

    protected abstract void setParameter(Q var1, int var2, Object var3);

    protected abstract void setParameter(Q var1, int var2, Object var3, Argument<?> var4);

    protected abstract void setParameterList(Q var1, int var2, Collection<Object> var3);

    protected abstract void setParameterList(Q var1, int var2, Collection<Object> var3, Argument<?> var4);

    protected abstract void setHint(P var1, String var2, Object var3);

    protected abstract void setMaxResults(P var1, int var2);

    protected abstract void setOffset(P var1, int var2);

    protected abstract <T> jakarta.persistence.EntityGraph<T> getEntityGraph(S var1, Class<T> var2, String var3);

    protected abstract <T> jakarta.persistence.EntityGraph<T> createEntityGraph(S var1, Class<T> var2);

    protected abstract P createQuery(S var1, String var2, @Nullable Class<?> var3);

    protected abstract P createNativeQuery(S var1, String var2, Class<?> var3);

    protected abstract P createQuery(S var1, CriteriaQuery<?> var2);

    protected <R> void collectFindOne(S session, PreparedQuery<?, R> preparedQuery, ResultCollector<R> collector) {
        String query = preparedQuery.getQuery();
        this.collectResults(session, query, preparedQuery, collector);
    }

    protected <R> void collectFindAll(S session, PreparedQuery<?, R> preparedQuery, ResultCollector<R> collector) {
        Object queryStr = preparedQuery.getQuery();
        Pageable pageable = preparedQuery.getPageable();
        if (pageable != Pageable.UNPAGED) {
            if (pageable.getMode() != Pageable.Mode.OFFSET) {
                throw new UnsupportedOperationException("Pageable mode " + pageable.getMode() + " is not supported by hibernate operations");
            }
            Sort sort = pageable.getSort();
            if (sort.isSorted()) {
                queryStr = (String)queryStr + QUERY_BUILDER.buildOrderBy((String)queryStr, this.getEntity(preparedQuery.getRootEntity()), AnnotationMetadata.EMPTY_METADATA, sort, preparedQuery.isNative()).getQuery();
            }
        }
        this.collectResults(session, (String)queryStr, preparedQuery, collector);
    }

    private <T, R> void collectResults(S session, String queryStr, PreparedQuery<T, R> preparedQuery, ResultCollector<R> resultCollector) {
        if (preparedQuery.isDtoProjection()) {
            P q;
            if (preparedQuery.isNative()) {
                q = this.createNativeQuery(session, queryStr, Tuple.class);
            } else {
                if (queryStr.toLowerCase(Locale.ENGLISH).startsWith("select new ")) {
                    Class wrapperType = ReflectionUtils.getWrapperType((Class)preparedQuery.getResultType());
                    P query = this.createQuery(session, queryStr, wrapperType);
                    this.bindPreparedQuery(query, preparedQuery, session);
                    resultCollector.collect(query);
                    return;
                }
                q = this.createQuery(session, queryStr, Tuple.class);
            }
            this.bindPreparedQuery(q, preparedQuery, session);
            resultCollector.collectTuple(q, tuple -> {
                final Set properties = tuple.getElements().stream().map(TupleElement::getAlias).collect(Collectors.toCollection(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER)));
                return new BeanIntrospectionMapper<Tuple, R>(){

                    public Object read(Tuple tuple1, String alias) {
                        if (!properties.contains(alias)) {
                            return null;
                        }
                        return tuple1.get(alias);
                    }

                    public ConversionService getConversionService() {
                        return AbstractHibernateOperations.this.dataConversionService;
                    }
                }.map(tuple, preparedQuery.getResultType());
            });
        } else {
            P q;
            Class wrapperType = ReflectionUtils.getWrapperType((Class)preparedQuery.getResultType());
            if (preparedQuery.isNative()) {
                Class rootEntity = preparedQuery.getRootEntity();
                if (wrapperType != rootEntity) {
                    P nativeQuery = this.createNativeQuery(session, queryStr, Tuple.class);
                    this.bindPreparedQuery(nativeQuery, preparedQuery, session);
                    resultCollector.collectTuple(nativeQuery, tuple -> {
                        Object o = tuple.get(0);
                        if (wrapperType.isInstance(o)) {
                            return o;
                        }
                        return this.dataConversionService.convertRequired(o, wrapperType);
                    });
                    return;
                }
                q = this.createNativeQuery(session, queryStr, wrapperType);
            } else {
                q = this.createQuery(session, queryStr, wrapperType);
            }
            this.bindPreparedQuery(q, preparedQuery, session);
            resultCollector.collect(q);
        }
    }

    protected <T, R> void bindParameters(Q q, @NonNull PreparedQuery<T, R> preparedQuery, boolean bindNamed) {
        BindableParametersPreparedQuery<T, R> bindableParametersPreparedQuery = this.getBindableParametersPreparedQuery(preparedQuery);
        BindableParametersStoredQuery.Binder binder = this.createBinder(q, (StoredQuery<T, R>)preparedQuery, (Argument<?>[])preparedQuery.getArguments(), bindNamed);
        bindableParametersPreparedQuery.bindParameters(binder);
    }

    protected <T, R> void bindParameters(Q q, @NonNull StoredQuery<T, R> storedQuery, InvocationContext<?, ?> invocationContext, boolean bindNamed, T entity) {
        BindableParametersStoredQuery bindableParametersPreparedQuery = (BindableParametersStoredQuery)storedQuery;
        BindableParametersStoredQuery.Binder binder = this.createBinder(q, storedQuery, invocationContext.getArguments(), bindNamed);
        bindableParametersPreparedQuery.bindParameters(binder, invocationContext, entity, null);
    }

    private <T, R> BindableParametersStoredQuery.Binder createBinder(final Q q, final StoredQuery<T, R> storedQuery, final Argument<?>[] arguments, final boolean bindNamed) {
        return new BindableParametersStoredQuery.Binder(){
            int index = 1;

            public Object autoPopulateRuntimeProperty(RuntimePersistentProperty<?> persistentProperty, Object previousValue) {
                return AbstractHibernateOperations.this.runtimeEntityRegistry.autoPopulateRuntimeProperty(persistentProperty, previousValue);
            }

            public Object convert(Object value, RuntimePersistentProperty<?> property) {
                return value;
            }

            public Object convert(Class<?> converterClass, Object value, Argument<?> argument) {
                return value;
            }

            public void bindOne(QueryParameterBinding binding, Object value) {
                String parameterName = Objects.requireNonNull(binding.getName(), "Parameter name cannot be null!");
                if (storedQuery.isNative()) {
                    int parameterIndex = binding.getParameterIndex();
                    Argument argument = arguments[parameterIndex];
                    Class argumentType = argument.getType();
                    if (Collection.class.isAssignableFrom(argumentType)) {
                        if (bindNamed) {
                            AbstractHibernateOperations.this.setParameterList(q, parameterName, value == null ? Collections.emptyList() : (Collection)value, argument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT));
                        } else {
                            AbstractHibernateOperations.this.setParameterList(q, this.index, value == null ? Collections.emptyList() : (Collection)value, argument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT));
                        }
                    } else if (Object[].class.isAssignableFrom(argumentType)) {
                        List<Object> coll;
                        if (value == null) {
                            coll = Collections.emptyList();
                        } else if (value instanceof Collection) {
                            Collection collection = (Collection)value;
                            coll = collection;
                        } else {
                            coll = Arrays.asList((Object[])value);
                        }
                        if (bindNamed) {
                            AbstractHibernateOperations.this.setParameterList(q, parameterName, coll);
                        } else {
                            AbstractHibernateOperations.this.setParameterList(q, this.index, coll);
                        }
                    } else if (bindNamed) {
                        AbstractHibernateOperations.this.setParameter(q, parameterName, value, argument);
                    } else {
                        AbstractHibernateOperations.this.setParameter(q, this.index, value, argument);
                    }
                } else if (bindNamed) {
                    AbstractHibernateOperations.this.setParameter(q, parameterName, value);
                } else {
                    AbstractHibernateOperations.this.setParameter(q, this.index, value);
                }
                ++this.index;
            }

            public void bindMany(QueryParameterBinding binding, Collection<Object> values) {
                this.bindOne(binding, values);
            }
        };
    }

    private <T, R> void bindPreparedQuery(P q, @NonNull PreparedQuery<T, R> preparedQuery, S currentSession) {
        this.bindParameters(q, preparedQuery, true);
        this.bindPageable(q, preparedQuery.getPageable());
        this.bindQueryHints(q, (PagedQuery<T>)preparedQuery, currentSession);
    }

    private <T> void bindQueryHints(P q, @NonNull PagedQuery<T> preparedQuery, @NonNull S session) {
        Map queryHints = preparedQuery.getQueryHints();
        if (CollectionUtils.isNotEmpty((Map)queryHints)) {
            for (Map.Entry entry : queryHints.entrySet()) {
                String hintName = (String)entry.getKey();
                Object value = entry.getValue();
                if (ENTITY_GRAPH_FETCH.equals(hintName) || ENTITY_GRAPH_LOAD.equals(hintName)) {
                    Object[] pathsDefinitions;
                    jakarta.persistence.EntityGraph<T> entityGraph;
                    String graphName = preparedQuery.getAnnotationMetadata().stringValue(EntityGraph.class).orElse(null);
                    if (graphName != null) {
                        entityGraph = this.getEntityGraph(session, preparedQuery.getRootEntity(), graphName);
                        this.setHint(q, hintName, entityGraph);
                        continue;
                    }
                    if (!(value instanceof String[]) || !ArrayUtils.isNotEmpty((Object[])(pathsDefinitions = (String[])value))) continue;
                    entityGraph = this.createGraph((String[])pathsDefinitions, session, preparedQuery.getRootEntity());
                    this.setHint(q, hintName, entityGraph);
                    continue;
                }
                this.setHint(q, hintName, value);
            }
        }
    }

    private <T> RootGraph<T> createGraph(@NonNull String[] paths, @NonNull S session, @NonNull Class<T> rootEntity) {
        RootGraph rootGraph = (RootGraph)this.createEntityGraph(session, rootEntity);
        for (String path : paths) {
            if (path.trim().isEmpty()) continue;
            String[] parts = path.split("\\.");
            if (parts.length == 1) {
                AttributeNode attrNode = rootGraph.findAttributeNode(path);
                if (attrNode != null) continue;
                rootGraph.addAttributeNode(path);
                continue;
            }
            RootGraph graph = rootGraph;
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                AttributeNode attrNode = graph.findAttributeNode(part);
                if (attrNode != null) {
                    SubGraph subGraph;
                    SubGraph subGraph2 = subGraph = attrNode.getSubGraphs().isEmpty() ? null : (SubGraph)attrNode.getSubGraphs().values().iterator().next();
                    if (subGraph == null && i < parts.length - 1) {
                        graph = graph.addSubGraph(part);
                        continue;
                    }
                    if (subGraph == null) continue;
                    graph = subGraph;
                    continue;
                }
                if (i == parts.length - 1) {
                    graph.addAttributeNode(part);
                    continue;
                }
                graph = graph.addSubGraph(part);
            }
        }
        return rootGraph;
    }

    protected final FlushModeType getFlushModeType(AnnotationMetadata annotationMetadata) {
        return annotationMetadata.getAnnotationValuesByType(QueryHint.class).stream().filter(av -> FlushModeType.class.getName().equals(av.stringValue("name").orElse(null))).map(av -> av.enumValue("value", FlushModeType.class)).findFirst().orElse(Optional.empty()).orElse(null);
    }

    private void bindPageable(P q, @NonNull Pageable pageable) {
        long offset;
        if (pageable == Pageable.UNPAGED) {
            return;
        }
        if (pageable.getMode() != Pageable.Mode.OFFSET) {
            throw new UnsupportedOperationException("Pageable mode " + pageable.getMode() + " is not supported by hibernate operations");
        }
        int max = pageable.getSize();
        if (max > 0) {
            this.setMaxResults(q, max);
        }
        if ((offset = pageable.getOffset()) > 0L) {
            this.setOffset(q, (int)offset);
        }
    }

    protected final <T> void collectPagedResults(CriteriaBuilder criteriaBuilder, S session, PagedQuery<T> pagedQuery, ResultCollector<T> resultCollector) {
        Pageable pageable = pagedQuery.getPageable();
        Class entity = pagedQuery.getRootEntity();
        CriteriaQuery query = criteriaBuilder.createQuery(pagedQuery.getRootEntity());
        Root root = query.from(entity);
        this.bindCriteriaSort(query, root, criteriaBuilder, (Sort)pageable);
        P q = this.createQuery(session, query);
        this.bindPageable(q, pageable);
        this.bindQueryHints(q, pagedQuery, session);
        resultCollector.collect(q);
    }

    protected final <R> void collectCountOf(CriteriaBuilder criteriaBuilder, S session, Class<R> entity, @Nullable Pageable pageable, ResultCollector<Long> resultCollector) {
        CriteriaQuery countQuery = criteriaBuilder.createQuery(Long.class);
        countQuery.select((Selection)criteriaBuilder.count((Expression)countQuery.from(entity)));
        P countQ = this.createQuery(session, countQuery);
        if (pageable != null) {
            this.bindPageable(countQ, pageable);
        }
        resultCollector.collect(countQ);
    }

    private <T> void bindCriteriaSort(CriteriaQuery<T> criteriaQuery, Root<?> root, CriteriaBuilder builder, @NonNull Sort sort) {
        ArrayList<Order> orders = new ArrayList<Order>();
        for (Sort.Order order : sort.getOrderBy()) {
            Path path = root;
            for (String property : StringUtils.splitOmitEmptyStrings((CharSequence)order.getProperty(), (char)'.')) {
                path = path.get(property);
            }
            Path expression = order.isIgnoreCase() ? builder.lower(path.type().as(String.class)) : path;
            orders.add(order.isAscending() ? builder.asc((Expression)expression) : builder.desc((Expression)expression));
        }
        criteriaQuery.orderBy(orders);
    }

    private <E, R> BindableParametersPreparedQuery<E, R> getBindableParametersPreparedQuery(PreparedQuery<E, R> preparedQuery) {
        if (preparedQuery instanceof BindableParametersPreparedQuery) {
            BindableParametersPreparedQuery bindableParametersPreparedQuery = (BindableParametersPreparedQuery)preparedQuery;
            return bindableParametersPreparedQuery;
        }
        throw new IllegalStateException("Expected for prepared query to be of type: BindableParametersPreparedQuery");
    }

    protected abstract class ResultCollector<R> {
        protected ResultCollector() {
        }

        protected abstract void collectTuple(P var1, Function<Tuple, R> var2);

        protected abstract void collect(P var1);
    }
}

