/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.reactive.operations;

import io.micronaut.configuration.hibernate.jpa.JpaConfiguration;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.hibernate.operations.HibernateJpaOperations;
import io.micronaut.data.hibernate.reactive.operations.DefaultHibernateReactiveSynchronousRepositoryOperations;
import io.micronaut.data.hibernate.reactive.operations.HibernateReactorRepositoryOperations;
import io.micronaut.data.jpa.operations.JpaRepositoryOperations;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.transaction.SynchronousTransactionManager;
import io.micronaut.transaction.TransactionOperations;
import io.micronaut.transaction.async.AsyncTransactionOperations;
import io.micronaut.transaction.async.AsyncUsingReactiveTransactionOperations;
import io.micronaut.transaction.interceptor.CoroutineTxHelper;
import io.micronaut.transaction.reactive.ReactorReactiveTransactionOperations;
import jakarta.inject.Named;
import java.util.concurrent.ExecutorService;
import org.hibernate.SessionFactory;

@Internal
@Factory
final class HibernateRepositoryOperationsFactory {
    HibernateRepositoryOperationsFactory() {
    }

    @EachBean(value=SessionFactory.class)
    @Replaces(value=HibernateJpaOperations.class)
    JpaRepositoryOperations operations(SessionFactory sessionFactory, @Parameter @Nullable JpaConfiguration jpaConfiguration, @Named(value="io") @Nullable ExecutorService executorService, RuntimeEntityRegistry runtimeEntityRegistry, DataConversionService<?> dataConversionService, BeanProvider<SynchronousTransactionManager> transactionOperations, Qualifier<SynchronousTransactionManager> qualifier, ApplicationContext applicationContext, @Parameter String name) {
        if (jpaConfiguration == null || !jpaConfiguration.isReactive()) {
            return new HibernateJpaOperations(sessionFactory, (TransactionOperations)transactionOperations.find(qualifier).orElseThrow(), executorService, runtimeEntityRegistry, dataConversionService);
        }
        return new DefaultHibernateReactiveSynchronousRepositoryOperations(applicationContext, sessionFactory, name, runtimeEntityRegistry, dataConversionService);
    }

    @EachBean(value=SessionFactory.class)
    HibernateReactorRepositoryOperations reactiveRepositoryOperations(@Parameter JpaRepositoryOperations syncRepositoryOperations) {
        if (syncRepositoryOperations instanceof DefaultHibernateReactiveSynchronousRepositoryOperations) {
            return ((DefaultHibernateReactiveSynchronousRepositoryOperations)syncRepositoryOperations).reactive();
        }
        throw new IllegalStateException("Not Hibernate Reactive session factory!");
    }

    @EachBean(value=SessionFactory.class)
    <T> AsyncTransactionOperations<T> buildAsyncTransactionOperations(@Parameter ReactorReactiveTransactionOperations<T> operations, @Nullable CoroutineTxHelper coroutineTxHelper) {
        return new AsyncUsingReactiveTransactionOperations(operations, coroutineTxHelper);
    }
}

