/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.reactive.operations;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.reactive.common.spi.Implementor;
import org.hibernate.reactive.stage.Stage;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Internal
final class ReactiveHibernateHelper {
    private final Stage.SessionFactory sessionFactory;
    private final Scheduler contextScheduler;

    ReactiveHibernateHelper(Stage.SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.contextScheduler = Schedulers.fromExecutor((Executor)((Implementor)sessionFactory).getContext());
    }

    <T> Mono<T> find(Stage.Session session, Class<T> entityClass, Object id) {
        return this.monoFromCompletionStage(() -> session.find(entityClass, id));
    }

    <T> Flux<T> list(Stage.Query<T> query) {
        return this.monoFromCompletionStage(() -> query.getResultList()).flatMapMany(Flux::fromIterable);
    }

    <T> Mono<T> persist(Stage.Session session, T entity) {
        return this.monoFromCompletionStage(() -> session.persist(entity)).thenReturn(entity);
    }

    <T> Mono<T> merge(Stage.Session session, T entity) {
        return this.monoFromCompletionStage(() -> session.merge(entity));
    }

    <T> Mono<Void> remove(Stage.Session session, T entity) {
        return this.monoFromCompletionStage(() -> session.remove(entity));
    }

    <T> Flux<T> mergeAll(Stage.Session session, Iterable<T> entities) {
        List list = CollectionUtils.iterableToList(entities);
        return this.monoFromCompletionStage(() -> session.merge(list.toArray())).thenReturn((Object)list).flatMapMany(Flux::fromIterable);
    }

    <T> Flux<T> persistAll(Stage.Session session, Iterable<T> entities) {
        List list = CollectionUtils.iterableToList(entities);
        return this.monoFromCompletionStage(() -> session.persist(list.toArray())).thenReturn((Object)list).flatMapMany(Flux::fromIterable);
    }

    <T> Mono<Number> removeAll(Stage.Session session, Iterable<T> entities) {
        List list = CollectionUtils.iterableToList(entities);
        return this.monoFromCompletionStage(() -> session.remove(list.toArray())).thenReturn((Object)list.size());
    }

    Mono<Void> flush(Stage.Session session) {
        return this.monoFromCompletionStage(() -> ((Stage.Session)session).flush());
    }

    <T> Mono<T> singleResult(Stage.Query<T> query) {
        return this.monoFromCompletionStage(() -> query.getSingleResult());
    }

    Mono<Integer> executeUpdate(Stage.Query<Object> query) {
        return this.monoFromCompletionStage(() -> query.executeUpdate());
    }

    Mono<Stage.Session> openSession() {
        return this.monoFromCompletionStage(() -> ((Stage.SessionFactory)this.sessionFactory).openSession()).subscribeOn(this.contextScheduler);
    }

    Mono<Void> closeSession(Stage.Session session) {
        return this.monoFromCompletionStage(() -> ((Stage.Session)session).close());
    }

    <T> Mono<T> withSession(Function<Stage.Session, Mono<T>> work) {
        return Mono.usingWhen(this.openSession(), work, this::closeSession);
    }

    <T> Mono<T> withTransaction(Stage.Session session, Function<Stage.Transaction, Mono<T>> work) {
        return this.monoFromCompletionStage(() -> session.withTransaction(tx -> ((Mono)work.apply((Stage.Transaction)tx)).publishOn(this.contextScheduler).toFuture()));
    }

    <T> Mono<T> withSessionAndTransaction(BiFunction<Stage.Session, Stage.Transaction, Mono<T>> work) {
        return this.withSession(session -> this.withTransaction((Stage.Session)session, transaction -> ((Mono)work.apply((Stage.Session)session, (Stage.Transaction)transaction)).publishOn(this.contextScheduler)));
    }

    <T> Mono<T> monoFromCompletionStage(Supplier<CompletionStage<T>> supplier) {
        return Mono.fromCompletionStage(supplier);
    }
}

