/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.reactive.repository.jpa.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.hibernate.reactive.repository.jpa.intercept.AbstractSpecificationInterceptor;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.jpa.repository.criteria.Specification;
import io.micronaut.data.model.Sort;
import io.micronaut.data.operations.RepositoryOperations;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Internal
public class ReactiveFindAllSpecificationInterceptor
extends AbstractSpecificationInterceptor {
    protected ReactiveFindAllSpecificationInterceptor(@NonNull RepositoryOperations operations) {
        super(operations);
    }

    protected Publisher<?> interceptPublisher(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        CriteriaBuilder criteriaBuilder;
        CriteriaQuery query;
        Root root;
        Specification<Object> specification = this.getSpecification(context);
        Predicate predicate = specification.toPredicate(root = (query = (criteriaBuilder = this.operations.getCriteriaBuilder()).createQuery(this.getRequiredRootEntity(context))).from(this.getRequiredRootEntity(context)), query, criteriaBuilder);
        if (predicate != null) {
            query.where((Expression)predicate);
        }
        query.select((Selection)root);
        if (context.getParameterValues().length > 1) {
            this.addSort(context.getParameterValues()[1], (CriteriaQuery<Object>)query, (Root<Object>)root, criteriaBuilder);
        }
        return this.operations.withSession(session -> Mono.fromCompletionStage(() -> session.createQuery(query).getResultList())).flatMapMany(Flux::fromIterable);
    }

    private void addSort(Object sortObject, CriteriaQuery<Object> query, Root<Object> root, CriteriaBuilder criteriaBuilder) {
        Sort sort;
        if (sortObject instanceof Sort && (sort = (Sort)sortObject).isSorted()) {
            query.orderBy(this.getOrders(sort, root, criteriaBuilder));
        }
    }
}

