/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.reactive.repository.jpa.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.hibernate.reactive.operations.HibernateReactorRepositoryOperations;
import io.micronaut.data.jpa.repository.criteria.Specification;
import io.micronaut.data.model.Sort;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.operations.reactive.ReactiveCapableRepository;
import io.micronaut.data.operations.reactive.ReactiveRepositoryOperations;
import io.micronaut.data.runtime.intercept.reactive.AbstractPublisherInterceptor;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.List;

@Internal
public abstract class AbstractSpecificationInterceptor
extends AbstractPublisherInterceptor {
    protected final HibernateReactorRepositoryOperations operations;

    protected AbstractSpecificationInterceptor(RepositoryOperations operations) {
        super(operations);
        ReactiveRepositoryOperations reactive;
        if (operations instanceof ReactiveCapableRepository) {
            reactive = ((ReactiveCapableRepository)operations).reactive();
            if (!(reactive instanceof HibernateReactorRepositoryOperations)) {
                throw new IllegalStateException("Reactive repository operations must be na instance of HibernateReactorRepositoryOperations");
            }
        } else {
            throw new IllegalStateException("Repository operations must be na instance of ReactiveCapableRepository");
        }
        this.operations = (HibernateReactorRepositoryOperations)reactive;
    }

    protected Specification<Object> getSpecification(MethodInvocationContext<?, ?> context) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof Specification) {
            return (Specification)parameterValue;
        }
        throw new IllegalArgumentException("Argument must be an instance of: " + Specification.class);
    }

    protected final List<Order> getOrders(Sort sort, Root<?> root, CriteriaBuilder cb) {
        ArrayList<Order> orders = new ArrayList<Order>();
        for (Sort.Order order : sort.getOrderBy()) {
            Path propertyPath = root;
            for (String path : StringUtils.splitOmitEmptyStrings((CharSequence)order.getProperty(), (char)'.')) {
                propertyPath = propertyPath.get(path);
            }
            orders.add(order.isAscending() ? cb.asc(propertyPath) : cb.desc(propertyPath));
        }
        return orders;
    }
}

