/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.reactive.operations;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.data.connection.reactive.ReactorConnectionOperations;
import io.micronaut.data.hibernate.conf.RequiresReactiveHibernate;
import io.micronaut.data.hibernate.reactive.operations.DefaultHibernateReactiveRepositoryOperations;
import io.micronaut.data.jpa.operations.JpaRepositoryOperations;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.RuntimeEntityRegistry;
import io.micronaut.data.model.runtime.StoredQuery;
import io.micronaut.data.operations.HintsCapableRepository;
import io.micronaut.data.operations.async.AsyncCapableRepository;
import io.micronaut.data.operations.async.AsyncRepositoryOperations;
import io.micronaut.data.operations.reactive.BlockingExecutorReactorRepositoryOperations;
import io.micronaut.data.operations.reactive.ReactiveRepositoryOperations;
import io.micronaut.data.operations.reactive.ReactorReactiveRepositoryOperations;
import io.micronaut.data.runtime.convert.DataConversionService;
import io.micronaut.data.runtime.operations.AsyncFromReactiveAsyncRepositoryOperation;
import io.micronaut.data.runtime.query.PreparedQueryDecorator;
import io.micronaut.data.runtime.query.StoredQueryDecorator;
import io.micronaut.transaction.reactive.ReactorReactiveTransactionOperations;
import jakarta.annotation.PreDestroy;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.io.Closeable;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.hibernate.SessionFactory;
import org.hibernate.reactive.stage.Stage;
import reactor.core.publisher.Mono;

@RequiresReactiveHibernate
@EachBean(value=SessionFactory.class)
@Internal
final class DefaultHibernateReactiveSynchronousRepositoryOperations
implements BlockingExecutorReactorRepositoryOperations,
JpaRepositoryOperations,
AsyncCapableRepository,
HintsCapableRepository,
Closeable,
PreparedQueryDecorator,
StoredQueryDecorator {
    private final ApplicationContext applicationContext;
    private final DefaultHibernateReactiveRepositoryOperations reactiveRepositoryOperations;
    private AsyncRepositoryOperations asyncRepositoryOperations;
    private ExecutorService executorService;

    public DefaultHibernateReactiveSynchronousRepositoryOperations(ApplicationContext applicationContext, SessionFactory sessionFactory, RuntimeEntityRegistry runtimeEntityRegistry, DataConversionService dataConversionService, @Parameter ReactorConnectionOperations<Stage.Session> connectionOperations, @Parameter ReactorReactiveTransactionOperations<Stage.Session> transactionOperations) {
        this.applicationContext = applicationContext;
        this.reactiveRepositoryOperations = new DefaultHibernateReactiveRepositoryOperations(sessionFactory, runtimeEntityRegistry, dataConversionService, connectionOperations, transactionOperations);
    }

    public <T> T block(Function<ReactorReactiveRepositoryOperations, Mono<T>> supplier) {
        throw this.blockingNotSupported();
    }

    public <T> Optional<T> blockOptional(Function<ReactorReactiveRepositoryOperations, Mono<T>> supplier) {
        throw this.blockingNotSupported();
    }

    public EntityManager getCurrentEntityManager() {
        return (EntityManager)this.notSupported();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return (EntityManagerFactory)this.notSupported();
    }

    public <T> T load(Class<T> type, Object id) {
        return this.notSupported();
    }

    public <T> T merge(T entity) {
        return this.notSupported();
    }

    public void flush() {
        this.notSupported();
    }

    public AsyncRepositoryOperations async() {
        if (this.asyncRepositoryOperations == null) {
            if (this.executorService == null) {
                this.executorService = Executors.newCachedThreadPool();
            }
            this.asyncRepositoryOperations = new AsyncFromReactiveAsyncRepositoryOperation((ReactiveRepositoryOperations)this.reactiveRepositoryOperations, (Executor)this.executorService);
        }
        return this.asyncRepositoryOperations;
    }

    public DefaultHibernateReactiveRepositoryOperations reactive() {
        return this.reactiveRepositoryOperations;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Map<String, Object> getQueryHints(StoredQuery<?, ?> storedQuery) {
        return this.reactive().getQueryHints(storedQuery);
    }

    @Override
    @PreDestroy
    public void close() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    private IllegalStateException blockingNotSupported() {
        return new IllegalStateException("Blocking isn't supported for Hibernate Reactive");
    }

    private <T> T notSupported() {
        throw new IllegalStateException("Method isn't supported for Hibernate Reactive");
    }

    public <E, R> PreparedQuery<E, R> decorate(PreparedQuery<E, R> preparedQuery) {
        return this.reactiveRepositoryOperations.decorate(preparedQuery);
    }

    public <E, R> StoredQuery<E, R> decorate(StoredQuery<E, R> storedQuery) {
        return this.reactiveRepositoryOperations.decorate(storedQuery);
    }

    public ConversionService getConversionService() {
        return this.reactiveRepositoryOperations.getConversionService();
    }
}

