/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.reactive.operations;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.connection.ConnectionDefinition;
import io.micronaut.data.connection.support.AbstractReactorConnectionOperations;
import io.micronaut.data.hibernate.conf.RequiresReactiveHibernate;
import io.micronaut.data.hibernate.reactive.operations.ReactiveHibernateHelper;
import org.hibernate.SessionFactory;
import org.hibernate.reactive.stage.Stage;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequiresReactiveHibernate
@EachBean(value=SessionFactory.class)
@Internal
final class DefaultHibernateReactorConnectionOperations
extends AbstractReactorConnectionOperations<Stage.Session> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHibernateReactorConnectionOperations.class);
    private final ReactiveHibernateHelper helper;
    private final String serverName;

    DefaultHibernateReactorConnectionOperations(@Parameter String serverName, SessionFactory sessionFactory) {
        this.helper = new ReactiveHibernateHelper((Stage.SessionFactory)sessionFactory.unwrap(Stage.SessionFactory.class));
        this.serverName = serverName;
    }

    protected Publisher<Stage.Session> openConnection(ConnectionDefinition definition) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Opening Connection for Hibernate Reactive configuration: {} and definition: {}", (Object)this.serverName, (Object)definition);
        }
        return this.helper.openSession();
    }

    protected Publisher<Void> closeConnection(Stage.Session session, ConnectionDefinition definition) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closing Connection for Hibernate Reactive configuration: {} and definition: {}", (Object)this.serverName, (Object)definition);
        }
        return this.helper.closeSession(session);
    }
}

