/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.reactive.operations;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.core.annotation.Internal;
import io.micronaut.data.connection.ConnectionStatus;
import io.micronaut.data.connection.reactive.ReactorConnectionOperations;
import io.micronaut.data.hibernate.conf.RequiresReactiveHibernate;
import io.micronaut.data.hibernate.reactive.operations.ReactiveHibernateHelper;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.exceptions.TransactionUsageException;
import io.micronaut.transaction.reactive.ReactiveTransactionOperations;
import io.micronaut.transaction.reactive.ReactiveTransactionStatus;
import io.micronaut.transaction.support.AbstractReactorTransactionOperations;
import java.util.function.Function;
import org.hibernate.SessionFactory;
import org.hibernate.reactive.stage.Stage;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RequiresReactiveHibernate
@EachBean(value=SessionFactory.class)
@Internal
final class DefaultHibernateReactorTransactionOperations
extends AbstractReactorTransactionOperations<Stage.Session> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHibernateReactorTransactionOperations.class);
    private final ReactiveHibernateHelper helper;
    private final String serverName;

    DefaultHibernateReactorTransactionOperations(@Parameter String serverName, SessionFactory sessionFactory, @Parameter ReactorConnectionOperations<Stage.Session> connectionOperations) {
        super(connectionOperations);
        this.helper = new ReactiveHibernateHelper((Stage.SessionFactory)sessionFactory.unwrap(Stage.SessionFactory.class));
        this.serverName = serverName;
    }

    protected <R> Flux<R> executeTransactionFlux(AbstractReactorTransactionOperations.DefaultReactiveTransactionStatus<Stage.Session> txStatus, ReactiveTransactionOperations.TransactionalCallback<Stage.Session, R> handler) {
        Flux<R> error = this.validateTransaction(txStatus);
        if (error != null) {
            return error;
        }
        return this.helper.withTransactionFlux((Stage.Session)txStatus.getConnection(), transaction -> {
            ReactiveTransactionStatus<Stage.Session> reactiveTransactionStatus = this.createTxStatus(txStatus, (Stage.Transaction)transaction);
            return this.executeCallbackFlux(reactiveTransactionStatus, handler);
        });
    }

    protected <R> Mono<R> executeTransactionMono(AbstractReactorTransactionOperations.DefaultReactiveTransactionStatus<Stage.Session> txStatus, Function<ReactiveTransactionStatus<Stage.Session>, Mono<R>> handler) {
        Flux<R> error = this.validateTransaction(txStatus);
        if (error != null) {
            return error.next();
        }
        return this.helper.withTransactionMono((Stage.Session)txStatus.getConnection(), transaction -> {
            ReactiveTransactionStatus<Stage.Session> reactiveTransactionStatus = this.createTxStatus(txStatus, (Stage.Transaction)transaction);
            return this.executeCallbackMono(reactiveTransactionStatus, handler);
        });
    }

    private ReactiveTransactionStatus<Stage.Session> createTxStatus(final AbstractReactorTransactionOperations.DefaultReactiveTransactionStatus<Stage.Session> txStatus, final Stage.Transaction transaction) {
        return new ReactiveTransactionStatus<Stage.Session>(){

            public ConnectionStatus<Stage.Session> getConnectionStatus() {
                return txStatus.getConnectionStatus();
            }

            public boolean isNewTransaction() {
                return txStatus.isNewTransaction();
            }

            public void setRollbackOnly() {
                transaction.markForRollback();
            }

            public boolean isRollbackOnly() {
                return transaction.isMarkedForRollback();
            }

            public boolean isCompleted() {
                return txStatus.isCompleted();
            }

            public TransactionDefinition getTransactionDefinition() {
                return txStatus.getTransactionDefinition();
            }
        };
    }

    private <R> Flux<R> validateTransaction(AbstractReactorTransactionOperations.DefaultReactiveTransactionStatus<Stage.Session> txStatus) {
        TransactionDefinition definition;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Transaction execution for Hibernate Reactive connection: {} and configuration {}.", txStatus.getConnection(), (Object)this.serverName);
        }
        if ((definition = txStatus.getTransactionDefinition()).getIsolationLevel().isPresent()) {
            return Flux.error((Throwable)new TransactionUsageException("Isolation level not supported"));
        }
        if (definition.getTimeout().isPresent()) {
            return Flux.error((Throwable)new TransactionUsageException("Timeout not supported"));
        }
        return null;
    }

    protected Publisher<Void> beginTransaction(ConnectionStatus<Stage.Session> connectionStatus, TransactionDefinition transactionDefinition) {
        throw this.notSupported();
    }

    protected Publisher<Void> commitTransaction(ConnectionStatus<Stage.Session> connectionStatus, TransactionDefinition transactionDefinition) {
        throw this.notSupported();
    }

    protected Publisher<Void> rollbackTransaction(ConnectionStatus<Stage.Session> connectionStatus, TransactionDefinition transactionDefinition) {
        throw this.notSupported();
    }

    private IllegalStateException notSupported() {
        return new IllegalStateException("Not supported");
    }
}

