/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.hibernate.reactive.repository.jpa.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.data.hibernate.reactive.repository.jpa.intercept.AbstractSpecificationInterceptor;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.jpa.repository.criteria.Specification;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Sort;
import io.micronaut.data.operations.RepositoryOperations;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.List;
import org.hibernate.reactive.stage.Stage;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@Internal
public class ReactiveFindPageSpecificationInterceptor
extends AbstractSpecificationInterceptor {
    protected ReactiveFindPageSpecificationInterceptor(@NonNull RepositoryOperations operations) {
        super(operations);
    }

    protected final Pageable getPageable(MethodInvocationContext<?, ?> context) {
        Object parameterValue = context.getParameterValues()[1];
        if (parameterValue instanceof Pageable) {
            Pageable pageable = (Pageable)parameterValue;
            return pageable;
        }
        return Pageable.UNPAGED;
    }

    protected Publisher<?> interceptPublisher(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        Predicate predicate;
        if (context.getParameterValues().length != 2) {
            throw new IllegalStateException("Expected exactly 2 arguments to method");
        }
        Specification<Object> specification = this.getSpecification(context);
        CriteriaBuilder criteriaBuilder = this.operations.getCriteriaBuilder();
        Class rootEntity = this.getRequiredRootEntity(context);
        CriteriaQuery query = criteriaBuilder.createQuery(rootEntity);
        Root root = query.from(rootEntity);
        Predicate predicate2 = predicate = specification != null ? specification.toPredicate(root, query, criteriaBuilder) : null;
        if (predicate != null) {
            query.where((Expression)predicate);
        }
        query.select((Selection)root);
        Pageable pageable = this.getPageable(context);
        Sort sort = pageable.getSort();
        if (sort.isSorted()) {
            query.orderBy(this.getOrders(sort, root, criteriaBuilder));
        }
        return this.operations.withSession(session -> {
            if (pageable.isUnpaged()) {
                return Mono.fromCompletionStage(() -> session.createQuery(query).getResultList()).map(resultList -> Page.of((List)resultList, (Pageable)pageable, (Long)Long.valueOf(resultList.size())));
            }
            return Mono.fromCompletionStage(() -> {
                Stage.SelectionQuery q = session.createQuery(query);
                q.setFirstResult((int)pageable.getOffset());
                q.setMaxResults(pageable.getSize());
                return q.getResultList();
            }).flatMap(results -> {
                Predicate countPredicate;
                if (!pageable.requestTotal()) {
                    return Mono.just((Object)Page.of((List)results, (Pageable)pageable, null));
                }
                CriteriaQuery countQuery = criteriaBuilder.createQuery(Long.class);
                Root countRoot = countQuery.from(rootEntity);
                Predicate predicate = countPredicate = specification != null ? specification.toPredicate(countRoot, countQuery, criteriaBuilder) : null;
                if (countPredicate != null) {
                    countQuery.where((Expression)countPredicate);
                }
                if (countQuery.isDistinct()) {
                    countQuery.select((Selection)criteriaBuilder.countDistinct((Expression)countRoot));
                } else {
                    countQuery.select((Selection)criteriaBuilder.count((Expression)countRoot));
                }
                return Mono.fromCompletionStage(() -> session.createQuery(countQuery).getSingleResult()).map(total -> Page.of((List)results, (Pageable)pageable, (Long)total));
            });
        });
    }
}

