/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jdbc.operations;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.BeanContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.beans.BeanWrapper;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.annotation.AutoPopulated;
import io.micronaut.data.annotation.DateCreated;
import io.micronaut.data.annotation.DateUpdated;
import io.micronaut.data.annotation.Query;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.annotation.Repository;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.Sort;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.QueryParameter;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilder;
import io.micronaut.data.model.runtime.EntityOperation;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.RuntimeAssociation;
import io.micronaut.data.model.runtime.RuntimePersistentEntity;
import io.micronaut.data.model.runtime.RuntimePersistentProperty;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.repository.GenericRepository;
import io.micronaut.data.runtime.config.DataSettings;
import io.micronaut.data.runtime.date.DateTimeProvider;
import io.micronaut.data.runtime.mapper.QueryStatement;
import io.micronaut.data.runtime.mapper.ResultReader;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public abstract class AbstractSqlRepositoryOperations<RS, PS>
implements RepositoryOperations {
    protected static final Logger QUERY_LOG = DataSettings.QUERY_LOG;
    protected static final SqlQueryBuilder DEFAULT_SQL_BUILDER = new SqlQueryBuilder();
    protected static final Pattern IN_EXPRESSION_PATTERN = Pattern.compile("\\s\\?\\$IN\\((\\d+)\\)");
    protected static final String NOT_TRUE_EXPRESSION = "1 = 2";
    private static final Object IGNORED_PARAMETER = new Object();
    protected final ResultReader<RS, String> columnNameResultSetReader;
    protected final ResultReader<RS, Integer> columnIndexResultSetReader;
    protected final QueryStatement<PS, Integer> preparedStatementWriter;
    protected final Map<Class, SqlQueryBuilder> queryBuilders = new HashMap<Class, SqlQueryBuilder>(10);
    protected final MediaTypeCodec jsonCodec;
    protected final DateTimeProvider dateTimeProvider;
    private final Map<Class, StoredInsert> storedInserts = new ConcurrentHashMap<Class, StoredInsert>(10);
    private final Map<QueryKey, StoredInsert> entityInserts = new ConcurrentHashMap<QueryKey, StoredInsert>(10);
    private final Map<QueryKey, StoredInsert> entityUpdates = new ConcurrentHashMap<QueryKey, StoredInsert>(10);
    private final Map<Association, String> associationInserts = new ConcurrentHashMap<Association, String>(10);
    private final Map<Class, RuntimePersistentEntity> entities = new ConcurrentHashMap<Class, RuntimePersistentEntity>(10);
    private final Map<Class, RuntimePersistentProperty> idReaders = new ConcurrentHashMap<Class, RuntimePersistentProperty>(10);

    protected AbstractSqlRepositoryOperations(String dataSourceName, ResultReader<RS, String> columnNameResultSetReader, ResultReader<RS, Integer> columnIndexResultSetReader, QueryStatement<PS, Integer> preparedStatementWriter, List<MediaTypeCodec> codecs, @NonNull DateTimeProvider dateTimeProvider, BeanContext beanContext) {
        this.columnNameResultSetReader = columnNameResultSetReader;
        this.columnIndexResultSetReader = columnIndexResultSetReader;
        this.preparedStatementWriter = preparedStatementWriter;
        this.jsonCodec = this.resolveJsonCodec(codecs);
        this.dateTimeProvider = dateTimeProvider;
        Collection beanDefinitions = beanContext.getBeanDefinitions(GenericRepository.class, Qualifiers.byStereotype(Repository.class));
        for (BeanDefinition beanDefinition : beanDefinitions) {
            String targetDs = beanDefinition.stringValue(Repository.class).orElse("default");
            if (!targetDs.equalsIgnoreCase(dataSourceName)) continue;
            Class beanType = beanDefinition.getBeanType();
            SqlQueryBuilder queryBuilder = new SqlQueryBuilder(beanDefinition.getAnnotationMetadata());
            this.queryBuilders.put(beanType, queryBuilder);
        }
    }

    private MediaTypeCodec resolveJsonCodec(List<MediaTypeCodec> codecs) {
        return CollectionUtils.isNotEmpty(codecs) ? (MediaTypeCodec)codecs.stream().filter(c -> c.getMediaTypes().contains(MediaType.APPLICATION_JSON_TYPE)).findFirst().orElse(null) : null;
    }

    @NonNull
    public final <T> RuntimePersistentEntity<T> getEntity(@NonNull Class<T> type) {
        ArgumentUtils.requireNonNull((String)"type", type);
        RuntimePersistentEntity entity = this.entities.get(type);
        if (entity == null) {
            entity = new RuntimePersistentEntity<T>(type){

                protected RuntimePersistentEntity<T> getEntity(Class<T> type) {
                    return AbstractSqlRepositoryOperations.this.getEntity(type);
                }
            };
            this.entities.put(type, entity);
        }
        return entity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected <T, R> PS prepareStatement(StatementSupplier<PS> statementFunction, @NonNull PreparedQuery<T, R> preparedQuery, boolean isUpdate, boolean isSingleResult) {
        PS ps;
        Pageable pageable;
        Object[] queryParameters = preparedQuery.getParameterArray();
        int[] parameterBinding = preparedQuery.getIndexedParameterBinding();
        DataType[] parameterTypes = preparedQuery.getIndexedParameterTypes();
        String query = preparedQuery.getQuery();
        SqlQueryBuilder queryBuilder = this.queryBuilders.getOrDefault(preparedQuery.getRepositoryType(), DEFAULT_SQL_BUILDER);
        Dialect dialect = queryBuilder.getDialect();
        boolean hasIn = preparedQuery.hasInExpression();
        if (hasIn) {
            Matcher matcher = IN_EXPRESSION_PATTERN.matcher(query);
            while (matcher.find()) {
                int inIndex = Integer.parseInt(matcher.group(1));
                int queryParameterIndex = parameterBinding[inIndex - 1];
                Object value = queryParameters[queryParameterIndex];
                if (value == null) {
                    query = matcher.replaceFirst(NOT_TRUE_EXPRESSION);
                    queryParameters[queryParameterIndex] = IGNORED_PARAMETER;
                } else {
                    int size = this.sizeOf(value);
                    if (size == 0) {
                        queryParameters[queryParameterIndex] = IGNORED_PARAMETER;
                        query = matcher.replaceFirst(NOT_TRUE_EXPRESSION);
                    } else if (queryBuilder.positionalParameterFormat().equals("?")) {
                        String replacement = " IN(" + String.join((CharSequence)",", Collections.nCopies(size, "?")) + ")";
                        query = matcher.replaceFirst(replacement);
                    } else {
                        String[] placeholders = new String[size];
                        for (int i = 0; i < placeholders.length; ++i) {
                            String name = queryBuilder.formatParameter(queryParameterIndex + i + 1).getName();
                            placeholders[i] = Matcher.quoteReplacement(name);
                        }
                        String replacement = " IN(" + String.join((CharSequence)",", Arrays.asList(placeholders)) + ")";
                        query = matcher.replaceFirst(replacement);
                    }
                }
                matcher = IN_EXPRESSION_PATTERN.matcher(query);
            }
        }
        if (!isUpdate && (pageable = preparedQuery.getPageable()) != Pageable.UNPAGED) {
            Class rootEntity = preparedQuery.getRootEntity();
            Sort sort = pageable.getSort();
            if (sort.isSorted()) {
                query = query + queryBuilder.buildOrderBy(this.getEntity(rootEntity), sort).getQuery();
            } else if (this.isSqlServerWithoutOrderBy(query, dialect)) {
                RuntimePersistentEntity<T> persistentEntity = this.getEntity(rootEntity);
                sort = this.sortById(persistentEntity);
                query = query + queryBuilder.buildOrderBy(persistentEntity, sort).getQuery();
            }
            if (isSingleResult && pageable.getOffset() > 0L) {
                pageable = Pageable.from((int)pageable.getNumber(), (int)1);
            }
            query = query + queryBuilder.buildPagination(pageable).getQuery();
        }
        if (QUERY_LOG.isDebugEnabled()) {
            QUERY_LOG.debug("Executing Query: {}", (Object)query);
        }
        try {
            ps = statementFunction.create(query);
        }
        catch (Exception e) {
            throw new DataAccessException("Unable to prepare query [" + query + "]: " + e.getMessage(), (Throwable)e);
        }
        int index = this.shiftIndex(0);
        for (int i = 0; i < parameterBinding.length; ++i) {
            Object value;
            int parameterIndex = parameterBinding[i];
            DataType dataType = parameterTypes[i];
            if (parameterIndex > -1) {
                value = queryParameters[parameterIndex];
            } else {
                String[] indexedParameterPaths = preparedQuery.getIndexedParameterPaths();
                String propertyPath = indexedParameterPaths[i];
                if (propertyPath == null) throw new IllegalStateException("Invalid query [" + query + "]. Unable to establish parameter value for parameter at position: " + (i + 1));
                String string = preparedQuery.getLastUpdatedProperty();
                if (string != null && string.equals(propertyPath)) {
                    Class lastUpdatedType = preparedQuery.getLastUpdatedType();
                    if (lastUpdatedType == null) {
                        throw new IllegalStateException("Could not establish last updated time for entity: " + preparedQuery.getRootEntity());
                    }
                    Object timestamp = ConversionService.SHARED.convert(this.dateTimeProvider.getNow(), lastUpdatedType).orElse(null);
                    if (timestamp == null) {
                        throw new IllegalStateException("Unsupported date type: " + lastUpdatedType);
                    }
                    value = timestamp;
                } else {
                    int j = propertyPath.indexOf(46);
                    if (j <= -1) throw new IllegalStateException("Invalid query [" + query + "]. Unable to establish parameter value for parameter at position: " + (i + 1));
                    String subProp = propertyPath.substring(j + 1);
                    value = queryParameters[Integer.valueOf(propertyPath.substring(0, j))];
                    value = BeanWrapper.getWrapper((Object)value).getRequiredProperty(subProp, Argument.OBJECT_ARGUMENT);
                }
            }
            if (QUERY_LOG.isTraceEnabled()) {
                QUERY_LOG.trace("Binding parameter at position {} to value {}", (Object)index, value);
            }
            if (value == null) {
                this.setStatementParameter(ps, index++, dataType, null, dialect);
                continue;
            }
            if (value == IGNORED_PARAMETER) continue;
            if (value instanceof Iterable) {
                Iterable iter = (Iterable)value;
                for (Object t : iter) {
                    this.setStatementParameter(ps, index++, dataType, t, dialect);
                }
                continue;
            }
            if (value.getClass().isArray()) {
                if (value instanceof byte[]) {
                    this.setStatementParameter(ps, index++, dataType, value, dialect);
                    continue;
                }
                int len = Array.getLength(value);
                for (int j = 0; j < len; ++j) {
                    Object object = Array.get(value, j);
                    this.setStatementParameter(ps, index++, dataType, object, dialect);
                }
                continue;
            }
            this.setStatementParameter(ps, index++, dataType, value, dialect);
        }
        return ps;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final <T> void setInsertParameters(@NonNull StoredInsert<T> insert, @NonNull T entity, @NonNull PS stmt) {
        Object now = null;
        RuntimePersistentEntity<T> persistentEntity = insert.getPersistentEntity();
        String[] parameterBinding = insert.getParameterBinding();
        Dialect dialect = ((StoredInsert)insert).dialect;
        for (int i = 0; i < parameterBinding.length; ++i) {
            DataType type;
            Object value;
            int index = this.shiftIndex(i);
            String path = parameterBinding[i];
            RuntimePersistentProperty prop = persistentEntity.getPropertyByName(path);
            if (prop == null) {
                Association assoc;
                RuntimePersistentProperty embeddedProp;
                int j = path.indexOf(46);
                if (j < 0 || (embeddedProp = (RuntimePersistentProperty)persistentEntity.getPropertyByPath(path).orElse(null)) == null || !((prop = persistentEntity.getPropertyByName(path.substring(0, j))) instanceof Association) || (assoc = (Association)prop).getKind() != Relation.Kind.EMBEDDED) continue;
                value = prop.getProperty().get(entity);
                RuntimePersistentEntity embeddedEntity = this.entities.get(embeddedProp.getProperty().getType());
                if (embeddedEntity != null) {
                    Object bean = embeddedProp.getProperty().get(value);
                    RuntimePersistentProperty embeddedIdentity = embeddedEntity.getIdentity();
                    type = embeddedIdentity.getDataType();
                    value = embeddedIdentity.getProperty().get(bean);
                } else {
                    type = embeddedProp.getDataType();
                    value = value != null ? embeddedProp.getProperty().get(value) : null;
                }
            } else {
                type = prop.getDataType();
                BeanProperty beanProperty = prop.getProperty();
                value = beanProperty.get(entity);
                if (prop instanceof Association) {
                    Association association = (Association)prop;
                    if (association.isForeignKey()) continue;
                    RuntimePersistentEntity associatedEntity = (RuntimePersistentEntity)association.getAssociatedEntity();
                    RuntimePersistentProperty identity = associatedEntity.getIdentity();
                    if (identity == null) {
                        throw new IllegalArgumentException("Associated entity has not ID: " + associatedEntity.getName());
                    }
                    type = identity.getDataType();
                    BeanProperty identityProperty = identity.getProperty();
                    value = value != null ? identityProperty.get(value) : null;
                } else if (!prop.isGenerated()) {
                    if (beanProperty.hasStereotype(AutoPopulated.NAME)) {
                        if (beanProperty.hasAnnotation(DateCreated.NAME) || beanProperty.hasAnnotation(DateUpdated.NAME)) {
                            value = now = now != null ? now : this.dateTimeProvider.getNow();
                            beanProperty.convertAndSet(entity, value);
                        } else {
                            if (!UUID.class.isAssignableFrom(beanProperty.getType())) throw new DataAccessException("Unsupported auto-populated annotation type: " + beanProperty.getAnnotationTypeByStereotype(AutoPopulated.class).orElse(null));
                            value = UUID.randomUUID();
                            beanProperty.set(entity, value);
                        }
                    } else {
                        if (DataSettings.QUERY_LOG.isTraceEnabled()) {
                            DataSettings.QUERY_LOG.trace("Binding value {} to parameter at position: {}", value, (Object)index);
                        }
                        if (type == DataType.JSON && this.jsonCodec != null && value != null && !prop.getType().equals(String.class)) {
                            value = new String(this.jsonCodec.encode(value), StandardCharsets.UTF_8);
                        }
                        if (value != null && dialect.requiresStringUUID(type)) {
                            this.preparedStatementWriter.setString(stmt, (Object)index, value.toString());
                        } else {
                            this.preparedStatementWriter.setDynamic(stmt, (Object)index, type, value);
                        }
                    }
                }
            }
            if (DataSettings.QUERY_LOG.isTraceEnabled()) {
                DataSettings.QUERY_LOG.trace("Binding value {} to parameter at position: {}", value, (Object)index);
            }
            this.setStatementParameter(stmt, index, type, value, dialect);
        }
    }

    protected int shiftIndex(int i) {
        return i + 1;
    }

    @NonNull
    protected final <T> StoredInsert<T> resolveInsert(@NonNull EntityOperation<T> operation) {
        return this.storedInserts.computeIfAbsent(operation.getRootEntity(), aClass -> {
            AnnotationMetadata annotationMetadata = operation.getAnnotationMetadata();
            String insertStatement = annotationMetadata.stringValue(Query.class).orElse(null);
            if (insertStatement == null) {
                throw new IllegalStateException("No insert statement present in repository. Ensure it extends GenericRepository and is annotated with @JdbcRepository");
            }
            RuntimePersistentEntity persistentEntity = this.getEntity(operation.getRootEntity());
            String[] parameterBinding = annotationMetadata.stringValues(DataMethod.class, "parameterBindingPaths");
            Dialect dialect = annotationMetadata.enumValue(Repository.class, "dialect", Dialect.class).orElse(Dialect.ANSI);
            boolean supportsBatch = dialect != Dialect.SQL_SERVER;
            return new StoredInsert(insertStatement, persistentEntity, parameterBinding, supportsBatch, dialect);
        });
    }

    @NonNull
    protected final RuntimePersistentProperty<Object> getIdReader(@NonNull Object o) {
        Class<?> type = o.getClass();
        RuntimePersistentProperty beanProperty = this.idReaders.get(type);
        if (beanProperty == null) {
            RuntimePersistentEntity<?> entity = this.getEntity(type);
            RuntimePersistentProperty identity = entity.getIdentity();
            if (identity == null) {
                throw new DataAccessException("Entity has no ID: " + entity.getName());
            }
            beanProperty = identity;
            this.idReaders.put(type, beanProperty);
        }
        return beanProperty;
    }

    @NonNull
    protected final <T> Sort sortById(RuntimePersistentEntity<T> persistentEntity) {
        RuntimePersistentProperty identity = persistentEntity.getIdentity();
        if (identity == null) {
            throw new DataAccessException("Pagination requires an entity ID on SQL Server");
        }
        Sort sort = Sort.unsorted().order(Sort.Order.asc((String)identity.getName()));
        return sort;
    }

    protected final boolean isSqlServerWithoutOrderBy(String query, Dialect dialect) {
        return dialect == Dialect.SQL_SERVER && !query.contains(" ORDER BY ");
    }

    protected final int sizeOf(Object value) {
        if (value instanceof Collection) {
            return ((Collection)value).size();
        }
        if (value instanceof Iterable) {
            int i = 0;
            for (Object ignored : (Iterable)value) {
                ++i;
            }
            return i;
        }
        if (value.getClass().isArray()) {
            return Array.getLength(value);
        }
        return 1;
    }

    protected final void setStatementParameter(PS preparedStatement, int index, DataType dataType, Object value, Dialect dialect) {
        switch (dataType) {
            case JSON: {
                if (value == null || this.jsonCodec == null || value.getClass().equals(String.class)) break;
                System.out.print(value);
                value = new String(this.jsonCodec.encode(value), StandardCharsets.UTF_8);
                break;
            }
            case ENTITY: {
                if (value == null) break;
                RuntimePersistentProperty<Object> idReader = this.getIdReader(value);
                Object id = idReader.getProperty().get(value);
                if (id == null) {
                    throw new DataAccessException("Supplied entity is a transient instance: " + value);
                }
                value = id;
                dataType = idReader.getDataType();
                break;
            }
        }
        this.preparedStatementWriter.setDynamic(preparedStatement, (Object)index, dialect.getDataType(dataType), value);
    }

    @NonNull
    protected <T> StoredInsert<T> resolveEntityInsert(AnnotationMetadata annotationMetadata, Class<?> repositoryType, @NonNull Class<?> rootEntity, @NonNull RuntimePersistentEntity<?> persistentEntity) {
        return this.entityInserts.computeIfAbsent(new QueryKey(repositoryType, rootEntity), queryKey -> {
            Dialect dialect;
            SqlQueryBuilder queryBuilder = this.queryBuilders.getOrDefault(repositoryType, DEFAULT_SQL_BUILDER);
            QueryResult queryResult = queryBuilder.buildInsert(annotationMetadata, (PersistentEntity)persistentEntity);
            String sql = queryResult.getQuery();
            Map parameters = queryResult.getParameters();
            return new StoredInsert(sql, persistentEntity, parameters.values().toArray(new String[0]), (dialect = queryBuilder.getDialect()) != Dialect.SQL_SERVER, dialect);
        });
    }

    @NonNull
    protected <T> StoredInsert<T> resolveEntityUpdate(AnnotationMetadata annotationMetadata, Class<?> repositoryType, @NonNull Class<?> rootEntity, @NonNull RuntimePersistentEntity<?> persistentEntity) {
        QueryKey key = new QueryKey(repositoryType, rootEntity);
        return this.entityUpdates.computeIfAbsent(key, queryKey -> {
            SqlQueryBuilder queryBuilder = this.queryBuilders.getOrDefault(repositoryType, DEFAULT_SQL_BUILDER);
            RuntimePersistentProperty identity = persistentEntity.getIdentity();
            String idName = identity != null ? identity.getName() : "id";
            QueryModel queryModel = QueryModel.from((PersistentEntity)persistentEntity).idEq(new QueryParameter(idName));
            List updateProperties = persistentEntity.getPersistentProperties().stream().filter(p -> (!(p instanceof Association) || !((Association)p).isForeignKey()) && p.getAnnotationMetadata().booleanValue(AutoPopulated.class, "updateable").orElse(true) != false).map(PersistentProperty::getName).collect(Collectors.toList());
            QueryResult queryResult = queryBuilder.buildUpdate(annotationMetadata, queryModel, updateProperties);
            String sql = queryResult.getQuery();
            Map parameters = queryResult.getParameters();
            Dialect dialect = queryBuilder.getDialect();
            return new StoredInsert(sql, persistentEntity, parameters.values().toArray(new String[0]), dialect != Dialect.SQL_SERVER, dialect);
        });
    }

    protected <T> String resolveAssociationInsert(Class repositoryType, RuntimePersistentEntity<T> persistentEntity, RuntimeAssociation<T> association) {
        return this.associationInserts.computeIfAbsent((Association)association, association1 -> {
            SqlQueryBuilder queryBuilder = this.queryBuilders.getOrDefault(repositoryType, DEFAULT_SQL_BUILDER);
            return queryBuilder.buildJoinTableInsert((PersistentEntity)persistentEntity, association1);
        });
    }

    protected final class StoredInsert<T> {
        private final String[] parameterBinding;
        private final RuntimePersistentProperty identity;
        private final boolean generateId;
        private final String sql;
        private final boolean supportsBatch;
        private final RuntimePersistentEntity<T> persistentEntity;
        private final Dialect dialect;

        StoredInsert(String sql, RuntimePersistentEntity<T> persistentEntity, String[] parameterBinding, boolean supportsBatch, Dialect dialect) {
            this.sql = sql;
            this.persistentEntity = persistentEntity;
            this.parameterBinding = parameterBinding;
            this.identity = persistentEntity.getIdentity();
            this.generateId = this.identity != null && this.identity.isGenerated();
            this.supportsBatch = supportsBatch;
            this.dialect = dialect;
        }

        @NonNull
        public Dialect getDialect() {
            return this.dialect;
        }

        public RuntimePersistentEntity<T> getPersistentEntity() {
            return this.persistentEntity;
        }

        public boolean doesSupportBatch() {
            return this.supportsBatch;
        }

        @NonNull
        public String getSql() {
            return this.sql;
        }

        @NonNull
        public String[] getParameterBinding() {
            return this.parameterBinding;
        }

        @Nullable
        public BeanProperty<T, Object> getIdentityProperty() {
            if (this.identity != null) {
                return this.identity.getProperty();
            }
            return null;
        }

        public RuntimePersistentProperty getIdentity() {
            return this.identity;
        }

        public boolean isGenerateId() {
            return this.generateId;
        }
    }

    private class QueryKey {
        final Class repositoryType;
        final Class entityType;

        QueryKey(Class repositoryType, Class entityType) {
            this.repositoryType = repositoryType;
            this.entityType = entityType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryKey queryKey = (QueryKey)o;
            return this.repositoryType.equals(queryKey.repositoryType) && this.entityType.equals(queryKey.entityType);
        }

        public int hashCode() {
            return Objects.hash(this.repositoryType, this.entityType);
        }
    }

    @FunctionalInterface
    protected static interface StatementSupplier<PS> {
        public PS create(String var1) throws Exception;
    }
}

