/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jdbc.operations;

import io.micronaut.core.annotation.Internal;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.jdbc.operations.JdbcSchemaHandler;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.runtime.config.DataSettings;
import jakarta.inject.Singleton;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

@Singleton
@Internal
final class DefaultJdbcSchemaHandler
implements JdbcSchemaHandler {
    DefaultJdbcSchemaHandler() {
    }

    @Override
    public void createSchema(Connection connection, Dialect dialect, String name) {
        try {
            if (dialect == Dialect.ORACLE) {
                DefaultJdbcSchemaHandler.executeQuery(connection, "CREATE DATABASE " + name + ";");
            } else {
                DefaultJdbcSchemaHandler.executeQuery(connection, "CREATE SCHEMA " + name + ";");
            }
        }
        catch (SQLException e) {
            throw new DataAccessException("Failed to create the schema: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void useSchema(Connection connection, Dialect dialect, String name) {
        try {
            switch (dialect) {
                case ORACLE: {
                    DefaultJdbcSchemaHandler.executeQuery(connection, "ALTER SESSION SET CURRENT_SCHEMA=" + name);
                    break;
                }
                case SQL_SERVER: 
                case MYSQL: {
                    DefaultJdbcSchemaHandler.executeQuery(connection, "USE " + name + ";");
                    break;
                }
                case POSTGRES: {
                    if (DataSettings.QUERY_LOG.isTraceEnabled()) {
                        DataSettings.QUERY_LOG.trace("Changing the connection schema to: {}", (Object)name);
                    }
                    connection.setSchema(name);
                    break;
                }
                default: {
                    DefaultJdbcSchemaHandler.executeQuery(connection, "SET SCHEMA " + name + ";");
                    break;
                }
            }
        }
        catch (SQLException e) {
            throw new DataAccessException("Failed to change the schema: " + e.getMessage(), (Throwable)e);
        }
    }

    private static void executeQuery(Connection connection, String query) throws SQLException {
        if (DataSettings.QUERY_LOG.isTraceEnabled()) {
            DataSettings.QUERY_LOG.trace("Executing Query: {}", (Object)query);
        }
        try (Statement statement = connection.createStatement();){
            statement.execute(query);
        }
    }
}

