/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jdbc.mapper;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.jdbc.mapper.JdbcTuple;
import io.micronaut.data.runtime.mapper.sql.SqlTypeMapper;
import jakarta.persistence.Tuple;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;

@Internal
public final class JdbcTupleMapper
implements SqlTypeMapper<ResultSet, Tuple> {
    private final ConversionService conversionService;

    public JdbcTupleMapper(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public boolean hasNext(ResultSet resultSet) {
        try {
            return resultSet.next();
        }
        catch (SQLException e) {
            throw new DataAccessException("Failed to move the result set: " + e.getMessage(), (Throwable)e);
        }
    }

    public Tuple map(ResultSet rs, Class<Tuple> type) throws DataAccessException {
        try {
            ResultSetMetaData metaData = rs.getMetaData();
            Object[] values = new Object[metaData.getColumnCount()];
            HashMap aliasToPosition = CollectionUtils.newHashMap((int)values.length);
            for (int i = 0; i < values.length; ++i) {
                values[i] = rs.getObject(i + 1);
                String alias = metaData.getColumnName(i + 1);
                aliasToPosition.put(alias, i);
            }
            return new JdbcTuple(this.conversionService, values, aliasToPosition);
        }
        catch (SQLException e) {
            throw new DataAccessException("Failed to read the result set: " + e.getMessage(), (Throwable)e);
        }
    }

    public Object read(ResultSet object, String name) {
        throw new UnsupportedOperationException();
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }
}

