/*
 * Copyright 2017-2022 original authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.micronaut.data.jdbc.transaction;

import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.transaction.SynchronousTransactionManager;
import io.micronaut.transaction.async.AsyncUsingSyncTransactionOperations;

import javax.sql.DataSource;

/**
 * Build additional transaction manager to support using synchronous transaction manager with async methods.
 * Mostly to support Kotlin's coroutines.
 *
 * @author Denis Stepanov
 * @since 3.5.0
 */
@Factory
final class TransactionManagersFactory {

    @EachBean(DataSource.class)
    <T> AsyncUsingSyncTransactionOperations<T> buildAsyncTransactionOperations(@Parameter SynchronousTransactionManager<T> synchronousTransactionManager) {
        return new AsyncUsingSyncTransactionOperations<>(synchronousTransactionManager);
    }

}
