/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jpa.repository.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.jpa.repository.criteria.Specification;
import io.micronaut.data.model.Sort;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.data.runtime.intercept.AbstractQueryInterceptor;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSpecificationInterceptor<T, R>
extends AbstractQueryInterceptor<T, R> {
    protected AbstractSpecificationInterceptor(RepositoryOperations operations) {
        super(operations);
    }

    protected Specification getSpecification(MethodInvocationContext<?, ?> context, boolean nullable) {
        Object parameterValue = context.getParameterValues()[0];
        if (parameterValue instanceof Specification) {
            Specification specification = (Specification)parameterValue;
            return specification;
        }
        if (parameterValue == null) {
            if (nullable) {
                return null;
            }
            throw new IllegalArgumentException("Specification may not be null.");
        }
        throw new IllegalArgumentException("Argument must be an instance of: " + String.valueOf(Specification.class));
    }

    protected final List<Order> getOrders(Sort sort, Root<?> root, CriteriaBuilder cb) {
        ArrayList<Order> orders = new ArrayList<Order>();
        for (Sort.Order order : sort.getOrderBy()) {
            Path propertyPath = root;
            for (String path : StringUtils.splitOmitEmptyStrings((CharSequence)order.getProperty(), (char)'.')) {
                propertyPath = propertyPath.get(path);
            }
            Path expression = order.isIgnoreCase() ? cb.lower(propertyPath.as(String.class)) : propertyPath;
            orders.add(order.isAscending() ? cb.asc((Expression)expression) : cb.desc((Expression)expression));
        }
        return orders;
    }
}

