/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jpa.repository.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.ReturnType;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.jpa.operations.JpaRepositoryOperations;
import io.micronaut.data.jpa.repository.criteria.Specification;
import io.micronaut.data.jpa.repository.intercept.AbstractSpecificationInterceptor;
import io.micronaut.data.operations.RepositoryOperations;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.Collections;

@Internal
public class CountSpecificationInterceptor
extends AbstractSpecificationInterceptor<Object, Number> {
    private final JpaRepositoryOperations jpaOperations;

    public CountSpecificationInterceptor(@NonNull RepositoryOperations operations) {
        super(operations);
        if (!(operations instanceof JpaRepositoryOperations)) {
            throw new IllegalStateException("Repository operations must be na instance of JpaRepositoryOperations");
        }
        this.jpaOperations = (JpaRepositoryOperations)operations;
    }

    public Number intercept(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Number> context) {
        Predicate predicate;
        Specification specification = this.getSpecification(context, true);
        EntityManager entityManager = this.jpaOperations.getCurrentEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(Long.class);
        Root root = query.from(this.getRequiredRootEntity(context));
        Predicate predicate2 = predicate = specification != null ? specification.toPredicate(root, query, criteriaBuilder) : null;
        if (predicate != null) {
            query.where((Expression)predicate);
        }
        if (query.isDistinct()) {
            query.select((Selection)criteriaBuilder.countDistinct((Expression)root));
        } else {
            query.select((Selection)criteriaBuilder.count((Expression)root));
        }
        query.orderBy(Collections.emptyList());
        TypedQuery typedQuery = entityManager.createQuery(query);
        Long result = (Long)typedQuery.getSingleResult();
        ReturnType rt = context.getReturnType();
        Class returnType = rt.getType();
        if (returnType.isInstance(result)) {
            return result;
        }
        return (Number)this.operations.getConversionService().convertRequired((Object)result, rt.asArgument());
    }
}

