/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.jpa.repository.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.ReturnType;
import io.micronaut.data.exceptions.EmptyResultException;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.jpa.operations.JpaRepositoryOperations;
import io.micronaut.data.jpa.repository.criteria.Specification;
import io.micronaut.data.jpa.repository.intercept.AbstractSpecificationInterceptor;
import io.micronaut.data.operations.RepositoryOperations;
import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.Optional;

@Internal
public class FindOneSpecificationInterceptor
extends AbstractSpecificationInterceptor<Object, Object> {
    private final JpaRepositoryOperations jpaOperations;

    protected FindOneSpecificationInterceptor(@NonNull RepositoryOperations operations) {
        super(operations);
        JpaRepositoryOperations jpaRepositoryOperations;
        if (!(operations instanceof JpaRepositoryOperations)) {
            throw new IllegalStateException("Repository operations must be na instance of JpaRepositoryOperations");
        }
        this.jpaOperations = jpaRepositoryOperations = (JpaRepositoryOperations)operations;
    }

    public Object intercept(RepositoryMethodKey methodKey, MethodInvocationContext<Object, Object> context) {
        Predicate predicate;
        Specification specification = this.getSpecification(context, true);
        EntityManager entityManager = this.jpaOperations.getCurrentEntityManager();
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(this.getRequiredRootEntity(context));
        Root root = query.from(this.getRequiredRootEntity(context));
        Predicate predicate2 = predicate = specification != null ? specification.toPredicate(root, query, criteriaBuilder) : null;
        if (predicate != null) {
            query.where((Expression)predicate);
        }
        query.select((Selection)root);
        TypedQuery typedQuery = entityManager.createQuery(query);
        try {
            Object result = typedQuery.getSingleResult();
            ReturnType rt = context.getReturnType();
            Class returnType = rt.getType();
            if (returnType.isInstance(result)) {
                return result;
            }
            return this.operations.getConversionService().convertRequired(result, rt.asArgument());
        }
        catch (NoResultException e) {
            if (context.isNullable()) {
                return null;
            }
            if (context.getReturnType().isOptional()) {
                return Optional.empty();
            }
            throw new EmptyResultException();
        }
    }
}

