/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.Slice;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

class DefaultSlice<T>
implements Slice<T> {
    private final List<T> content;
    private final Pageable pageable;

    DefaultSlice(List<T> content, Pageable pageable) {
        ArgumentUtils.requireNonNull((String)"pageable", (Object)pageable);
        this.content = CollectionUtils.isEmpty(content) ? Collections.emptyList() : content;
        this.pageable = pageable;
    }

    @Override
    @NonNull
    public List<T> getContent() {
        return this.content;
    }

    @Override
    @NonNull
    public Pageable getPageable() {
        return this.pageable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultSlice)) {
            return false;
        }
        DefaultSlice that = (DefaultSlice)o;
        return Objects.equals(this.content, that.content) && Objects.equals(this.pageable, that.pageable);
    }

    public int hashCode() {
        return Objects.hash(this.content, this.pageable);
    }

    public String toString() {
        return "DefaultSlice{content=" + this.content + ", pageable=" + this.pageable + '}';
    }
}

