/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.runtime;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.type.Argument;
import io.micronaut.data.model.runtime.StoredDataOperation;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.transaction.TransactionDefinition;
import io.micronaut.transaction.annotation.TransactionalAdvice;
import io.micronaut.transaction.interceptor.DefaultTransactionAttribute;
import io.micronaut.transaction.support.DefaultTransactionDefinition;
import java.time.Duration;
import java.util.Optional;

public class DefaultStoredDataOperation<R>
implements StoredDataOperation<R> {
    public static final DefaultTransactionDefinition NO_TRANSACTION = new DefaultTransactionDefinition();
    private final ExecutableMethod<?, ?> method;
    private TransactionDefinition transactionDefinition;

    public DefaultStoredDataOperation(ExecutableMethod<?, ?> method) {
        this.method = method;
    }

    @Override
    @NonNull
    public final Optional<TransactionDefinition> getTransactionDefinition() {
        if (this.transactionDefinition == null) {
            AnnotationValue annotation = this.method.getAnnotation(TransactionalAdvice.class);
            if (annotation != null) {
                DefaultTransactionAttribute attribute = new DefaultTransactionAttribute();
                attribute.setName(this.method.getDeclaringType().getSimpleName() + "." + this.method.getMethodName());
                attribute.setReadOnly(annotation.isTrue("readOnly"));
                annotation.intValue("timeout").ifPresent(value -> attribute.setTimeout(Duration.ofSeconds(value)));
                Class[] noRollbackFors = annotation.classValues("noRollbackFor");
                attribute.setNoRollbackFor(noRollbackFors);
                annotation.enumValue("propagation", TransactionDefinition.Propagation.class).ifPresent(arg_0 -> ((DefaultTransactionAttribute)attribute).setPropagationBehavior(arg_0));
                annotation.enumValue("isolation", TransactionDefinition.Isolation.class).ifPresent(arg_0 -> ((DefaultTransactionAttribute)attribute).setIsolationLevel(arg_0));
                this.transactionDefinition = attribute;
            } else {
                this.transactionDefinition = NO_TRANSACTION;
            }
        }
        if (this.transactionDefinition != NO_TRANSACTION) {
            return Optional.of(this.transactionDefinition);
        }
        return Optional.empty();
    }

    @Override
    @NonNull
    public final Argument<R> getResultArgument() {
        return this.method.getReturnType().asArgument();
    }

    public final AnnotationMetadata getAnnotationMetadata() {
        return this.method.getAnnotationMetadata();
    }
}

