/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.intercept;

import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ExecutableMethod;
import java.util.Objects;

@Internal
public final class RepositoryMethodKey {
    private final Object repository;
    private final ExecutableMethod method;
    private final int hashCode;

    public RepositoryMethodKey(Object repository, ExecutableMethod method) {
        this.repository = repository;
        this.method = method;
        this.hashCode = Objects.hash(repository, method);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryMethodKey that = (RepositoryMethodKey)o;
        return this.repository.equals(that.repository) && this.method.equals(that.method);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

