/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.repository.jpa.criteria;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.repository.jpa.criteria.PredicateSpecification;
import io.micronaut.data.repository.jpa.criteria.SpecificationComposition;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;

public interface QuerySpecification<T> {
    public static final QuerySpecification<?> ALL = (root, query, criteriaBuilder) -> null;

    @NonNull
    public static <T> QuerySpecification<T> not(@Nullable QuerySpecification<T> spec) {
        if (spec == null) {
            return ALL;
        }
        return (root, query, criteriaBuilder) -> criteriaBuilder.not((Expression)spec.toPredicate(root, query, criteriaBuilder));
    }

    @NonNull
    public static <T> QuerySpecification<T> where(@Nullable QuerySpecification<T> spec) {
        if (spec == null) {
            return ALL;
        }
        return spec;
    }

    @NonNull
    public static <T> QuerySpecification<T> where(@Nullable PredicateSpecification<T> spec) {
        if (spec == null) {
            return ALL;
        }
        return (root, query, criteriaBuilder) -> spec.toPredicate(root, criteriaBuilder);
    }

    @NonNull
    default public QuerySpecification<T> and(@Nullable QuerySpecification<T> other) {
        return SpecificationComposition.composed(this, other, CriteriaBuilder::and);
    }

    @NonNull
    default public QuerySpecification<T> or(@Nullable QuerySpecification<T> other) {
        return SpecificationComposition.composed(this, other, CriteriaBuilder::or);
    }

    @NonNull
    default public QuerySpecification<T> and(@Nullable PredicateSpecification<T> other) {
        return SpecificationComposition.composed(this, other, CriteriaBuilder::and);
    }

    @NonNull
    default public QuerySpecification<T> or(@Nullable PredicateSpecification<T> other) {
        return SpecificationComposition.composed(this, other, CriteriaBuilder::or);
    }

    @Nullable
    public Predicate toPredicate(@NonNull Root<T> var1, @NonNull CriteriaQuery<?> var2, @NonNull CriteriaBuilder var3);
}

