/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.query.builder.QueryParameterBinding;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public interface QueryResult {
    @NonNull
    public String getQuery();

    @NonNull
    public List<String> getQueryParts();

    @NonNull
    default public Map<String, String> getParameters() {
        return this.getParameterBindings().stream().collect(Collectors.toMap(QueryParameterBinding::getKey, p -> String.join((CharSequence)".", p.getPropertyPath())));
    }

    @NonNull
    default public Map<String, DataType> getParameterTypes() {
        return this.getParameterBindings().stream().collect(Collectors.toMap(p -> String.join((CharSequence)".", p.getPropertyPath()), QueryParameterBinding::getDataType, (d1, d2) -> d1));
    }

    public List<QueryParameterBinding> getParameterBindings();

    public Map<String, String> getAdditionalRequiredParameters();

    default public int getMax() {
        return -1;
    }

    default public long getOffset() {
        return 0L;
    }

    @NonNull
    public static QueryResult of(final @NonNull String query, final @NonNull List<String> queryParts, final @NonNull List<QueryParameterBinding> parameterBindings, final @NonNull Map<String, String> additionalRequiredParameters) {
        ArgumentUtils.requireNonNull((String)"query", (Object)query);
        ArgumentUtils.requireNonNull((String)"parameterBindings", parameterBindings);
        ArgumentUtils.requireNonNull((String)"additionalRequiredParameters", additionalRequiredParameters);
        return new QueryResult(){

            @Override
            @NonNull
            public String getQuery() {
                return query;
            }

            @Override
            public List<String> getQueryParts() {
                return queryParts;
            }

            @Override
            public List<QueryParameterBinding> getParameterBindings() {
                return parameterBindings;
            }

            @Override
            public Map<String, String> getAdditionalRequiredParameters() {
                return additionalRequiredParameters;
            }
        };
    }

    @NonNull
    public static QueryResult of(final @NonNull String query, final @NonNull List<String> queryParts, final @NonNull List<QueryParameterBinding> parameterBindings, final @NonNull Map<String, String> additionalRequiredParameters, final int max, final long offset) {
        ArgumentUtils.requireNonNull((String)"query", (Object)query);
        ArgumentUtils.requireNonNull((String)"parameterBindings", parameterBindings);
        ArgumentUtils.requireNonNull((String)"additionalRequiredParameters", additionalRequiredParameters);
        return new QueryResult(){

            @Override
            public int getMax() {
                return max;
            }

            @Override
            public long getOffset() {
                return offset;
            }

            @Override
            @NonNull
            public String getQuery() {
                return query;
            }

            @Override
            public List<String> getQueryParts() {
                return queryParts;
            }

            @Override
            public List<QueryParameterBinding> getParameterBindings() {
                return parameterBindings;
            }

            @Override
            public Map<String, String> getAdditionalRequiredParameters() {
                return additionalRequiredParameters;
            }
        };
    }
}

