/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.intercept;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.Qualifier;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.data.annotation.Repository;
import io.micronaut.data.annotation.RepositoryConfiguration;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.intercept.DataInterceptor;
import io.micronaut.data.intercept.RepositoryMethodKey;
import io.micronaut.data.intercept.annotation.DataMethod;
import io.micronaut.data.operations.PrimaryRepositoryOperations;
import io.micronaut.data.operations.RepositoryOperations;
import io.micronaut.inject.InjectionPoint;
import io.micronaut.inject.qualifiers.Qualifiers;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Internal
@Singleton
final class DataInterceptorResolver {
    private final BeanLocator locator;
    private final Map<RepositoryMethodKey, DataInterceptor<? super Object, ? super Object>> interceptors = new ConcurrentHashMap<RepositoryMethodKey, DataInterceptor<? super Object, ? super Object>>();

    DataInterceptorResolver(BeanLocator locator) {
        this.locator = locator;
    }

    DataInterceptor<Object, Object> resolve(@NonNull RepositoryMethodKey key, @NonNull MethodInvocationContext<Object, Object> context, @Nullable InjectionPoint<?> injectionPoint) {
        return this.interceptors.computeIfAbsent(key, k -> {
            String dataSourceName = context.stringValue(Repository.class).orElseGet(() -> injectionPoint == null ? null : (String)injectionPoint.getAnnotationMetadata().stringValue(Repository.class).orElse(null));
            Class<PrimaryRepositoryOperations> operationsType = context.classValue(RepositoryConfiguration.class, "operations").orElse(PrimaryRepositoryOperations.class);
            Class interceptorType = context.classValue(DataMethod.class, "interceptor").orElseGet(() -> {
                AnnotationValue declaredAnnotation = context.getDeclaredAnnotation(DataMethod.class);
                if (declaredAnnotation == null) {
                    return null;
                }
                return declaredAnnotation.classValue("interceptor").orElse(null);
            });
            if (interceptorType != null && DataInterceptor.class.isAssignableFrom(interceptorType)) {
                return this.findInterceptor(dataSourceName, operationsType, interceptorType);
            }
            String interceptorName = context.getAnnotationMetadata().stringValue(DataMethod.class, "interceptor").orElse(null);
            if (interceptorName != null) {
                throw new IllegalStateException("Micronaut Data Interceptor [" + interceptorName + "] is not on the classpath but required by the method: " + context.getExecutableMethod().toString());
            }
            throw new IllegalStateException("Micronaut Data method is missing compilation time query information. Ensure that the Micronaut Data annotation processors are declared in your build and try again with a clean re-build.");
        });
    }

    @NonNull
    private DataInterceptor<Object, Object> findInterceptor(@Nullable String dataSourceName, @NonNull Class<?> operationsType, @NonNull Class<?> interceptorType) {
        RepositoryOperations datastore;
        if (!RepositoryOperations.class.isAssignableFrom(operationsType)) {
            throw new IllegalArgumentException("Repository type must be an instance of RepositoryOperations!");
        }
        try {
            if (dataSourceName != null) {
                Qualifier qualifier = Qualifiers.byName((String)dataSourceName);
                datastore = (RepositoryOperations)this.locator.getBean(operationsType, qualifier);
            } else {
                datastore = (RepositoryOperations)this.locator.getBean(operationsType);
            }
        }
        catch (NoSuchBeanException e) {
            throw new ConfigurationException("No backing RepositoryOperations configured for repository. Check your configuration and try again", (Throwable)e);
        }
        BeanIntrospection introspection = (BeanIntrospection)BeanIntrospector.SHARED.findIntrospections(ref -> ref.isPresent() && interceptorType.isAssignableFrom(ref.getBeanType())).stream().findFirst().orElseThrow(() -> new DataAccessException("No Data interceptor found for type: " + interceptorType));
        DataInterceptor interceptor = introspection.getConstructorArguments().length == 0 ? (DataInterceptor)introspection.instantiate() : (DataInterceptor)introspection.instantiate(new Object[]{datastore});
        return interceptor;
    }
}

