/*
 * Copyright 2017-2021 original authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.micronaut.data.event;

import io.micronaut.data.model.runtime.RuntimePersistentEntity;

/**
 * Context object for event receivers.
 *
 * @param <T> The generic type of the entity
 * @author graemerocher
 * @since 2.3.0
 */
public interface PersistenceEventContext<T> {

    /**
     * @return The {@link RuntimePersistentEntity} associated with the entity
     */
    RuntimePersistentEntity<T> getPersistentEntity();
}
