/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import java.io.IOException;

@Prototype
@Internal
class PageSerializer
implements Serializer<Page<Object>> {
    PageSerializer() {
    }

    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Page<Object>> type, Page<Object> page) throws IOException {
        PageSerializer.serializePage(encoder, context, type, page);
    }

    public static void serializePage(Encoder encoder, Serializer.EncoderContext context, Argument<? extends Page<Object>> type, Page<Object> page) throws IOException {
        Encoder e = encoder.encodeObject(type);
        e.encodeKey("content");
        Argument contentType = Argument.listOf((Argument)type.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT));
        context.findSerializer(contentType).createSpecific(context, contentType).serialize(e, context, contentType, page.getContent());
        e.encodeKey("pageable");
        Argument pageable = Argument.of(Pageable.class);
        context.findSerializer(pageable).createSpecific(context, pageable).serialize(e, context, pageable, (Object)page.getPageable());
        e.encodeKey("totalSize");
        e.encodeLong(page.getTotalSize());
        e.finishStructure();
    }
}

