/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.data.model.DefaultSlice;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.Pageable;
import io.micronaut.serde.annotation.Serdeable;
import java.util.List;
import java.util.Objects;

@Serdeable
class DefaultPage<T>
extends DefaultSlice<T>
implements Page<T> {
    private final long totalSize;

    @JsonCreator
    @Creator
    @ReflectiveAccess
    DefaultPage(@JsonProperty(value="content") List<T> content, @JsonProperty(value="pageable") Pageable pageable, @JsonProperty(value="totalSize") long totalSize) {
        super(content, pageable);
        this.totalSize = totalSize;
    }

    @Override
    @ReflectiveAccess
    public long getTotalSize() {
        return this.totalSize;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultPage)) {
            return false;
        }
        DefaultPage that = (DefaultPage)o;
        return this.totalSize == that.totalSize && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.totalSize, super.hashCode());
    }

    @Override
    public String toString() {
        return "DefaultPage{totalSize=" + this.totalSize + ",content=" + this.getContent() + ",pageable=" + this.getPageable() + "}";
    }
}

