/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder.sql;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.EntityRepresentation;
import io.micronaut.data.annotation.GeneratedValue;
import io.micronaut.data.annotation.Index;
import io.micronaut.data.annotation.Indexes;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.annotation.MappedEntity;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.annotation.Repository;
import io.micronaut.data.exceptions.MappingException;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.Embedded;
import io.micronaut.data.model.JsonDataType;
import io.micronaut.data.model.Pageable;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.naming.NamingStrategy;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.QueryModel;
import io.micronaut.data.model.query.builder.AbstractSqlLikeQueryBuilder;
import io.micronaut.data.model.query.builder.QueryBuilder;
import io.micronaut.data.model.query.builder.QueryParameterBinding;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilderUtils;
import io.micronaut.data.model.query.builder.sql.SqlQueryConfiguration;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class SqlQueryBuilder
extends AbstractSqlLikeQueryBuilder
implements QueryBuilder,
SqlQueryConfiguration.DialectConfiguration {
    public static final String DEFAULT_POSITIONAL_PARAMETER_MARKER = "?";
    public static final String STANDARD_FOR_UPDATE_CLAUSE = " FOR UPDATE";
    public static final String SQL_SERVER_FOR_UPDATE_CLAUSE = " WITH (UPDLOCK, ROWLOCK)";
    private static final String ANN_JOIN_TABLE = "io.micronaut.data.annotation.sql.JoinTable";
    private static final String ANN_JOIN_COLUMNS = "io.micronaut.data.annotation.sql.JoinColumns";
    private static final String BLANK_SPACE = " ";
    private static final String SEQ_SUFFIX = "_seq";
    private static final String INSERT_INTO = "INSERT INTO ";
    private static final String JDBC_REPO_ANNOTATION = "io.micronaut.data.jdbc.annotation.JdbcRepository";
    private final Dialect dialect;
    private final Map<Dialect, DialectConfig> perDialectConfig = new HashMap<Dialect, DialectConfig>(3);
    private Pattern positionalParameterPattern;

    @Creator
    public SqlQueryBuilder(AnnotationMetadata annotationMetadata) {
        if (annotationMetadata != null) {
            this.dialect = annotationMetadata.enumValue(JDBC_REPO_ANNOTATION, "dialect", Dialect.class).orElseGet(() -> annotationMetadata.enumValue(Repository.class, "dialect", Dialect.class).orElse(Dialect.ANSI));
            AnnotationValue annotation = annotationMetadata.getAnnotation(SqlQueryConfiguration.class);
            if (annotation != null) {
                List dialectConfigs = annotation.getAnnotations("value", SqlQueryConfiguration.DialectConfiguration.class);
                for (AnnotationValue dialectConfig : dialectConfigs) {
                    dialectConfig.enumValue("dialect", Dialect.class).ifPresent(dialect -> {
                        DialectConfig dc = new DialectConfig();
                        this.perDialectConfig.put((Dialect)((Object)dialect), dc);
                        dialectConfig.stringValue("positionalParameterFormat").ifPresent(format -> {
                            dc.positionalFormatter = format;
                        });
                        dialectConfig.stringValue("positionalParameterName").ifPresent(format -> {
                            dc.positionalNameFormatter = format;
                        });
                        dialectConfig.booleanValue("escapeQueries").ifPresent(escape -> {
                            dc.escapeQueries = escape;
                        });
                    });
                }
            }
        } else {
            this.dialect = Dialect.ANSI;
        }
    }

    public SqlQueryBuilder() {
        this.dialect = Dialect.ANSI;
    }

    public SqlQueryBuilder(Dialect dialect) {
        ArgumentUtils.requireNonNull((String)"dialect", (Object)((Object)dialect));
        this.dialect = dialect;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    protected boolean shouldEscape(@NonNull PersistentEntity entity) {
        DialectConfig config = this.perDialectConfig.get((Object)this.dialect);
        if (config != null && config.escapeQueries != null) {
            return config.escapeQueries;
        }
        return super.shouldEscape(entity);
    }

    @Override
    protected String asLiteral(Object value) {
        if ((this.dialect == Dialect.SQL_SERVER || this.dialect == Dialect.ORACLE) && value instanceof Boolean) {
            return (Boolean)value != false ? "1" : "0";
        }
        return super.asLiteral(value);
    }

    @Override
    public boolean shouldAliasProjections() {
        return false;
    }

    @Override
    protected boolean isExpandEmbedded() {
        return true;
    }

    @NonNull
    public String buildBatchCreateTableStatement(PersistentEntity ... entities) {
        return Arrays.stream(entities).flatMap(entity -> Stream.of(this.buildCreateTableStatements((PersistentEntity)entity))).collect(Collectors.joining(System.getProperty("line.separator")));
    }

    @NonNull
    public String buildBatchDropTableStatement(PersistentEntity ... entities) {
        return Arrays.stream(entities).flatMap(entity -> Stream.of(this.buildDropTableStatements((PersistentEntity)entity))).collect(Collectors.joining("\n"));
    }

    @NonNull
    public String[] buildDropTableStatements(@NonNull PersistentEntity entity) {
        String tableName = this.getTableName(entity);
        boolean escape = this.shouldEscape(entity);
        String sql = "DROP TABLE " + tableName;
        Collection<Association> foreignKeyAssociations = this.getJoinTableAssociations(entity);
        ArrayList<CallSite> dropStatements = new ArrayList<CallSite>();
        for (Association association : foreignKeyAssociations) {
            AnnotationMetadata associationMetadata = association.getAnnotationMetadata();
            NamingStrategy namingStrategy = this.getNamingStrategy(entity);
            String joinTableName = associationMetadata.stringValue(ANN_JOIN_TABLE, "name").orElseGet(() -> this.getMappedName(namingStrategy, association));
            dropStatements.add((CallSite)((Object)("DROP TABLE " + (escape ? this.quote(joinTableName) : joinTableName) + ";")));
        }
        dropStatements.add((CallSite)((Object)sql));
        return dropStatements.toArray(new String[0]);
    }

    @NonNull
    public String buildJoinTableInsert(@NonNull PersistentEntity entity, @NonNull Association association) {
        if (!SqlQueryBuilder.isForeignKeyWithJoinTable(association)) {
            throw new IllegalArgumentException("Join table inserts can only be built for foreign key associations that are mapped with a join table.");
        }
        Optional<Association> inverseSide = association.getInverseSide().map(Function.identity());
        Association owningAssociation = inverseSide.orElse(association);
        AnnotationMetadata annotationMetadata = owningAssociation.getAnnotationMetadata();
        NamingStrategy namingStrategy = this.getNamingStrategy(entity);
        String joinTableName = annotationMetadata.stringValue(ANN_JOIN_TABLE, "name").orElseGet(() -> this.getMappedName(namingStrategy, association));
        List<String> leftJoinColumns = this.resolveJoinTableJoinColumns(annotationMetadata, true, entity, namingStrategy);
        List<String> rightJoinColumns = this.resolveJoinTableJoinColumns(annotationMetadata, false, association.getAssociatedEntity(), namingStrategy);
        boolean escape = this.shouldEscape(entity);
        String columns = Stream.concat(leftJoinColumns.stream(), rightJoinColumns.stream()).map(columnName -> escape ? this.quote((String)columnName) : columnName).collect(Collectors.joining(","));
        String placeholders = IntStream.range(0, leftJoinColumns.size() + rightJoinColumns.size()).mapToObj(i -> this.formatParameter(i + 1).toString()).collect(Collectors.joining(","));
        return INSERT_INTO + this.quote(joinTableName) + " (" + columns + ") VALUES (" + placeholders + ")";
    }

    public static boolean isForeignKeyWithJoinTable(@NonNull Association association) {
        return association.isForeignKey() && !association.getAnnotationMetadata().stringValue(Relation.class, "mappedBy").isPresent();
    }

    @NonNull
    public String[] buildCreateTableStatements(@NonNull PersistentEntity entity) {
        PersistentProperty version;
        ArgumentUtils.requireNonNull((String)"entity", (Object)entity);
        String unescapedTableName = this.getUnescapedTableName(entity);
        String tableName = this.getTableName(entity);
        boolean escape = this.shouldEscape(entity);
        PersistentProperty identity = entity.getIdentity();
        ArrayList<String> createStatements = new ArrayList<String>();
        String schema = this.getSchemaName(entity);
        if (StringUtils.isNotEmpty((CharSequence)schema)) {
            if (escape) {
                schema = this.quote(schema);
            }
            createStatements.add("CREATE SCHEMA " + schema + ";");
        }
        Collection<Association> foreignKeyAssociations = this.getJoinTableAssociations(entity);
        NamingStrategy namingStrategy = this.getNamingStrategy(entity);
        if (CollectionUtils.isNotEmpty(foreignKeyAssociations)) {
            for (Association association : foreignKeyAssociations) {
                String columnName;
                PersistentPropertyPath pp2;
                int i;
                StringBuilder joinTableBuilder = new StringBuilder("CREATE TABLE ");
                PersistentEntity associatedEntity = association.getAssociatedEntity();
                Optional<Association> inverseSide = association.getInverseSide().map(Function.identity());
                Association owningAssociation = inverseSide.orElse(association);
                AnnotationMetadata annotationMetadata = owningAssociation.getAnnotationMetadata();
                String joinTableName = annotationMetadata.stringValue(ANN_JOIN_TABLE, "name").orElseGet(() -> this.getMappedName(namingStrategy, association));
                if (escape) {
                    joinTableName = this.quote(joinTableName);
                }
                joinTableBuilder.append(joinTableName).append(" (");
                ArrayList leftProperties = new ArrayList();
                ArrayList rightProperties = new ArrayList();
                boolean isAssociationOwner = !inverseSide.isPresent();
                List<String> leftJoinTableColumns = this.resolveJoinTableJoinColumns(annotationMetadata, isAssociationOwner, entity, namingStrategy);
                List<String> rightJoinTableColumns = this.resolveJoinTableJoinColumns(annotationMetadata, !isAssociationOwner, association.getAssociatedEntity(), namingStrategy);
                this.traversePersistentProperties(entity.getIdentity(), (List<Association> associations, PersistentProperty property) -> leftProperties.add(PersistentPropertyPath.of(associations, property, "")));
                this.traversePersistentProperties(associatedEntity.getIdentity(), (List<Association> associations, PersistentProperty property) -> rightProperties.add(PersistentPropertyPath.of(associations, property, "")));
                if (leftJoinTableColumns.size() == leftProperties.size()) {
                    for (i = 0; i < leftJoinTableColumns.size(); ++i) {
                        pp2 = (PersistentPropertyPath)leftProperties.get(i);
                        columnName = leftJoinTableColumns.get(i);
                        if (escape) {
                            columnName = this.quote(columnName);
                        }
                        joinTableBuilder.append(SqlQueryBuilderUtils.addTypeToColumn(pp2.getProperty(), columnName, this.dialect, true)).append(',');
                    }
                } else {
                    for (PersistentPropertyPath pp2 : leftProperties) {
                        columnName = namingStrategy.mappedJoinTableColumn(entity, pp2.getAssociations(), pp2.getProperty());
                        if (escape) {
                            columnName = this.quote(columnName);
                        }
                        joinTableBuilder.append(SqlQueryBuilderUtils.addTypeToColumn(pp2.getProperty(), columnName, this.dialect, true)).append(',');
                    }
                }
                if (rightJoinTableColumns.size() == rightProperties.size()) {
                    for (i = 0; i < rightJoinTableColumns.size(); ++i) {
                        pp2 = (PersistentPropertyPath)rightProperties.get(i);
                        columnName = rightJoinTableColumns.get(i);
                        if (escape) {
                            columnName = this.quote(columnName);
                        }
                        joinTableBuilder.append(SqlQueryBuilderUtils.addTypeToColumn(pp2.getProperty(), columnName, this.dialect, true)).append(',');
                    }
                } else {
                    for (PersistentPropertyPath pp2 : rightProperties) {
                        columnName = namingStrategy.mappedJoinTableColumn(entity, pp2.getAssociations(), pp2.getProperty());
                        if (escape) {
                            columnName = this.quote(columnName);
                        }
                        joinTableBuilder.append(SqlQueryBuilderUtils.addTypeToColumn(pp2.getProperty(), columnName, this.dialect, true)).append(',');
                    }
                }
                joinTableBuilder.setLength(joinTableBuilder.length() - 1);
                joinTableBuilder.append(")");
                if (this.dialect != Dialect.ORACLE) {
                    joinTableBuilder.append(';');
                }
                createStatements.add(joinTableBuilder.toString());
            }
        }
        boolean generatePkAfterColumns = false;
        ArrayList<String> primaryColumnsName = new ArrayList<String>();
        ArrayList<String> columns = new ArrayList<String>();
        if (identity != null) {
            ArrayList ids = new ArrayList();
            this.traversePersistentProperties(identity, (List<Association> associations, PersistentProperty property) -> ids.add(PersistentPropertyPath.of(associations, property, "")));
            int idFieldCount = ids.size();
            if (idFieldCount > 1) {
                generatePkAfterColumns = true;
            } else if (!(idFieldCount <= 0 || identity.isGenerated() || this.dialect == Dialect.MYSQL && ((PersistentPropertyPath)ids.get(0)).getProperty().getDataType() == DataType.BYTE_ARRAY)) {
                generatePkAfterColumns = true;
            }
            boolean finalGeneratePkAfterColumns = generatePkAfterColumns;
            for (PersistentPropertyPath pp : ids) {
                String column = this.getMappedName(namingStrategy, pp.getAssociations(), pp.getProperty());
                if (escape) {
                    column = this.quote(column);
                }
                primaryColumnsName.add(column);
                column = SqlQueryBuilderUtils.addTypeToColumn(pp.getProperty(), column, this.dialect, this.isRequired(pp.getAssociations(), pp.getProperty()));
                if (this.isNotForeign(pp.getAssociations())) {
                    column = this.addGeneratedStatementToColumn(pp.getProperty(), column, !finalGeneratePkAfterColumns);
                }
                columns.add(column);
            }
        }
        if ((version = entity.getVersion()) != null) {
            String column = this.getMappedName(namingStrategy, Collections.emptyList(), version);
            if (escape) {
                column = this.quote(column);
            }
            column = SqlQueryBuilderUtils.addTypeToColumn(version, column, this.dialect, true);
            columns.add(column);
        }
        BiConsumer<List<Association>, PersistentProperty> addColumn = (associations, property) -> {
            String column = this.getMappedName(namingStrategy, (List<Association>)associations, (PersistentProperty)property);
            if (escape) {
                column = this.quote(column);
            }
            column = SqlQueryBuilderUtils.addTypeToColumn(property, column, this.dialect, this.isRequired((List<Association>)associations, (PersistentProperty)property));
            if (this.isNotForeign((List<Association>)associations)) {
                column = this.addGeneratedStatementToColumn((PersistentProperty)property, column, false);
            }
            columns.add(column);
        };
        for (PersistentProperty persistentProperty : entity.getPersistentProperties()) {
            this.traversePersistentProperties(persistentProperty, addColumn);
        }
        StringBuilder builder = new StringBuilder("CREATE TABLE ").append(tableName).append(" (");
        builder.append(String.join((CharSequence)",", columns));
        if (generatePkAfterColumns) {
            builder.append(", PRIMARY KEY(").append(String.join((CharSequence)",", primaryColumnsName)).append(')');
        }
        if (this.dialect == Dialect.ORACLE) {
            builder.append(")");
        } else {
            builder.append(");");
        }
        if (identity != null && identity.isGenerated()) {
            GeneratedValue.Type type = identity.getAnnotationMetadata().enumValue(GeneratedValue.class, GeneratedValue.Type.class).orElseGet(() -> this.selectAutoStrategy(identity));
            boolean isSequence = type == GeneratedValue.Type.SEQUENCE;
            String generatedDefinition = identity.getAnnotationMetadata().stringValue(GeneratedValue.class, "definition").orElse(null);
            if (generatedDefinition != null) {
                createStatements.add(generatedDefinition);
            } else if (isSequence) {
                boolean isSqlServer = this.dialect == Dialect.SQL_SERVER;
                String sequenceName = this.quote(unescapedTableName + SEQ_SUFFIX);
                String createSequenceStmt = "CREATE SEQUENCE " + sequenceName;
                if (isSqlServer) {
                    createSequenceStmt = createSequenceStmt + " AS BIGINT";
                }
                createSequenceStmt = createSequenceStmt + " MINVALUE 1 START WITH 1";
                if (this.dialect == Dialect.ORACLE) {
                    createSequenceStmt = createSequenceStmt + " CACHE 100 NOCYCLE";
                } else if (isSqlServer) {
                    createSequenceStmt = createSequenceStmt + " INCREMENT BY 1";
                }
                createStatements.add(createSequenceStmt);
            }
        }
        createStatements.add(builder.toString());
        this.addIndexes(entity, tableName, createStatements);
        return createStatements.toArray(new String[0]);
    }

    private void addIndexes(PersistentEntity entity, String tableName, List<String> createStatements) {
        List<String> indexes = this.createIndexes(entity, tableName);
        if (CollectionUtils.isNotEmpty(indexes)) {
            createStatements.addAll(indexes);
        }
    }

    private List<String> createIndexes(PersistentEntity entity, String tableName) {
        ArrayList<String> indexStatements = new ArrayList<String>();
        Optional<List> indexes = entity.findAnnotation(Indexes.class).map(idxes -> idxes.getAnnotations("value", Index.class));
        Stream.of(indexes).flatMap(o -> o.map(Stream::of).orElseGet(Stream::empty)).flatMap(Collection::stream).forEach(index -> indexStatements.add(this.addIndex(entity, new IndexConfiguration((AnnotationValue<?>)index, tableName, entity.getPersistedName()))));
        return indexStatements;
    }

    private String addIndex(PersistentEntity entity, IndexConfiguration config) {
        String indexName = config.index.stringValue("name").orElse(String.format("idx_%s%s", this.prepareNames(config.unquotedTableName), this.makeTransformedColumnList(this.provideColumnList(config))));
        if (this.shouldEscape(entity)) {
            indexName = this.quote(indexName);
        }
        StringBuilder indexBuilder = new StringBuilder();
        indexBuilder.append("CREATE ").append(config.index.booleanValue("unique").map(isUnique -> isUnique != false ? "UNIQUE " : "").orElse("")).append("INDEX ");
        indexBuilder.append(indexName).append(" ON " + Optional.ofNullable(config.tableName).orElseThrow(() -> new NullPointerException("Table name cannot be null")) + " (" + this.provideColumnList(config));
        if (this.dialect == Dialect.ORACLE) {
            indexBuilder.append(")");
        } else {
            indexBuilder.append(");");
        }
        return indexBuilder.toString();
    }

    private String provideColumnList(IndexConfiguration config) {
        return String.join((CharSequence)", ", (String[])config.index.getValues().get("columns"));
    }

    private String makeTransformedColumnList(String columnList) {
        return Arrays.stream(this.prepareNames(columnList).split(",")).map(col -> "_" + col).collect(Collectors.joining());
    }

    private String prepareNames(String columnList) {
        return columnList.chars().mapToObj(c -> String.valueOf((char)c)).filter(x -> !x.equals(BLANK_SPACE)).filter(x -> !x.equals("\"")).map(String::toLowerCase).collect(Collectors.joining());
    }

    private boolean isRequired(List<Association> associations, PersistentProperty property) {
        PersistentProperty foreignAssociation = null;
        for (Association association : associations) {
            if (!association.isRequired()) {
                return false;
            }
            if (association.getKind() == Relation.Kind.EMBEDDED || foreignAssociation != null) continue;
            foreignAssociation = association;
        }
        if (foreignAssociation != null) {
            return foreignAssociation.isRequired();
        }
        return property.isRequired();
    }

    private boolean isNotForeign(List<Association> associations) {
        for (Association association : associations) {
            if (association.getKind() == Relation.Kind.EMBEDDED) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String getTableAsKeyword() {
        return BLANK_SPACE;
    }

    private String addGeneratedStatementToColumn(PersistentProperty prop, String column, boolean isPk) {
        if (prop.isGenerated()) {
            boolean addPkBefore;
            GeneratedValue.Type type = prop.getAnnotationMetadata().enumValue(GeneratedValue.class, GeneratedValue.Type.class).orElse(GeneratedValue.Type.AUTO);
            if (type == GeneratedValue.Type.AUTO) {
                type = prop.getDataType() == DataType.UUID ? GeneratedValue.Type.UUID : (this.dialect == Dialect.ORACLE ? GeneratedValue.Type.SEQUENCE : GeneratedValue.Type.IDENTITY);
            }
            boolean bl = addPkBefore = this.dialect != Dialect.H2 && this.dialect != Dialect.ORACLE;
            if (isPk && addPkBefore) {
                column = (String)column + " PRIMARY KEY";
            }
            switch (this.dialect) {
                case POSTGRES: {
                    if (type == GeneratedValue.Type.SEQUENCE) {
                        column = (String)column + " NOT NULL";
                        break;
                    }
                    if (type == GeneratedValue.Type.IDENTITY) {
                        if (isPk) {
                            column = (String)column + " GENERATED ALWAYS AS IDENTITY";
                            break;
                        }
                        column = (String)column + " NOT NULL";
                        break;
                    }
                    if (type != GeneratedValue.Type.UUID) break;
                    column = (String)column + " NOT NULL DEFAULT uuid_generate_v4()";
                    break;
                }
                case SQL_SERVER: {
                    if (type == GeneratedValue.Type.UUID) {
                        column = (String)column + " NOT NULL DEFAULT newid()";
                        break;
                    }
                    if (type == GeneratedValue.Type.SEQUENCE) {
                        if (!isPk) break;
                        column = (String)column + " NOT NULL";
                        break;
                    }
                    column = (String)column + " IDENTITY(1,1) NOT NULL";
                    break;
                }
                case ORACLE: {
                    if (type == GeneratedValue.Type.UUID) {
                        column = (String)column + " NOT NULL DEFAULT SYS_GUID()";
                        break;
                    }
                    if (type == GeneratedValue.Type.IDENTITY) {
                        if (isPk) {
                            column = (String)column + " GENERATED ALWAYS AS IDENTITY (MINVALUE 1 START WITH 1 CACHE 100 NOCYCLE)";
                            break;
                        }
                        column = (String)column + " NOT NULL";
                        break;
                    }
                    column = (String)column + " NOT NULL";
                    break;
                }
                default: {
                    if (type == GeneratedValue.Type.UUID) {
                        if (this.dialect != Dialect.MYSQL) {
                            column = (String)column + " NOT NULL DEFAULT random_uuid()";
                            break;
                        }
                        column = (String)column + " NOT NULL";
                        break;
                    }
                    column = (String)column + " AUTO_INCREMENT";
                }
            }
            if (isPk && !addPkBefore) {
                column = (String)column + " PRIMARY KEY";
            }
        }
        return column;
    }

    @NonNull
    private List<String> resolveJoinTableJoinColumns(AnnotationMetadata annotationMetadata, boolean associationOwner, PersistentEntity entity, NamingStrategy namingStrategy) {
        List<String> joinColumns = this.getJoinedColumns(annotationMetadata, associationOwner, "name");
        if (!joinColumns.isEmpty()) {
            return joinColumns;
        }
        ArrayList<String> columns = new ArrayList<String>();
        this.traversePersistentProperties(entity.getIdentity(), (List<Association> associations, PersistentProperty property) -> columns.add(namingStrategy.mappedJoinTableColumn(entity, (List<Association>)associations, (PersistentProperty)property)));
        return columns;
    }

    @NonNull
    private List<String> resolveJoinTableAssociatedColumns(AnnotationMetadata annotationMetadata, boolean associationOwner, PersistentEntity entity, NamingStrategy namingStrategy) {
        List<String> joinColumns = this.getJoinedColumns(annotationMetadata, associationOwner, "referencedColumnName");
        if (!joinColumns.isEmpty()) {
            return joinColumns;
        }
        PersistentProperty identity = entity.getIdentity();
        if (identity == null) {
            throw new MappingException("Cannot have a foreign key association without an ID on entity: " + entity.getName());
        }
        ArrayList<String> columns = new ArrayList<String>();
        this.traversePersistentProperties(identity, (List<Association> associations, PersistentProperty property) -> {
            String columnName = this.getMappedName(namingStrategy, (List<Association>)associations, (PersistentProperty)property);
            columns.add(columnName);
        });
        return columns;
    }

    @NonNull
    private List<String> getJoinedColumns(AnnotationMetadata annotationMetadata, boolean associationOwner, String columnType) {
        AnnotationValue joinTable = annotationMetadata.getAnnotation(ANN_JOIN_TABLE);
        if (joinTable != null) {
            return joinTable.getAnnotations(associationOwner ? "joinColumns" : "inverseJoinColumns").stream().map(ann -> ann.stringValue(columnType).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @NonNull
    private Collection<Association> getJoinTableAssociations(PersistentEntity persistentEntity) {
        return Stream.concat(Stream.of(persistentEntity.getIdentity()), persistentEntity.getPersistentProperties().stream()).flatMap(this::flatMapEmbedded).filter(p -> {
            if (p instanceof Association) {
                Association a = (Association)p;
                return SqlQueryBuilder.isForeignKeyWithJoinTable(a);
            }
            return false;
        }).map(p -> (Association)p).collect(Collectors.toList());
    }

    @Override
    protected void selectAllColumns(AnnotationMetadata annotationMetadata, AbstractSqlLikeQueryBuilder.QueryState queryState, StringBuilder queryBuffer) {
        PersistentEntity entity = queryState.getEntity();
        this.selectAllColumns(annotationMetadata, entity, queryState.getRootAlias(), queryBuffer);
        QueryModel queryModel = queryState.getQueryModel();
        Collection<JoinPath> allPaths = queryModel.getJoinPaths();
        this.selectAllColumnsFromJoinPaths(queryState, queryBuffer, allPaths, null);
    }

    @Override
    @Internal
    protected void selectAllColumnsFromJoinPaths(AbstractSqlLikeQueryBuilder.QueryState queryState, StringBuilder queryBuffer, Collection<JoinPath> allPaths, @Nullable Map<JoinPath, String> joinAliasOverride) {
        Collection joinPaths;
        if (CollectionUtils.isNotEmpty(allPaths) && CollectionUtils.isNotEmpty((Collection)(joinPaths = (Collection)allPaths.stream().filter(jp -> jp.getJoinType().isFetch()).collect(Collectors.toList())))) {
            for (JoinPath joinPath : joinPaths) {
                Association association = joinPath.getAssociation();
                if (association instanceof Embedded) continue;
                PersistentEntity associatedEntity = association.getAssociatedEntity();
                NamingStrategy namingStrategy = this.getNamingStrategy(associatedEntity);
                String joinAlias = joinAliasOverride == null ? this.getAliasName(joinPath) : joinAliasOverride.get(joinPath);
                Objects.requireNonNull(joinAlias);
                String joinPathAlias = this.getPathOnlyAliasName(joinPath);
                queryBuffer.append(',');
                boolean includeIdentity = association.isForeignKey();
                this.traversePersistentProperties(associatedEntity, includeIdentity, true, (propertyAssociations, prop) -> {
                    String columnName = this.computePropertyPaths() ? this.getMappedName(namingStrategy, (List<Association>)propertyAssociations, (PersistentProperty)prop) : this.asPath((List<Association>)propertyAssociations, (PersistentProperty)prop);
                    String columnAlias = this.getColumnAlias((PersistentProperty)prop);
                    queryBuffer.append(joinAlias).append('.').append(queryState.shouldEscape() ? this.quote(columnName) : columnName).append(" AS ");
                    if (StringUtils.isNotEmpty((CharSequence)columnAlias)) {
                        queryBuffer.append(columnAlias);
                    } else {
                        queryBuffer.append(joinPathAlias).append(columnName);
                    }
                    queryBuffer.append(',');
                });
                queryBuffer.setLength(queryBuffer.length() - 1);
            }
        }
    }

    @Override
    public void selectAllColumns(AnnotationMetadata annotationMetadata, PersistentEntity entity, String alias, StringBuilder sb) {
        if (this.canUseWildcardForSelect(annotationMetadata, entity)) {
            this.selectAllColumns(sb, alias);
            return;
        }
        boolean escape = this.shouldEscape(entity);
        NamingStrategy namingStrategy = this.getNamingStrategy(entity);
        int length = sb.length();
        this.traversePersistentProperties(entity, (List<Association> associations, PersistentProperty property) -> {
            String transformed = this.getDataTransformerReadValue(alias, (PersistentProperty)property).orElse(null);
            String columnAlias = this.getColumnAlias((PersistentProperty)property);
            boolean useAlias = StringUtils.isNotEmpty((CharSequence)columnAlias);
            if (transformed != null) {
                sb.append(transformed).append(" AS ").append(useAlias ? columnAlias : property.getPersistedName());
            } else {
                String column = this.getMappedName(namingStrategy, (List<Association>)associations, (PersistentProperty)property);
                column = this.escapeColumnIfNeeded(column, escape);
                sb.append(alias).append('.').append(column);
                if (useAlias) {
                    sb.append(" AS ").append(columnAlias);
                }
            }
            sb.append(',');
        });
        int newLength = sb.length();
        if (newLength == length) {
            this.selectAllColumns(sb, alias);
        } else {
            sb.setLength(newLength - 1);
        }
    }

    private void selectAllColumns(StringBuilder sb, String alias) {
        if (alias != null) {
            sb.append(alias).append('.');
        }
        sb.append("*");
    }

    private String escapeColumnIfNeeded(String column, boolean escape) {
        if (escape) {
            return this.quote(column);
        }
        return column;
    }

    private boolean canUseWildcardForSelect(AnnotationMetadata annotationMetadata, PersistentEntity entity) {
        if (this.isJsonEntity(annotationMetadata, entity)) {
            return true;
        }
        return Stream.concat(Stream.of(entity.getIdentity()), entity.getPersistentProperties().stream()).flatMap(this::flatMapEmbedded).noneMatch(pp -> {
            if (pp instanceof Association) {
                Association association = (Association)pp;
                return !association.isForeignKey();
            }
            return true;
        });
    }

    private Stream<? extends PersistentProperty> flatMapEmbedded(PersistentProperty pp) {
        if (pp instanceof Embedded) {
            Embedded embedded = (Embedded)pp;
            PersistentEntity embeddedEntity = embedded.getAssociatedEntity();
            return embeddedEntity.getPersistentProperties().stream().flatMap(this::flatMapEmbedded);
        }
        return Stream.of(pp);
    }

    @Override
    public String resolveJoinType(Join.Type jt) {
        if (!this.dialect.supportsJoinType(jt)) {
            throw new IllegalArgumentException("Unsupported join type [" + jt + "] by dialect [" + this.dialect + "]");
        }
        return switch (jt) {
            case Join.Type.LEFT, Join.Type.LEFT_FETCH -> " LEFT JOIN ";
            case Join.Type.RIGHT, Join.Type.RIGHT_FETCH -> " RIGHT JOIN ";
            case Join.Type.OUTER, Join.Type.OUTER_FETCH -> " FULL OUTER JOIN ";
            default -> " INNER JOIN ";
        };
    }

    @Override
    @NonNull
    public QueryResult buildInsert(AnnotationMetadata repositoryMetadata, PersistentEntity entity) {
        String builder;
        boolean escape = this.shouldEscape(entity);
        String unescapedTableName = this.getUnescapedTableName(entity);
        ArrayList<QueryParameterBinding> parameterBindings = new ArrayList<QueryParameterBinding>();
        if (this.isJsonEntity(repositoryMetadata, entity)) {
            boolean hasGeneratedId;
            AnnotationValue entityRepresentationAnnotationValue = entity.getAnnotationMetadata().getAnnotation(EntityRepresentation.class);
            String columnName = (String)entityRepresentationAnnotationValue.getRequiredValue("column", String.class);
            final int key = 1;
            builder = INSERT_INTO + this.getTableName(entity) + " VALUES (" + this.formatParameter(key) + ")";
            boolean bl = hasGeneratedId = entity.getIdentity() != null && entity.getIdentity().isGenerated();
            if (hasGeneratedId) {
                String identityName = entity.getIdentity().getName();
                builder = "BEGIN " + builder + " RETURNING JSON_VALUE(" + columnName + ",'$." + identityName + "') INTO " + this.formatParameter(key + 1) + "; END;";
            }
            parameterBindings.add(new QueryParameterBinding(){

                @Override
                public String getKey() {
                    return String.valueOf(key);
                }

                @Override
                public DataType getDataType() {
                    return DataType.JSON;
                }

                @Override
                public JsonDataType getJsonDataType() {
                    return JsonDataType.DEFAULT;
                }

                @Override
                public int getParameterIndex() {
                    return -1;
                }
            });
        } else {
            PersistentProperty persistentProperty;
            NamingStrategy namingStrategy = this.getNamingStrategy(entity);
            Collection<? extends PersistentProperty> persistentProperties = entity.getPersistentProperties();
            ArrayList<String> columns = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            for (PersistentProperty persistentProperty2 : persistentProperties) {
                if (persistentProperty2.isGenerated()) continue;
                this.traversePersistentProperties(persistentProperty2, (List<Association> associations, PersistentProperty property) -> {
                    this.addWriteExpression(values, prop);
                    final String key = String.valueOf(values.size());
                    String[] path = this.asStringPath((List<Association>)associations, (PersistentProperty)property);
                    parameterBindings.add(new QueryParameterBinding(){
                        final /* synthetic */ PersistentProperty val$property;
                        final /* synthetic */ String[] val$path;
                        {
                            this.val$property = persistentProperty;
                            this.val$path = stringArray;
                        }

                        @Override
                        public String getKey() {
                            return key;
                        }

                        @Override
                        public DataType getDataType() {
                            return this.val$property.getDataType();
                        }

                        @Override
                        public JsonDataType getJsonDataType() {
                            return this.val$property.getJsonDataType();
                        }

                        @Override
                        public String[] getPropertyPath() {
                            return this.val$path;
                        }
                    });
                    String columnName = this.getMappedName(namingStrategy, (List<Association>)associations, (PersistentProperty)property);
                    if (escape) {
                        columnName = this.quote(columnName);
                    }
                    columns.add(columnName);
                });
            }
            final PersistentProperty version = entity.getVersion();
            if (version != null) {
                this.addWriteExpression(values, version);
                final String string = String.valueOf(values.size());
                parameterBindings.add(new QueryParameterBinding(){

                    @Override
                    public String getKey() {
                        return string;
                    }

                    @Override
                    public DataType getDataType() {
                        return version.getDataType();
                    }

                    @Override
                    public JsonDataType getJsonDataType() {
                        return null;
                    }

                    @Override
                    public String[] getPropertyPath() {
                        return new String[]{version.getName()};
                    }
                });
                String columnName = this.getMappedName(namingStrategy, Collections.emptyList(), version);
                if (escape) {
                    columnName = this.quote(columnName);
                }
                columns.add(columnName);
            }
            if ((persistentProperty = entity.getIdentity()) != null) {
                this.traversePersistentProperties(persistentProperty, (List<Association> associations, PersistentProperty property) -> {
                    Optional generated;
                    boolean isSequence = false;
                    if (this.isNotForeign((List<Association>)associations) && (generated = property.findAnnotation(GeneratedValue.class)).isPresent()) {
                        GeneratedValue.Type idGeneratorType = generated.flatMap(av -> av.enumValue(GeneratedValue.Type.class)).orElseGet(() -> this.selectAutoStrategy((PersistentProperty)property));
                        if (idGeneratorType == GeneratedValue.Type.SEQUENCE) {
                            isSequence = true;
                        } else if (this.dialect != Dialect.MYSQL || property.getDataType() != DataType.UUID) {
                            return;
                        }
                    }
                    if (isSequence) {
                        values.add(this.getSequenceStatement(unescapedTableName, (PersistentProperty)property));
                    } else {
                        this.addWriteExpression((List<String>)values, (PersistentProperty)property);
                        final String key = String.valueOf(values.size());
                        String[] path = this.asStringPath((List<Association>)associations, (PersistentProperty)property);
                        parameterBindings.add(new QueryParameterBinding(){
                            final /* synthetic */ PersistentProperty val$property;
                            final /* synthetic */ String[] val$path;
                            {
                                this.val$property = persistentProperty;
                                this.val$path = stringArray;
                            }

                            @Override
                            public String getKey() {
                                return key;
                            }

                            @Override
                            public DataType getDataType() {
                                return this.val$property.getDataType();
                            }

                            @Override
                            public JsonDataType getJsonDataType() {
                                return this.val$property.getJsonDataType();
                            }

                            @Override
                            public String[] getPropertyPath() {
                                return this.val$path;
                            }
                        });
                    }
                    String columnName = this.getMappedName(namingStrategy, (List<Association>)associations, (PersistentProperty)property);
                    if (escape) {
                        columnName = this.quote(columnName);
                    }
                    columns.add(columnName);
                });
            }
            builder = INSERT_INTO + this.getTableName(entity) + " (" + String.join((CharSequence)",", columns) + ") VALUES (" + String.join((CharSequence)String.valueOf(','), values) + ")";
        }
        return QueryResult.of(builder, Collections.emptyList(), parameterBindings, Collections.emptyMap());
    }

    private String[] asStringPath(List<Association> associations, PersistentProperty property) {
        if (associations.isEmpty()) {
            return new String[]{property.getName()};
        }
        ArrayList<String> path = new ArrayList<String>(associations.size() + 1);
        for (Association association : associations) {
            path.add(association.getName());
        }
        path.add(property.getName());
        return path.toArray(new String[0]);
    }

    private String getSequenceStatement(String unescapedTableName, PersistentProperty property) {
        String sequenceName = this.resolveSequenceName(property, unescapedTableName);
        switch (this.dialect) {
            case ORACLE: {
                return this.quote(sequenceName) + ".nextval";
            }
            case POSTGRES: {
                return "nextval('" + sequenceName + "')";
            }
            case SQL_SERVER: {
                return "NEXT VALUE FOR " + this.quote(sequenceName);
            }
        }
        throw new IllegalStateException("Cannot generate a sequence for dialect: " + this.dialect);
    }

    private String resolveSequenceName(PersistentProperty identity, String unescapedTableName) {
        return identity.getAnnotationMetadata().stringValue(GeneratedValue.class, "ref").map(n -> {
            if (StringUtils.isEmpty((CharSequence)n)) {
                return unescapedTableName + SEQ_SUFFIX;
            }
            return n;
        }).orElseGet(() -> unescapedTableName + SEQ_SUFFIX);
    }

    @Override
    @NonNull
    public QueryResult buildPagination(@NonNull Pageable pageable) {
        int size = pageable.getSize();
        if (size > 0) {
            StringBuilder builder = new StringBuilder(BLANK_SPACE);
            long from = pageable.getOffset();
            switch (this.dialect) {
                case H2: 
                case MYSQL: {
                    if (from == 0L) {
                        builder.append("LIMIT ").append(size);
                        break;
                    }
                    builder.append("LIMIT ").append(from).append(',').append(size);
                    break;
                }
                case POSTGRES: {
                    builder.append("LIMIT ").append(size).append(BLANK_SPACE);
                    if (from == 0L) break;
                    builder.append("OFFSET ").append(from);
                    break;
                }
                case SQL_SERVER: {
                    if (from == 0L) {
                        builder.append("OFFSET ").append(0).append(" ROWS ");
                    }
                }
                default: {
                    if (from != 0L) {
                        builder.append("OFFSET ").append(from).append(" ROWS ");
                    }
                    builder.append("FETCH NEXT ").append(size).append(" ROWS ONLY ");
                }
            }
            return QueryResult.of(builder.toString(), Collections.emptyList(), Collections.emptyList(), Collections.emptyMap());
        }
        return QueryResult.of("", Collections.emptyList(), Collections.emptyList(), Collections.emptyMap());
    }

    @Override
    protected String getAliasName(PersistentEntity entity) {
        return entity.getAliasName();
    }

    private String getSchemaName(PersistentEntity entity) {
        return entity.getAnnotationMetadata().stringValue(MappedEntity.class, "schema").orElseGet(() -> entity.getAnnotationMetadata().stringValue(MappedEntity.class, "schema").orElse(null));
    }

    @Override
    public String getTableName(PersistentEntity entity) {
        boolean escape = this.shouldEscape(entity);
        String tableName = entity.getPersistedName();
        String schema = this.getSchemaName(entity);
        if (StringUtils.isNotEmpty((CharSequence)schema)) {
            if (escape) {
                return this.quote(schema) + "." + this.quote(tableName);
            }
            return schema + "." + tableName;
        }
        return escape ? this.quote(tableName) : tableName;
    }

    @Override
    protected void concat(StringBuilder writer, Collection<Runnable> partsWriters) {
        if (this.dialect == Dialect.ORACLE) {
            Iterator<Runnable> iterator = partsWriters.iterator();
            while (iterator.hasNext()) {
                iterator.next().run();
                if (!iterator.hasNext()) continue;
                writer.append(" || ");
            }
        } else {
            super.concat(writer, partsWriters);
        }
    }

    private boolean addWriteExpression(List<String> values, PersistentProperty property) {
        DataType dt = property.getDataType();
        String transformer = this.getDataTransformerWriteValue(null, property).orElse(null);
        if (transformer != null) {
            return values.add(transformer);
        }
        if (dt == DataType.JSON) {
            switch (this.dialect) {
                case POSTGRES: {
                    return values.add("to_json(" + this.formatParameter(values.size() + 1).getName() + "::json)");
                }
                case H2: {
                    return values.add(this.formatParameter(values.size() + 1).getName() + " FORMAT JSON");
                }
                case MYSQL: {
                    return values.add("CONVERT(" + this.formatParameter(values.size() + 1).getName() + " USING UTF8MB4)");
                }
            }
            return values.add(this.formatParameter(values.size() + 1).getName());
        }
        return values.add(this.formatParameter(values.size() + 1).getName());
    }

    @Override
    protected void appendUpdateSetParameter(StringBuilder sb, String alias, PersistentProperty prop, Runnable appendParameter) {
        String transformed = this.getDataTransformerWriteValue(alias, prop).orElse(null);
        if (transformed != null) {
            this.appendTransformed(sb, transformed, appendParameter);
            return;
        }
        if (prop.getDataType() == DataType.JSON) {
            switch (this.dialect) {
                case H2: {
                    appendParameter.run();
                    sb.append(" FORMAT JSON");
                    break;
                }
                case MYSQL: {
                    sb.append("CONVERT(");
                    appendParameter.run();
                    sb.append(" USING UTF8MB4)");
                    break;
                }
                case POSTGRES: {
                    sb.append("to_json(");
                    appendParameter.run();
                    sb.append("::json)");
                    break;
                }
                default: {
                    super.appendUpdateSetParameter(sb, alias, prop, appendParameter);
                    break;
                }
            }
        } else {
            super.appendUpdateSetParameter(sb, alias, prop, appendParameter);
        }
    }

    @Override
    protected String[] buildJoin(String alias, JoinPath joinPath, String joinType, StringBuilder target, Map<String, String> appliedJoinPaths, AbstractSqlLikeQueryBuilder.QueryState queryState) {
        Object[] associationPath = joinPath.getAssociationPath();
        if (ArrayUtils.isEmpty((Object[])associationPath)) {
            throw new IllegalArgumentException("Invalid association path [" + joinPath.getPath() + "]");
        }
        ArrayList<Association> joinAssociationsPath = new ArrayList<Association>(associationPath.length);
        String[] joinAliases = new String[associationPath.length];
        StringJoiner pathSoFar = new StringJoiner(".");
        String joinAlias = alias;
        for (int i = 0; i < associationPath.length; ++i) {
            Object association = associationPath[i];
            pathSoFar.add(association.getName());
            if (association instanceof Embedded) {
                joinAssociationsPath.add((Association)association);
                continue;
            }
            String currentPath = pathSoFar.toString();
            String existingAlias = appliedJoinPaths.get(currentPath);
            if (existingAlias != null) {
                joinAliases[i] = existingAlias;
                joinAlias = existingAlias;
            } else {
                PersistentEntity associatedEntity = association.getAssociatedEntity();
                int finalI = i;
                JoinPath joinPathToUse = queryState.getQueryModel().getJoinPath(currentPath).orElseGet(() -> SqlQueryBuilder.lambda$buildJoin$42(currentPath, (Association[])associationPath, finalI, joinPath));
                joinAliases[i] = this.getAliasName(joinPathToUse);
                String currentJoinAlias = joinAliases[i];
                this.buildJoin(joinType, target, queryState, joinAssociationsPath, joinAlias, (Association)association, associatedEntity, this.findOwner(joinAssociationsPath, (PersistentProperty)association).orElseGet(queryState::getEntity), currentJoinAlias);
                String additionalWhere = this.resolveWhereForAnnotationMetadata(currentJoinAlias, associatedEntity.getAnnotationMetadata());
                if (StringUtils.isNotEmpty((CharSequence)additionalWhere)) {
                    target.append(" AND ").append(additionalWhere);
                }
                joinAlias = currentJoinAlias;
            }
            joinAssociationsPath.clear();
        }
        return joinAliases;
    }

    protected void buildJoin(String joinType, StringBuilder sb, AbstractSqlLikeQueryBuilder.QueryState queryState, List<Association> joinAssociationsPath, String joinAlias, Association association, PersistentEntity associatedEntity, PersistentEntity associationOwner, String currentJoinAlias) {
        boolean escape = this.shouldEscape(associationOwner);
        String mappedBy = association.getAnnotationMetadata().stringValue(Relation.class, "mappedBy").orElse(null);
        if (association.getKind() == Relation.Kind.MANY_TO_MANY || association.isForeignKey() && StringUtils.isEmpty((CharSequence)mappedBy)) {
            PersistentProperty identity = associatedEntity.getIdentity();
            if (identity == null) {
                throw new IllegalArgumentException("Associated entity [" + associatedEntity.getName() + "] defines no ID. Cannot join.");
            }
            PersistentProperty associatedId = associationOwner.getIdentity();
            if (associatedId == null) {
                throw new MappingException("Cannot join on entity [" + associationOwner.getName() + "] that has no declared ID");
            }
            Optional<Association> inverseSide = association.getInverseSide().map(Function.identity());
            Association owningAssociation = inverseSide.orElse(association);
            boolean isAssociationOwner = !association.getInverseSide().isPresent();
            NamingStrategy namingStrategy = associationOwner.getNamingStrategy();
            AnnotationMetadata annotationMetadata = owningAssociation.getAnnotationMetadata();
            List<String> ownerJoinColumns = this.resolveJoinTableAssociatedColumns(annotationMetadata, isAssociationOwner, associationOwner, namingStrategy);
            List<String> ownerJoinTableColumns = this.resolveJoinTableJoinColumns(annotationMetadata, isAssociationOwner, associationOwner, namingStrategy);
            List<String> associationJoinColumns = this.resolveJoinTableAssociatedColumns(annotationMetadata, !isAssociationOwner, associatedEntity, namingStrategy);
            List<String> associationJoinTableColumns = this.resolveJoinTableJoinColumns(annotationMetadata, !isAssociationOwner, associatedEntity, namingStrategy);
            if (escape) {
                ownerJoinColumns = ownerJoinColumns.stream().map(this::quote).collect(Collectors.toList());
                ownerJoinTableColumns = ownerJoinTableColumns.stream().map(this::quote).collect(Collectors.toList());
                associationJoinColumns = associationJoinColumns.stream().map(this::quote).collect(Collectors.toList());
                associationJoinTableColumns = associationJoinTableColumns.stream().map(this::quote).collect(Collectors.toList());
            }
            String joinTableName = annotationMetadata.stringValue(ANN_JOIN_TABLE, "name").orElseGet(() -> this.getMappedName(namingStrategy, association));
            String joinTableAlias = annotationMetadata.stringValue(ANN_JOIN_TABLE, "alias").orElseGet(() -> currentJoinAlias + joinTableName + "_");
            this.join(sb, queryState.getQueryModel(), joinType, escape ? this.quote(joinTableName) : joinTableName, joinTableAlias, joinAlias, ownerJoinColumns, ownerJoinTableColumns);
            sb.append(' ');
            this.join(sb, queryState.getQueryModel(), joinType, this.getTableName(associatedEntity), currentJoinAlias, joinTableAlias, associationJoinTableColumns, associationJoinColumns);
        } else if (StringUtils.isNotEmpty((CharSequence)mappedBy)) {
            PersistentProperty ownerIdentity = associationOwner.getIdentity();
            if (ownerIdentity == null) {
                throw new IllegalArgumentException("Associated entity [" + associationOwner + "] defines no ID. Cannot join.");
            }
            PersistentPropertyPath mappedByPropertyPath = associatedEntity.getPropertyPath(mappedBy);
            if (mappedByPropertyPath == null) {
                throw new MappingException("Foreign key association with mappedBy references a property that doesn't exist [" + mappedBy + "] of entity: " + associatedEntity.getName());
            }
            this.join(sb, joinType, queryState, associatedEntity, associationOwner, joinAlias, currentJoinAlias, joinAssociationsPath, ownerIdentity, mappedByPropertyPath.getAssociations(), mappedByPropertyPath.getProperty());
        } else {
            PersistentProperty associatedProperty = association.getAssociatedEntity().getIdentity();
            if (associatedProperty == null) {
                throw new IllegalArgumentException("Associated entity [" + association.getAssociatedEntity().getName() + "] defines no ID. Cannot join.");
            }
            this.join(sb, joinType, queryState, associatedEntity, associationOwner, joinAlias, currentJoinAlias, joinAssociationsPath, association, Collections.emptyList(), associatedProperty);
        }
    }

    private void join(StringBuilder sb, String joinType, AbstractSqlLikeQueryBuilder.QueryState queryState, PersistentEntity associatedEntity, PersistentEntity associationOwner, String leftTableAlias, String rightTableAlias, List<Association> leftPropertyAssociations, PersistentProperty leftProperty, List<Association> rightPropertyAssociations, PersistentProperty rightProperty) {
        boolean escape = this.shouldEscape(associationOwner);
        ArrayList<String> onLeftColumns = new ArrayList<String>();
        ArrayList<String> onRightColumns = new ArrayList<String>();
        Association association = null;
        if (leftProperty instanceof Association) {
            association = (Association)leftProperty;
        } else if (rightProperty instanceof Association) {
            association = (Association)rightProperty;
        }
        if (association != null) {
            Optional<Association> inverse = association.getInverseSide().map(Function.identity());
            Association owner = inverse.orElse(association);
            boolean isOwner = leftProperty == owner;
            AnnotationValue joinColumnsHolder = owner.getAnnotationMetadata().getAnnotation(ANN_JOIN_COLUMNS);
            if (joinColumnsHolder != null) {
                onLeftColumns.addAll(joinColumnsHolder.getAnnotations("value").stream().map(ann -> ann.stringValue(isOwner ? "name" : "referencedColumnName").orElse(null)).filter(Objects::nonNull).collect(Collectors.toList()));
                onRightColumns.addAll(joinColumnsHolder.getAnnotations("value").stream().map(ann -> ann.stringValue(isOwner ? "referencedColumnName" : "name").orElse(null)).filter(Objects::nonNull).collect(Collectors.toList()));
            }
        }
        if (onLeftColumns.isEmpty()) {
            this.traversePersistentProperties(leftProperty, (List<Association> associations, PersistentProperty p) -> {
                String column = this.getMappedName(this.getNamingStrategy(leftProperty.getOwner()), this.merge((List)leftPropertyAssociations, (List)associations), (PersistentProperty)p);
                onLeftColumns.add(column);
            });
            if (onLeftColumns.isEmpty()) {
                throw new MappingException("Cannot join on entity [" + leftProperty.getOwner().getName() + "] that has no declared ID");
            }
        }
        if (onRightColumns.isEmpty()) {
            this.traversePersistentProperties(rightProperty, (List<Association> associations, PersistentProperty p) -> {
                String column = this.getMappedName(this.getNamingStrategy(rightProperty.getOwner()), this.merge((List)rightPropertyAssociations, (List)associations), (PersistentProperty)p);
                onRightColumns.add(column);
            });
        }
        this.join(sb, queryState.getQueryModel(), joinType, this.getTableName(associatedEntity), rightTableAlias, leftTableAlias, escape ? onLeftColumns.stream().map(this::quote).collect(Collectors.toList()) : onLeftColumns, escape ? onRightColumns.stream().map(this::quote).collect(Collectors.toList()) : onRightColumns);
    }

    private Optional<PersistentEntity> findOwner(List<Association> associations, PersistentProperty property) {
        PersistentEntity owner = property.getOwner();
        if (!owner.isEmbeddable()) {
            return Optional.of(owner);
        }
        ListIterator<Association> listIterator = associations.listIterator(associations.size());
        while (listIterator.hasPrevious()) {
            Association association = listIterator.previous();
            if (association.getOwner().isEmbeddable()) continue;
            return Optional.of(association.getOwner());
        }
        return Optional.empty();
    }

    private void join(StringBuilder sb, QueryModel queryModel, String joinType, String tableName, String tableAlias, String onTableName, String onTableColumn, String tableColumnName) {
        sb.append(joinType).append(tableName).append(' ').append(tableAlias);
        this.appendForUpdate(AbstractSqlLikeQueryBuilder.QueryPosition.AFTER_TABLE_NAME, queryModel, sb);
        sb.append(" ON ").append(onTableName).append('.').append(onTableColumn).append('=').append(tableAlias).append('.').append(tableColumnName);
    }

    private void join(StringBuilder builder, QueryModel queryModel, String joinType, String tableName, String tableAlias, String onTableName, List<String> onLeftColumns, List<String> onRightColumns) {
        if (onLeftColumns.size() != onRightColumns.size()) {
            throw new IllegalStateException("Un-matching join columns size: " + onLeftColumns.size() + " != " + onRightColumns.size() + BLANK_SPACE + onLeftColumns + ", " + onRightColumns);
        }
        builder.append(joinType).append(tableName).append(' ').append(tableAlias);
        this.appendForUpdate(AbstractSqlLikeQueryBuilder.QueryPosition.AFTER_TABLE_NAME, queryModel, builder);
        builder.append(" ON ");
        for (int i = 0; i < onLeftColumns.size(); ++i) {
            String leftColumn = onLeftColumns.get(i);
            String rightColumn = onRightColumns.get(i);
            builder.append(onTableName).append('.').append(leftColumn).append('=').append(tableAlias).append('.').append(rightColumn);
            if (i + 1 == onLeftColumns.size()) continue;
            builder.append(" AND ");
        }
    }

    private <T> List<T> merge(List<T> left, List<T> right) {
        if (left.isEmpty()) {
            return right;
        }
        if (right.isEmpty()) {
            return left;
        }
        ArrayList<T> associations = new ArrayList<T>(left.size() + right.size());
        associations.addAll(left);
        associations.addAll(right);
        return associations;
    }

    @Override
    protected String quote(String persistedName) {
        switch (this.dialect) {
            case H2: 
            case MYSQL: {
                return "`" + persistedName + "`";
            }
            case SQL_SERVER: {
                return "[" + persistedName + "]";
            }
            case ORACLE: {
                return "\"" + persistedName.toUpperCase(Locale.ENGLISH) + "\"";
            }
        }
        return "\"" + persistedName + "\"";
    }

    @Override
    public String getColumnName(PersistentProperty persistentProperty) {
        return persistentProperty.getPersistedName();
    }

    @Override
    protected void appendProjectionRowCount(StringBuilder queryString, String logicalName) {
        queryString.append("COUNT").append('(').append('*').append(')');
    }

    @Override
    protected void appendForUpdate(AbstractSqlLikeQueryBuilder.QueryPosition queryPosition, QueryModel query, StringBuilder queryBuilder) {
        boolean isSqlServer;
        if (query.isForUpdate() && ((isSqlServer = Dialect.SQL_SERVER.equals((Object)this.dialect)) && queryPosition.equals((Object)AbstractSqlLikeQueryBuilder.QueryPosition.AFTER_TABLE_NAME) || !isSqlServer && queryPosition.equals((Object)AbstractSqlLikeQueryBuilder.QueryPosition.END_OF_QUERY))) {
            queryBuilder.append(isSqlServer ? SQL_SERVER_FOR_UPDATE_CLAUSE : STANDARD_FOR_UPDATE_CLAUSE);
        }
    }

    @Override
    protected boolean computePropertyPaths() {
        return true;
    }

    @Override
    protected boolean isAliasForBatch(PersistentEntity persistentEntity, AnnotationMetadata annotationMetadata) {
        return this.isJsonEntity(annotationMetadata, persistentEntity);
    }

    @Override
    public AbstractSqlLikeQueryBuilder.Placeholder formatParameter(int index) {
        DialectConfig dialectConfig = this.perDialectConfig.get((Object)this.dialect);
        String name = dialectConfig != null && dialectConfig.positionalNameFormatter != null ? String.format(dialectConfig.positionalNameFormatter, index) : String.valueOf(index);
        if (dialectConfig != null && dialectConfig.positionalFormatter != null) {
            return new AbstractSqlLikeQueryBuilder.Placeholder(String.format(dialectConfig.positionalFormatter, name), name);
        }
        return new AbstractSqlLikeQueryBuilder.Placeholder(DEFAULT_POSITIONAL_PARAMETER_MARKER, name);
    }

    protected GeneratedValue.Type selectAutoStrategy(PersistentProperty property) {
        if (property.getDataType() == DataType.UUID) {
            return GeneratedValue.Type.UUID;
        }
        if (this.dialect == Dialect.ORACLE) {
            return GeneratedValue.Type.SEQUENCE;
        }
        return GeneratedValue.Type.AUTO;
    }

    @Override
    public boolean supportsForUpdate() {
        return true;
    }

    @Override
    public Dialect dialect() {
        return this.dialect;
    }

    @Override
    public String positionalParameterFormat() {
        DialectConfig dialectConfig = this.perDialectConfig.get((Object)this.dialect);
        if (dialectConfig != null && dialectConfig.positionalFormatter != null) {
            return dialectConfig.positionalFormatter;
        }
        return DEFAULT_POSITIONAL_PARAMETER_MARKER;
    }

    @Override
    public String positionalParameterName() {
        DialectConfig dialectConfig = this.perDialectConfig.get((Object)this.dialect);
        if (dialectConfig != null && dialectConfig.positionalNameFormatter != null) {
            return dialectConfig.positionalNameFormatter;
        }
        return "";
    }

    public Pattern positionalParameterPattern() {
        if (this.positionalParameterPattern == null) {
            String positionalParameterFormat = this.positionalParameterFormat();
            boolean messageFormat = positionalParameterFormat.endsWith("%s");
            if (messageFormat) {
                Object pattern = positionalParameterFormat.substring(0, positionalParameterFormat.length() - 2);
                pattern = Pattern.quote((String)pattern) + "\\d";
                this.positionalParameterPattern = Pattern.compile((String)pattern);
            } else {
                this.positionalParameterPattern = Pattern.compile(Pattern.quote(positionalParameterFormat));
            }
        }
        return this.positionalParameterPattern;
    }

    @Override
    public boolean escapeQueries() {
        DialectConfig dialectConfig = this.perDialectConfig.get((Object)this.dialect);
        if (dialectConfig != null && dialectConfig.escapeQueries != null) {
            return dialectConfig.escapeQueries;
        }
        return true;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return SqlQueryConfiguration.DialectConfiguration.class;
    }

    private static /* synthetic */ JoinPath lambda$buildJoin$42(String currentPath, Association[] associationPath, int finalI, JoinPath joinPath) {
        return new JoinPath(currentPath, Arrays.copyOfRange(associationPath, 0, finalI + 1), joinPath.getJoinType(), joinPath.getAlias().orElse(null));
    }

    private static class DialectConfig {
        Boolean escapeQueries;
        String positionalFormatter;
        String positionalNameFormatter;

        private DialectConfig() {
        }
    }

    private static class IndexConfiguration {
        AnnotationValue<?> index;
        String tableName;
        String unquotedTableName;

        public IndexConfiguration(AnnotationValue<?> index, String tableName, String unquotedTableName) {
            this.index = index;
            this.tableName = tableName;
            this.unquotedTableName = unquotedTableName;
        }
    }
}

