/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.operations.async;

import io.micronaut.core.annotation.NonBlocking;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.annotation.SingleResult;
import io.micronaut.data.model.Page;
import io.micronaut.data.model.runtime.DeleteBatchOperation;
import io.micronaut.data.model.runtime.DeleteOperation;
import io.micronaut.data.model.runtime.InsertBatchOperation;
import io.micronaut.data.model.runtime.InsertOperation;
import io.micronaut.data.model.runtime.PagedQuery;
import io.micronaut.data.model.runtime.PreparedQuery;
import io.micronaut.data.model.runtime.UpdateBatchOperation;
import io.micronaut.data.model.runtime.UpdateOperation;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;

@NonBlocking
public interface AsyncRepositoryOperations {
    @NonNull
    public Executor getExecutor();

    @NonNull
    public <T> CompletionStage<T> findOne(@NonNull Class<T> var1, @NonNull Object var2);

    public <T> CompletionStage<Boolean> exists(@NonNull PreparedQuery<T, Boolean> var1);

    @NonNull
    public <T, R> CompletionStage<R> findOne(@NonNull PreparedQuery<T, R> var1);

    @NonNull
    public <T> CompletionStage<T> findOptional(@NonNull Class<T> var1, @NonNull Object var2);

    @NonNull
    public <T, R> CompletionStage<R> findOptional(@NonNull PreparedQuery<T, R> var1);

    @NonNull
    public <T> CompletionStage<Iterable<T>> findAll(PagedQuery<T> var1);

    @NonNull
    public <T> CompletionStage<Long> count(PagedQuery<T> var1);

    @NonNull
    public <T, R> CompletionStage<Iterable<R>> findAll(@NonNull PreparedQuery<T, R> var1);

    @NonNull
    public <T> CompletionStage<T> persist(@NonNull InsertOperation<T> var1);

    @NonNull
    public <T> CompletionStage<T> update(@NonNull UpdateOperation<T> var1);

    @NonNull
    default public <T> CompletionStage<Iterable<T>> updateAll(@NonNull UpdateBatchOperation<T> operation) {
        throw new UnsupportedOperationException("The updateAll is required to be implemented.");
    }

    @SingleResult
    @NonNull
    public <T> CompletionStage<Number> delete(@NonNull DeleteOperation<T> var1);

    @NonNull
    public <T> CompletionStage<Iterable<T>> persistAll(@NonNull InsertBatchOperation<T> var1);

    @NonNull
    public CompletionStage<Number> executeUpdate(@NonNull PreparedQuery<?, Number> var1);

    @NonNull
    default public CompletionStage<Number> executeDelete(@NonNull PreparedQuery<?, Number> preparedQuery) {
        return this.executeUpdate(preparedQuery);
    }

    @NonNull
    public <T> CompletionStage<Number> deleteAll(@NonNull DeleteBatchOperation<T> var1);

    @NonNull
    public <R> CompletionStage<Page<R>> findPage(@NonNull PagedQuery<R> var1);
}

