/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder.sql.validation;

import io.micronaut.core.util.StringUtils;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.validation.SchemaValidationException;
import io.micronaut.data.model.query.builder.sql.validation.SqlTableMappingValidator;
import io.micronaut.data.model.schema.sql.SqlColumnMapping;
import io.micronaut.data.model.schema.sql.SqlDbType;
import io.micronaut.data.model.schema.sql.SqlTableMapping;
import io.micronaut.data.model.schema.sql.metadata.SqlColumnMetadata;
import io.micronaut.data.model.schema.sql.metadata.SqlTableMetadata;
import java.util.ArrayList;
import java.util.List;

abstract class BaseSqlTableMappingValidator
implements SqlTableMappingValidator {
    BaseSqlTableMappingValidator() {
    }

    @Override
    public final void validateTable(SqlTableMapping tableMapping, SqlTableMetadata tableMetadata) {
        List<SqlColumnMapping> primaryKeyColumns = tableMapping.primaryKeyColumns();
        List<SqlColumnMapping> columns = tableMapping.columns();
        ArrayList<SqlColumnMapping> allColumns = new ArrayList<SqlColumnMapping>(columns.size() + (primaryKeyColumns != null ? primaryKeyColumns.size() : 0));
        if (primaryKeyColumns != null) {
            allColumns.addAll(primaryKeyColumns);
        }
        allColumns.addAll(columns);
        for (SqlColumnMapping columnMapping : allColumns) {
            String name = columnMapping.getName();
            SqlColumnMetadata columnMetadata = tableMetadata.getColumn(name.toLowerCase());
            if (columnMetadata == null) {
                throw new SchemaValidationException("Schema validation failed. Column [" + name + "] not found in the table [" + tableMapping.name() + "]");
            }
            this.validateColumn(columnMapping, columnMetadata, this.getSupportedDialect(), tableMetadata.getName());
        }
    }

    protected final boolean matchingColumnType(SqlColumnMapping columnMapping, SqlColumnMetadata columnMetadata, Dialect dialect) {
        if (BaseSqlTableMappingValidator.matchingColumnTypes(columnMapping.getDbType(), columnMetadata.type())) {
            return true;
        }
        String sqlType = columnMapping.getSqlType(dialect);
        if (sqlType.equalsIgnoreCase(columnMetadata.typeName())) {
            return true;
        }
        return this.matchingDialectColumnType(columnMapping, columnMetadata);
    }

    protected boolean matchingDialectColumnType(SqlColumnMapping columnMapping, SqlColumnMetadata columnMetadata) {
        return false;
    }

    protected static boolean uuidMatchesVarchar(SqlColumnMetadata columnMetadata) {
        return columnMetadata.type() == 12 && columnMetadata.columnSize() == 36;
    }

    protected static boolean isFloatOrRealOrDouble(int typeCode) {
        return switch (typeCode) {
            case 6, 7, 8 -> true;
            default -> false;
        };
    }

    private void validateColumn(SqlColumnMapping columnMapping, SqlColumnMetadata columnMetadata, Dialect dialect, String tableName) {
        if (StringUtils.isNotEmpty((CharSequence)columnMapping.getDefinition())) {
            return;
        }
        if (this.matchingColumnType(columnMapping, columnMetadata, dialect)) {
            return;
        }
        throw new SchemaValidationException(String.format("Schema validation failed. Column [%s] in table [%s] of type [%s] is mapped to [%s].", new Object[]{columnMetadata.name(), tableName, columnMetadata.typeName(), columnMapping.getDbType()}));
    }

    private static boolean matchingColumnTypes(SqlDbType dbType, int typeCode) {
        int mappedTypeCode = dbType.getType();
        return mappedTypeCode == typeCode || BaseSqlTableMappingValidator.isCompatibleIntegralType(mappedTypeCode, typeCode) || BaseSqlTableMappingValidator.isNumericOrDecimal(mappedTypeCode) && BaseSqlTableMappingValidator.isNumericOrDecimal(typeCode) || BaseSqlTableMappingValidator.isFloatOrRealOrDouble(mappedTypeCode) && BaseSqlTableMappingValidator.isFloatOrRealOrDouble(typeCode) || BaseSqlTableMappingValidator.isVarcharType(mappedTypeCode) && BaseSqlTableMappingValidator.isVarcharType(typeCode) || BaseSqlTableMappingValidator.isVarbinaryType(mappedTypeCode) && BaseSqlTableMappingValidator.isVarbinaryType(typeCode) || BaseSqlTableMappingValidator.isEnumType(mappedTypeCode) && BaseSqlTableMappingValidator.isVarcharType(typeCode);
    }

    private static boolean isCompatibleIntegralType(int typeCode1, int typeCode2) {
        return switch (typeCode1) {
            case -6 -> {
                if (typeCode2 == -6 || typeCode2 == 5 || typeCode2 == 4 || typeCode2 == -5) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (typeCode2 == 5 || typeCode2 == 4 || typeCode2 == -5) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                if (typeCode2 == 4 || typeCode2 == -5) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static boolean isNumericOrDecimal(int typeCode) {
        return switch (typeCode) {
            case 2, 3 -> true;
            default -> false;
        };
    }

    private static boolean isVarcharType(int typeCode) {
        return switch (typeCode) {
            case -16, -9, -1, 12 -> true;
            default -> false;
        };
    }

    private static boolean isVarbinaryType(int typeCode) {
        return switch (typeCode) {
            case -4, -3 -> true;
            default -> false;
        };
    }

    private static boolean isEnumType(int typeCode) {
        return typeCode == SqlDbType.ENUM.getType();
    }
}

