/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.query.builder.sql;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Creator;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.data.annotation.EntityRepresentation;
import io.micronaut.data.annotation.GeneratedValue;
import io.micronaut.data.annotation.Join;
import io.micronaut.data.annotation.Relation;
import io.micronaut.data.annotation.Repository;
import io.micronaut.data.annotation.sql.JoinColumns;
import io.micronaut.data.exceptions.DataAccessException;
import io.micronaut.data.exceptions.MappingException;
import io.micronaut.data.model.Association;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.JsonDataType;
import io.micronaut.data.model.PersistentAssociationPath;
import io.micronaut.data.model.PersistentEntity;
import io.micronaut.data.model.PersistentEntityUtils;
import io.micronaut.data.model.PersistentProperty;
import io.micronaut.data.model.PersistentPropertyPath;
import io.micronaut.data.model.jpa.criteria.impl.DefaultOrder;
import io.micronaut.data.model.jpa.criteria.impl.DefaultPersistentPropertyPath;
import io.micronaut.data.model.naming.NamingStrategy;
import io.micronaut.data.model.query.JoinPath;
import io.micronaut.data.model.query.builder.QueryBuilder2;
import io.micronaut.data.model.query.builder.QueryParameterBinding;
import io.micronaut.data.model.query.builder.QueryResult;
import io.micronaut.data.model.query.builder.sql.AbstractSqlLikeQueryBuilder2;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.query.builder.sql.SqlQueryBuilderUtils;
import io.micronaut.data.model.query.builder.sql.SqlQueryConfiguration;
import io.micronaut.data.model.query.builder.sql.SqlSchemaUtils;
import io.micronaut.data.model.schema.sql.SqlColumnMapping;
import io.micronaut.data.model.schema.sql.SqlIndexMapping;
import io.micronaut.data.model.schema.sql.SqlSequenceMapping;
import io.micronaut.data.model.schema.sql.SqlTableMapping;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Selection;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class SqlQueryBuilder2
extends AbstractSqlLikeQueryBuilder2 {
    public static final String DEFAULT_POSITIONAL_PARAMETER_MARKER = "?";
    public static final String STANDARD_FOR_UPDATE_CLAUSE = " FOR UPDATE";
    public static final String SQL_SERVER_FOR_UPDATE_CLAUSE = " WITH (UPDLOCK, ROWLOCK)";
    private static final String VALUE_MEMBER = "value";
    private static final String BLANK_SPACE = " ";
    private static final String INSERT_INTO = "INSERT INTO ";
    private static final String JDBC_REPO_ANNOTATION = "io.micronaut.data.jdbc.annotation.JdbcRepository";
    private static final String DIALECT_ATTR = "dialect";
    private static final String REFERENCED_COLUMN_NAME = "referencedColumnName";
    private static final Logger LOG = LoggerFactory.getLogger(SqlQueryBuilder2.class);
    private final Dialect dialect;
    private final Map<Dialect, DialectConfig> perDialectConfig = new EnumMap<Dialect, DialectConfig>(Dialect.class);

    @Creator
    public SqlQueryBuilder2(AnnotationMetadata annotationMetadata) {
        if (annotationMetadata != null) {
            this.dialect = annotationMetadata.enumValue(JDBC_REPO_ANNOTATION, DIALECT_ATTR, Dialect.class).orElseGet(() -> annotationMetadata.enumValue(Repository.class, DIALECT_ATTR, Dialect.class).orElse(Dialect.ANSI));
            AnnotationValue annotation = annotationMetadata.getAnnotation(SqlQueryConfiguration.class);
            if (annotation != null) {
                List dialectConfigs = annotation.getAnnotations(VALUE_MEMBER, SqlQueryConfiguration.DialectConfiguration.class);
                for (AnnotationValue dialectConfig : dialectConfigs) {
                    dialectConfig.enumValue(DIALECT_ATTR, Dialect.class).ifPresent(aDialect -> {
                        DialectConfig dc = new DialectConfig();
                        this.perDialectConfig.put((Dialect)((Object)aDialect), dc);
                        dialectConfig.stringValue("positionalParameterFormat").ifPresent(format -> {
                            dc.positionalFormatter = format;
                        });
                        dialectConfig.stringValue("positionalParameterName").ifPresent(format -> {
                            dc.positionalNameFormatter = format;
                        });
                        dialectConfig.booleanValue("escapeQueries").ifPresent(escape -> {
                            dc.escapeQueries = escape;
                        });
                    });
                }
            }
        } else {
            this.dialect = Dialect.ANSI;
        }
    }

    public SqlQueryBuilder2() {
        this.dialect = Dialect.ANSI;
    }

    public SqlQueryBuilder2(Dialect dialect) {
        ArgumentUtils.requireNonNull((String)DIALECT_ATTR, (Object)((Object)dialect));
        this.dialect = dialect;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    protected boolean shouldEscape(@NonNull PersistentEntity entity) {
        Boolean shouldEscapeDialect = this.shouldEscapeDialect(this.dialect);
        return Objects.requireNonNullElseGet(shouldEscapeDialect, () -> super.shouldEscape(entity));
    }

    @Nullable
    private Boolean shouldEscapeDialect(Dialect dialect) {
        DialectConfig config = this.perDialectConfig.get((Object)dialect);
        if (config != null && config.escapeQueries != null) {
            return config.escapeQueries;
        }
        return null;
    }

    @Override
    protected String asLiteral(Object value) {
        if ((this.dialect == Dialect.SQL_SERVER || this.dialect == Dialect.ORACLE) && value instanceof Boolean) {
            Boolean vBoolean = (Boolean)value;
            return vBoolean != false ? "1" : "0";
        }
        return super.asLiteral(value);
    }

    @NonNull
    public String buildBatchCreateTableStatement(PersistentEntity ... entities) {
        return Arrays.stream(entities).flatMap(entity -> Stream.of(this.buildCreateTableStatements((PersistentEntity)entity))).collect(Collectors.joining(System.lineSeparator()));
    }

    @NonNull
    public String buildBatchDropTableStatement(PersistentEntity ... entities) {
        return Arrays.stream(entities).flatMap(entity -> Stream.of(this.buildDropTableStatements((PersistentEntity)entity))).collect(Collectors.joining("\n"));
    }

    @NonNull
    public String[] buildDropTableStatements(@NonNull PersistentEntity entity) {
        String tableName = this.getTableName(entity);
        boolean escape = this.shouldEscape(entity);
        String sql = "DROP TABLE " + tableName;
        Collection<Association> foreignKeyAssociations = SqlQueryBuilderUtils.getJoinTableAssociations(entity);
        ArrayList<CallSite> dropStatements = new ArrayList<CallSite>();
        for (Association association : foreignKeyAssociations) {
            AnnotationMetadata associationMetadata = association.getAnnotationMetadata();
            NamingStrategy namingStrategy = this.getNamingStrategy(entity);
            String joinTableName = associationMetadata.stringValue("io.micronaut.data.annotation.sql.JoinTable", "name").orElseGet(() -> this.getMappedName(namingStrategy, association));
            dropStatements.add((CallSite)((Object)("DROP TABLE " + (escape ? this.quote(joinTableName, true) : joinTableName) + ";")));
        }
        dropStatements.add((CallSite)((Object)sql));
        return dropStatements.toArray(new String[0]);
    }

    @NonNull
    public String buildJoinTableInsert(@NonNull PersistentEntity entity, @NonNull Association association) {
        if (!SqlQueryBuilder2.isForeignKeyWithJoinTable(association)) {
            throw new IllegalArgumentException("Join table inserts can only be built for foreign key associations that are mapped with a join table.");
        }
        Optional<Association> inverseSide = association.getInverseSide().map(Function.identity());
        Association owningAssociation = inverseSide.orElse(association);
        AnnotationMetadata annotationMetadata = owningAssociation.getAnnotationMetadata();
        NamingStrategy namingStrategy = this.getNamingStrategy(entity);
        Object joinTableName = annotationMetadata.stringValue("io.micronaut.data.annotation.sql.JoinTable", "name").orElseGet(() -> this.getMappedName(namingStrategy, association));
        joinTableName = this.quote((String)joinTableName, true);
        String joinTableSchema = annotationMetadata.stringValue("io.micronaut.data.annotation.sql.JoinTable", "schema").orElse(SqlQueryBuilderUtils.getSchemaName(entity));
        if (StringUtils.isNotEmpty((CharSequence)joinTableSchema)) {
            joinTableSchema = this.quote(joinTableSchema, true);
            joinTableName = joinTableSchema + "." + (String)joinTableName;
        }
        List<String> leftJoinColumns = SqlQueryBuilderUtils.resolveJoinTableJoinColumns(annotationMetadata, true, entity, namingStrategy);
        List<String> rightJoinColumns = SqlQueryBuilderUtils.resolveJoinTableJoinColumns(annotationMetadata, false, association.getAssociatedEntity(), namingStrategy);
        boolean escape = this.shouldEscape(entity);
        String columns = Stream.concat(leftJoinColumns.stream(), rightJoinColumns.stream()).map(columnName -> escape ? this.quote((String)columnName) : columnName).collect(Collectors.joining(","));
        String placeholders = IntStream.range(0, leftJoinColumns.size() + rightJoinColumns.size()).mapToObj(i -> this.formatParameter(i + 1).toString()).collect(Collectors.joining(","));
        return INSERT_INTO + (String)joinTableName + " (" + columns + ") VALUES (" + placeholders + ")";
    }

    public static boolean isForeignKeyWithJoinTable(@NonNull Association association) {
        return SqlQueryBuilderUtils.isForeignKeyWithJoinTable(association);
    }

    @NonNull
    public String[] buildCreateTableStatements(@NonNull PersistentEntity entity) {
        List<SqlTableMapping> tables = SqlSchemaUtils.getSqlTableMappings(entity);
        assert (CollectionUtils.isNotEmpty(tables));
        boolean escape = this.shouldEscape(entity);
        String schema = SqlQueryBuilderUtils.getSchemaName(entity);
        ArrayList<String> createStatements = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)schema)) {
            createStatements.add("CREATE SCHEMA " + (escape ? this.quote(schema, true) : schema) + ";");
        }
        for (SqlTableMapping table : tables) {
            this.addTableCreateStatements(createStatements, table, schema, escape);
        }
        return createStatements.toArray(new String[0]);
    }

    @NonNull
    public String[] buildCreateTableStatements(PersistentEntity[] entities) {
        LinkedHashMap sqlTableMappingByTableName = CollectionUtils.newLinkedHashMap((int)entities.length);
        ArrayList<String> createStatements = new ArrayList<String>(entities.length * 5);
        for (PersistentEntity entity : entities) {
            String schema = SqlQueryBuilderUtils.getSchemaName(entity);
            boolean escape = this.shouldEscape(entity);
            List<SqlTableMapping> tables = SqlSchemaUtils.getSqlTableMappings(entity);
            if (StringUtils.isNotEmpty((CharSequence)schema)) {
                String createSchemaStatement = "CREATE SCHEMA " + (escape ? this.quote(schema) : schema) + ";";
                this.addToCollectionIfNotContains(createStatements, createSchemaStatement);
            }
            for (SqlTableMapping table : tables) {
                this.addTable(table, sqlTableMappingByTableName);
            }
        }
        for (SqlTableMapping table : sqlTableMappingByTableName.values()) {
            Boolean shouldEscapeDialect = this.shouldEscapeDialect(this.dialect);
            boolean escape = Objects.requireNonNullElseGet(shouldEscapeDialect, table::escape);
            this.addTableCreateStatements(createStatements, table, table.schema(), escape);
        }
        return createStatements.toArray(new String[0]);
    }

    private void addTable(SqlTableMapping table, Map<String, SqlTableMapping> sqlTableMappingByTableName) {
        boolean addTable = true;
        if (sqlTableMappingByTableName.containsKey(table.name())) {
            SqlTableMapping existingSqlTableMapping = sqlTableMappingByTableName.get(table.name());
            if (table.type() == existingSqlTableMapping.type()) {
                if (LOG.isWarnEnabled() && table.type() == SqlTableMapping.TableType.MAIN) {
                    LOG.warn("Table with name {} has more than one mapped entity. Will use table {}", (Object)table.name(), (Object)existingSqlTableMapping);
                }
                addTable = false;
            } else if (existingSqlTableMapping.type() == SqlTableMapping.TableType.JOIN) {
                sqlTableMappingByTableName.remove(table.name());
            } else if (table.type() == SqlTableMapping.TableType.JOIN) {
                addTable = false;
            }
        }
        if (addTable) {
            sqlTableMappingByTableName.put(table.name(), table);
        }
    }

    private void addTableCreateStatements(List<String> createStatements, SqlTableMapping table, String schema, boolean escape) {
        ArrayList<String> primaryColumnsName = new ArrayList<String>();
        boolean generatePkAfterColumns = false;
        ArrayList<Object> columns = new ArrayList<Object>();
        List<SqlColumnMapping> identities = table.primaryKeyColumns();
        if (CollectionUtils.isNotEmpty(identities)) {
            int idFieldCount = identities.size();
            boolean bl = generatePkAfterColumns = idFieldCount > 1;
            if (!(generatePkAfterColumns || idFieldCount <= 0 || identities.get(0).isAutoGenerated() || this.dialect == Dialect.MYSQL && identities.get(0).getDataType() == DataType.BYTE_ARRAY)) {
                generatePkAfterColumns = true;
            }
            for (SqlColumnMapping tableIdentity : identities) {
                Object column = tableIdentity.getName();
                if (escape) {
                    column = this.quote((String)column);
                }
                primaryColumnsName.add((String)column);
                if (StringUtils.isNotEmpty((CharSequence)tableIdentity.getDefinition())) {
                    column = (String)column + BLANK_SPACE + tableIdentity.getDefinition();
                } else {
                    column = (String)column + BLANK_SPACE + tableIdentity.getSqlType(this.dialect);
                    if (tableIdentity.isRequired()) {
                        column = (String)column + " NOT NULL";
                    }
                }
                if (tableIdentity.isAutoGenerated()) {
                    column = this.addGeneratedStatementToColumn(tableIdentity.getGeneratedValueType(), tableIdentity.getDataType(), (String)column, !generatePkAfterColumns);
                }
                columns.add(column);
            }
        }
        for (SqlColumnMapping tableColumn : table.columns()) {
            Object column = tableColumn.getName();
            if (escape) {
                column = this.quote((String)column);
            }
            if (StringUtils.isNotEmpty((CharSequence)tableColumn.getDefinition())) {
                column = (String)column + BLANK_SPACE + tableColumn.getDefinition();
            } else {
                column = (String)column + BLANK_SPACE + tableColumn.getSqlType(this.dialect);
                if (tableColumn.isRequired()) {
                    column = (String)column + " NOT NULL";
                }
            }
            if (tableColumn.isAutoGenerated()) {
                column = this.addGeneratedStatementToColumn(tableColumn.getGeneratedValueType(), tableColumn.getDataType(), (String)column, false);
            }
            columns.add(column);
        }
        String tableName = this.getObjectName(schema, table.name(), escape, true);
        StringBuilder builder = new StringBuilder("CREATE TABLE ").append(tableName).append(" (");
        builder.append(String.join((CharSequence)",", columns));
        if (generatePkAfterColumns) {
            builder.append(", PRIMARY KEY(").append(String.join((CharSequence)",", primaryColumnsName)).append(')');
        }
        if (this.dialect == Dialect.ORACLE) {
            builder.append(")");
        } else {
            builder.append(");");
        }
        this.addToCollectionIfNotContains(createStatements, builder.toString());
        this.createSequenceStatements(table, escape, createStatements);
        this.createIndexStatements(table, tableName, escape, createStatements);
    }

    private void createSequenceStatements(SqlTableMapping table, boolean escape, List<String> createStatements) {
        List<SqlSequenceMapping> sequences = table.sequences();
        if (CollectionUtils.isEmpty(sequences)) {
            return;
        }
        for (SqlSequenceMapping sequence : sequences) {
            if (sequence.definition() != null) {
                this.addToCollectionIfNotContains(createStatements, sequence.definition());
                continue;
            }
            GeneratedValue.Type idGeneratorType = sequence.generatedValueType().orElseGet(() -> this.defaultSelectAutoStrategy(sequence.dataType(), this.dialect));
            boolean isSequence = idGeneratorType == GeneratedValue.Type.SEQUENCE;
            if (!isSequence) continue;
            this.addToCollectionIfNotContains(createStatements, this.createSequenceStmt(table.schema(), table.name(), sequence.definedName(), escape));
        }
    }

    private void createIndexStatements(SqlTableMapping table, String escapedTableName, boolean escape, List<String> createStatements) {
        List<SqlIndexMapping> indexes = table.indexes();
        if (CollectionUtils.isEmpty(indexes)) {
            return;
        }
        for (SqlIndexMapping indexMapping : indexes) {
            this.addToCollectionIfNotContains(createStatements, this.createIndexStatement(table, indexMapping, escapedTableName, escape));
        }
    }

    @NonNull
    private String createIndexStatement(SqlTableMapping tableMapping, SqlIndexMapping indexMapping, String escapedTableName, boolean escape) {
        String indexName;
        String columnNames = String.join((CharSequence)", ", indexMapping.columns());
        String string = indexName = StringUtils.isNotEmpty((CharSequence)indexMapping.name()) ? indexMapping.name() : String.format("idx_%s%s", this.prepareNames(tableMapping.name()), this.makeTransformedColumnList(columnNames));
        if (escape) {
            indexName = this.quote(indexName);
        }
        StringBuilder indexBuilder = new StringBuilder();
        indexBuilder.append("CREATE ").append(indexMapping.unique() ? "UNIQUE " : "").append("INDEX ");
        String indexColumnNames = escape ? String.join((CharSequence)", ", Arrays.stream(indexMapping.columns()).map(this::quote).toList()) : columnNames;
        indexBuilder.append(indexName).append(" ON ").append(escapedTableName).append(" (").append(indexColumnNames);
        if (this.dialect == Dialect.ORACLE) {
            indexBuilder.append(")");
        } else {
            indexBuilder.append(");");
        }
        return indexBuilder.toString();
    }

    @NonNull
    private String createSequenceStmt(@Nullable String schema, String tableName, String definedName, boolean escape) {
        String sequenceName = this.getObjectName(schema, (String)(StringUtils.isNotEmpty((CharSequence)definedName) ? definedName : tableName + "_seq"), escape, true);
        boolean isSqlServer = this.dialect == Dialect.SQL_SERVER;
        String createSequenceStmt = "CREATE SEQUENCE " + sequenceName;
        if (isSqlServer) {
            createSequenceStmt = createSequenceStmt + " AS BIGINT";
        }
        createSequenceStmt = createSequenceStmt + " MINVALUE 1 START WITH 1";
        if (this.dialect == Dialect.ORACLE) {
            createSequenceStmt = createSequenceStmt + " CACHE 100 NOCYCLE";
        } else if (isSqlServer) {
            createSequenceStmt = createSequenceStmt + " INCREMENT BY 1";
        }
        return createSequenceStmt;
    }

    private String makeTransformedColumnList(String columnList) {
        return Arrays.stream(this.prepareNames(columnList).split(",")).map(col -> "_" + col).collect(Collectors.joining());
    }

    private String prepareNames(String columnList) {
        return columnList.chars().mapToObj(c -> String.valueOf((char)c)).filter(x -> !x.equals(BLANK_SPACE)).filter(x -> !x.equals("\"")).map(String::toLowerCase).collect(Collectors.joining());
    }

    @Override
    protected String getTableAsKeyword() {
        return BLANK_SPACE;
    }

    private String addGeneratedStatementToColumn(GeneratedValue.Type type, DataType dataType, String column, boolean isPk) {
        boolean addPkBefore;
        if (type == GeneratedValue.Type.AUTO) {
            type = dataType == DataType.UUID ? GeneratedValue.Type.UUID : (this.dialect == Dialect.ORACLE ? GeneratedValue.Type.SEQUENCE : GeneratedValue.Type.IDENTITY);
        }
        boolean bl = addPkBefore = this.dialect != Dialect.H2 && this.dialect != Dialect.ORACLE;
        if (isPk && addPkBefore) {
            column = (String)column + " PRIMARY KEY";
        }
        switch (this.dialect) {
            case POSTGRES: {
                if (type == GeneratedValue.Type.SEQUENCE) {
                    column = (String)column + " NOT NULL";
                    break;
                }
                if (type == GeneratedValue.Type.IDENTITY) {
                    if (isPk) {
                        column = (String)column + " GENERATED ALWAYS AS IDENTITY";
                        break;
                    }
                    column = (String)column + " NOT NULL";
                    break;
                }
                if (type != GeneratedValue.Type.UUID) break;
                column = (String)column + " NOT NULL DEFAULT uuid_generate_v4()";
                break;
            }
            case SQL_SERVER: {
                if (type == GeneratedValue.Type.UUID) {
                    column = (String)column + " NOT NULL DEFAULT newid()";
                    break;
                }
                if (type == GeneratedValue.Type.SEQUENCE) {
                    if (!isPk) break;
                    column = (String)column + " NOT NULL";
                    break;
                }
                column = (String)column + " IDENTITY(1,1) NOT NULL";
                break;
            }
            case ORACLE: {
                if (type == GeneratedValue.Type.UUID) {
                    column = (String)column + " NOT NULL DEFAULT SYS_GUID()";
                    break;
                }
                if (type == GeneratedValue.Type.IDENTITY) {
                    if (isPk) {
                        column = (String)column + " GENERATED ALWAYS AS IDENTITY (MINVALUE 1 START WITH 1 CACHE 100 NOCYCLE)";
                        break;
                    }
                    column = (String)column + " NOT NULL";
                    break;
                }
                column = (String)column + " NOT NULL";
                break;
            }
            default: {
                if (type == GeneratedValue.Type.UUID) {
                    if (this.dialect != Dialect.MYSQL) {
                        column = (String)column + " NOT NULL DEFAULT random_uuid()";
                        break;
                    }
                    column = (String)column + " NOT NULL";
                    break;
                }
                if (!dataType.isNumeric()) break;
                column = (String)column + " AUTO_INCREMENT";
            }
        }
        if (isPk && !addPkBefore) {
            column = (String)column + " PRIMARY KEY";
        }
        return column;
    }

    @NonNull
    private List<String> resolveJoinTableAssociatedColumns(AnnotationMetadata annotationMetadata, boolean associationOwner, PersistentEntity entity, NamingStrategy namingStrategy) {
        List<String> joinColumns = SqlQueryBuilderUtils.getJoinedColumns(annotationMetadata, associationOwner, REFERENCED_COLUMN_NAME);
        if (!joinColumns.isEmpty()) {
            return joinColumns;
        }
        PersistentProperty identity = entity.getIdentity();
        if (identity == null) {
            throw new MappingException("Cannot have a foreign key association without an ID on entity: " + entity.getName());
        }
        ArrayList<String> columns = new ArrayList<String>();
        PersistentEntityUtils.traversePersistentProperties(identity, (associations, property) -> {
            String columnName = this.getMappedName(namingStrategy, (List<Association>)associations, (PersistentProperty)property);
            columns.add(columnName);
        });
        return columns;
    }

    @Override
    protected SqlSelectionVisitor createSelectionVisitor(AnnotationMetadata annotationMetadata, AbstractSqlLikeQueryBuilder2.QueryState queryState, boolean distinct) {
        return new SqlSelectionVisitor(queryState, annotationMetadata, distinct);
    }

    @Override
    public String resolveJoinType(Join.Type jt) {
        if (!this.dialect.supportsJoinType(jt)) {
            throw new IllegalArgumentException("Unsupported join type [" + String.valueOf((Object)jt) + "] by dialect [" + String.valueOf((Object)this.dialect) + "]");
        }
        return switch (jt) {
            case Join.Type.LEFT, Join.Type.LEFT_FETCH -> " LEFT JOIN ";
            case Join.Type.RIGHT, Join.Type.RIGHT_FETCH -> " RIGHT JOIN ";
            case Join.Type.OUTER, Join.Type.OUTER_FETCH -> " FULL OUTER JOIN ";
            default -> " INNER JOIN ";
        };
    }

    @Override
    @NonNull
    public QueryResult buildInsert(AnnotationMetadata repositoryMetadata, QueryBuilder2.InsertQueryDefinition definition) {
        String builder;
        Selection<?> returningSelection = definition.returningSelection();
        if (returningSelection != null && !this.getDialect().supportsInsertReturning()) {
            throw new IllegalStateException("Dialect: " + String.valueOf((Object)this.getDialect()) + " doesn't support INSERT ... RETURNING clause");
        }
        PersistentEntity entity = definition.persistentEntity();
        boolean escape = this.shouldEscape(entity);
        String unescapedTableName = this.getUnescapedTableName(entity);
        String unescapedSchema = SqlQueryBuilderUtils.getSchemaName(entity);
        ArrayList<QueryParameterBinding> parameterBindings = new ArrayList<QueryParameterBinding>();
        if (this.isJsonEntity(repositoryMetadata, entity)) {
            AnnotationValue entityRepresentationAnnotationValue = entity.getAnnotationMetadata().getAnnotation(EntityRepresentation.class);
            String columnName = (String)entityRepresentationAnnotationValue.getRequiredValue("column", String.class);
            final int key = 1;
            builder = INSERT_INTO + this.getTableName(entity) + " VALUES (" + String.valueOf(this.formatParameter(key)) + ")";
            for (PersistentProperty identity : entity.getIdentityProperties()) {
                if (identity.isGenerated()) {
                    String identityName = identity.getPersistedName();
                    builder = "BEGIN " + builder + " RETURNING JSON_VALUE(" + columnName + ",'$." + identityName + "') INTO " + String.valueOf(this.formatParameter(key + 1)) + "; END;";
                }
                parameterBindings.add(new QueryParameterBinding(){

                    @Override
                    public String getName() {
                        return String.valueOf(key);
                    }

                    @Override
                    public String getKey() {
                        return String.valueOf(key);
                    }

                    @Override
                    public DataType getDataType() {
                        return DataType.JSON;
                    }

                    @Override
                    public JsonDataType getJsonDataType() {
                        return JsonDataType.DEFAULT;
                    }
                });
            }
        } else {
            NamingStrategy namingStrategy = this.getNamingStrategy(entity);
            Collection<? extends PersistentProperty> persistentProperties = entity.getPersistentProperties();
            ArrayList<String> columns = new ArrayList<String>();
            ArrayList<String> resultColumns = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            for (PersistentProperty persistentProperty : persistentProperties) {
                PersistentEntityUtils.traversePersistentProperties(Collections.emptyList(), persistentProperty, (associations, property) -> {
                    if (prop.isGenerated()) {
                        String columnName = this.getMappedName(namingStrategy, (List<Association>)associations, (PersistentProperty)property);
                        if (escape) {
                            columnName = this.quote(columnName);
                        }
                        resultColumns.add(columnName);
                        return;
                    }
                    this.addWriteExpression(values, prop);
                    final String key = String.valueOf(values.size());
                    String[] path = this.asStringPath((List<Association>)associations, (PersistentProperty)property);
                    parameterBindings.add(new QueryParameterBinding(){
                        final /* synthetic */ PersistentProperty val$property;
                        final /* synthetic */ String[] val$path;
                        {
                            this.val$property = persistentProperty;
                            this.val$path = stringArray;
                        }

                        @Override
                        public String getName() {
                            return key;
                        }

                        @Override
                        public String getKey() {
                            return key;
                        }

                        @Override
                        public DataType getDataType() {
                            return this.val$property.getDataType();
                        }

                        @Override
                        public JsonDataType getJsonDataType() {
                            return this.val$property.getJsonDataType();
                        }

                        @Override
                        public String[] getPropertyPath() {
                            return this.val$path;
                        }
                    });
                    String columnName = this.getMappedName(namingStrategy, (List<Association>)associations, (PersistentProperty)property);
                    if (escape) {
                        columnName = this.quote(columnName);
                    }
                    columns.add(columnName);
                    resultColumns.add(columnName);
                });
            }
            final PersistentProperty version = entity.getVersion();
            if (version != null && !version.isGenerated()) {
                this.addWriteExpression(values, version);
                final String string = String.valueOf(values.size());
                parameterBindings.add(new QueryParameterBinding(){

                    @Override
                    public String getName() {
                        return string;
                    }

                    @Override
                    public String getKey() {
                        return string;
                    }

                    @Override
                    public DataType getDataType() {
                        return version.getDataType();
                    }

                    @Override
                    public JsonDataType getJsonDataType() {
                        return null;
                    }

                    @Override
                    public String[] getPropertyPath() {
                        return new String[]{version.getName()};
                    }
                });
                String columnName = this.getMappedName(namingStrategy, Collections.emptyList(), version);
                if (escape) {
                    columnName = this.quote(columnName);
                }
                columns.add(columnName);
                resultColumns.add(columnName);
            }
            for (PersistentProperty identity : entity.getIdentityProperties()) {
                PersistentEntityUtils.traversePersistentProperties(Collections.emptyList(), identity, (associations, property) -> {
                    String columnName = this.getMappedName(namingStrategy, (List<Association>)associations, (PersistentProperty)property);
                    if (escape) {
                        columnName = this.quote(columnName);
                    }
                    boolean isSequence = false;
                    if (SqlQueryBuilderUtils.isNotForeign(associations)) {
                        resultColumns.add(columnName);
                        Optional generated = property.findAnnotation(GeneratedValue.class);
                        if (generated.isPresent()) {
                            GeneratedValue.Type idGeneratorType = generated.flatMap(av -> av.enumValue(GeneratedValue.Type.class)).orElseGet(() -> this.selectAutoStrategy((PersistentProperty)property));
                            if (idGeneratorType == GeneratedValue.Type.SEQUENCE) {
                                isSequence = true;
                            } else if (this.dialect != Dialect.MYSQL || property.getDataType() != DataType.UUID) {
                                return;
                            }
                        }
                    }
                    if (isSequence) {
                        values.add(this.getSequenceStatement(unescapedSchema, unescapedTableName, (PersistentProperty)property));
                    } else {
                        this.addWriteExpression((List<String>)values, (PersistentProperty)property);
                        final String key = String.valueOf(values.size());
                        String[] path = this.asStringPath((List<Association>)associations, (PersistentProperty)property);
                        parameterBindings.add(new QueryParameterBinding(){
                            final /* synthetic */ PersistentProperty val$property;
                            final /* synthetic */ String[] val$path;
                            {
                                this.val$property = persistentProperty;
                                this.val$path = stringArray;
                            }

                            @Override
                            public String getName() {
                                return key;
                            }

                            @Override
                            public String getKey() {
                                return key;
                            }

                            @Override
                            public DataType getDataType() {
                                return this.val$property.getDataType();
                            }

                            @Override
                            public JsonDataType getJsonDataType() {
                                return this.val$property.getJsonDataType();
                            }

                            @Override
                            public String[] getPropertyPath() {
                                return this.val$path;
                            }
                        });
                    }
                    columns.add(columnName);
                });
            }
            builder = INSERT_INTO + this.getTableName(entity) + " (" + String.join((CharSequence)",", columns) + ") VALUES (" + String.join((CharSequence)String.valueOf(','), values) + ")";
            if (definition.returningSelection() != null) {
                builder = builder + " RETURNING " + String.join((CharSequence)",", resultColumns);
            }
        }
        return QueryResult.of(builder, Collections.emptyList(), parameterBindings, Collections.emptyMap());
    }

    private String[] asStringPath(List<Association> associations, PersistentProperty property) {
        if (associations.isEmpty()) {
            return new String[]{property.getName()};
        }
        ArrayList<String> path = new ArrayList<String>(associations.size() + 1);
        for (Association association : associations) {
            path.add(association.getName());
        }
        path.add(property.getName());
        return path.toArray(new String[0]);
    }

    private String getSequenceStatement(String unescapedSchemaName, String unescapedTableName, PersistentProperty property) {
        String sequenceName = this.resolveSequenceName(property, unescapedTableName);
        return switch (this.dialect) {
            case Dialect.ORACLE -> (String)(StringUtils.isEmpty((CharSequence)unescapedSchemaName) ? "" : this.quote(unescapedSchemaName, true) + ".") + this.quote(sequenceName, true) + ".nextval";
            case Dialect.POSTGRES -> "nextval('" + (String)(StringUtils.isEmpty((CharSequence)unescapedSchemaName) ? "" : unescapedSchemaName + ".") + sequenceName + "')";
            case Dialect.SQL_SERVER -> "NEXT VALUE FOR " + (String)(StringUtils.isEmpty((CharSequence)unescapedSchemaName) ? "" : this.quote(unescapedSchemaName, true) + ".") + this.quote(sequenceName, true);
            default -> throw new IllegalStateException("Cannot generate a sequence for dialect: " + String.valueOf((Object)this.dialect));
        };
    }

    private String resolveSequenceName(PersistentProperty identity, String unescapedTableName) {
        return identity.getAnnotationMetadata().stringValue(GeneratedValue.class, "ref").map(n -> {
            if (StringUtils.isEmpty((CharSequence)n)) {
                return unescapedTableName + "_seq";
            }
            return n;
        }).orElseGet(() -> unescapedTableName + "_seq");
    }

    @Override
    protected String getAliasName(PersistentEntity entity) {
        return entity.getAliasName();
    }

    @Override
    public String getTableName(PersistentEntity entity) {
        boolean escape = this.shouldEscape(entity);
        String tableName = entity.getPersistedName();
        String schema = SqlQueryBuilderUtils.getSchemaName(entity);
        return this.getObjectName(schema, tableName, escape, true);
    }

    private String getObjectName(String schema, String objectName, boolean escape, boolean objectSupportsDynamicValues) {
        if (StringUtils.isNotEmpty((CharSequence)schema)) {
            if (escape) {
                return this.quote(schema, true) + "." + this.quote(objectName, objectSupportsDynamicValues);
            }
            return schema + "." + objectName;
        }
        return escape ? this.quote(objectName, objectSupportsDynamicValues) : objectName;
    }

    private boolean addWriteExpression(List<String> values, PersistentProperty property) {
        DataType dt = property.getDataType();
        String transformer = this.getDataTransformerWriteValue(null, property).orElse(null);
        if (transformer != null) {
            return values.add(transformer);
        }
        if (dt == DataType.JSON) {
            switch (this.dialect) {
                case POSTGRES: {
                    values.add("to_json(" + this.formatParameter(values.size() + 1).name() + "::json)");
                    break;
                }
                case H2: {
                    values.add(this.formatParameter(values.size() + 1).name() + " FORMAT JSON");
                    break;
                }
                case MYSQL: {
                    values.add("CONVERT(" + this.formatParameter(values.size() + 1).name() + " USING UTF8MB4)");
                    break;
                }
                default: {
                    values.add(this.formatParameter(values.size() + 1).name());
                }
            }
            return true;
        }
        return values.add(this.formatParameter(values.size() + 1).name());
    }

    @Override
    protected void appendUpdateSetParameter(StringBuilder sb, String alias, PersistentProperty prop, Runnable appendParameter) {
        String transformed = this.getDataTransformerWriteValue(alias, prop).orElse(null);
        if (transformed != null) {
            this.appendTransformed(sb, transformed, appendParameter);
            return;
        }
        if (prop.getDataType() == DataType.JSON) {
            switch (this.dialect) {
                case H2: {
                    appendParameter.run();
                    sb.append(" FORMAT JSON");
                    break;
                }
                case MYSQL: {
                    sb.append("CONVERT(");
                    appendParameter.run();
                    sb.append(" USING UTF8MB4)");
                    break;
                }
                case POSTGRES: {
                    sb.append("to_json(");
                    appendParameter.run();
                    sb.append("::json)");
                    break;
                }
                default: {
                    super.appendUpdateSetParameter(sb, alias, prop, appendParameter);
                    break;
                }
            }
        } else {
            super.appendUpdateSetParameter(sb, alias, prop, appendParameter);
        }
    }

    @Override
    protected void buildJoin(String joinType, StringBuilder query, AbstractSqlLikeQueryBuilder2.QueryState queryState, PersistentAssociationPath joinAssociation, PersistentEntity associationOwner, String currentJoinAlias, String lastJoinAlias) {
        List joinColumnValues;
        Association association = joinAssociation.getAssociation();
        List<Association> joinAssociationsPath = joinAssociation.getAssociations();
        PersistentEntity associatedEntity = association.getAssociatedEntity();
        boolean escape = this.shouldEscape(associationOwner);
        String mappedBy = association.getAnnotationMetadata().stringValue(Relation.class, "mappedBy").orElse(null);
        AnnotationValue joinColumnsAnnotationValue = association.getAnnotationMetadata().getAnnotation(JoinColumns.class);
        List list = joinColumnValues = joinColumnsAnnotationValue == null ? null : joinColumnsAnnotationValue.getAnnotations(VALUE_MEMBER);
        if (association.getKind() == Relation.Kind.MANY_TO_MANY || association.isForeignKey() && StringUtils.isEmpty((CharSequence)mappedBy) && CollectionUtils.isEmpty((Collection)joinColumnValues)) {
            Object finalTableName;
            String joinTableSchema;
            PersistentProperty identity = associatedEntity.getIdentity();
            if (identity == null) {
                throw new IllegalArgumentException("Associated entity [" + associatedEntity.getName() + "] defines no ID. Cannot join.");
            }
            PersistentProperty associatedId = associationOwner.getIdentity();
            if (associatedId == null) {
                throw new MappingException("Cannot join on entity [" + associationOwner.getName() + "] that has no declared ID");
            }
            Optional<Association> inverseSide = association.getInverseSide().map(Function.identity());
            Association owningAssociation = inverseSide.orElse(association);
            boolean isAssociationOwner = association.getInverseSide().isEmpty();
            NamingStrategy namingStrategy = associationOwner.getNamingStrategy();
            AnnotationMetadata annotationMetadata = owningAssociation.getAnnotationMetadata();
            List<String> ownerJoinColumns = this.resolveJoinTableAssociatedColumns(annotationMetadata, isAssociationOwner, associationOwner, namingStrategy);
            List<String> ownerJoinTableColumns = SqlQueryBuilderUtils.resolveJoinTableJoinColumns(annotationMetadata, isAssociationOwner, associationOwner, namingStrategy);
            List<String> associationJoinColumns = this.resolveJoinTableAssociatedColumns(annotationMetadata, !isAssociationOwner, associatedEntity, namingStrategy);
            List<String> associationJoinTableColumns = SqlQueryBuilderUtils.resolveJoinTableJoinColumns(annotationMetadata, !isAssociationOwner, associatedEntity, namingStrategy);
            if (escape) {
                ownerJoinColumns = ownerJoinColumns.stream().map(this::quote).toList();
                ownerJoinTableColumns = ownerJoinTableColumns.stream().map(this::quote).toList();
                associationJoinColumns = associationJoinColumns.stream().map(this::quote).toList();
                associationJoinTableColumns = associationJoinTableColumns.stream().map(this::quote).toList();
            }
            if (StringUtils.isNotEmpty((CharSequence)(joinTableSchema = annotationMetadata.stringValue("io.micronaut.data.annotation.sql.JoinTable", "schema").orElse(SqlQueryBuilderUtils.getSchemaName(associationOwner)))) && escape) {
                joinTableSchema = this.quote(joinTableSchema, true);
            }
            String joinTableName = annotationMetadata.stringValue("io.micronaut.data.annotation.sql.JoinTable", "name").orElseGet(() -> this.getMappedName(namingStrategy, association));
            String joinTableAlias = annotationMetadata.stringValue("io.micronaut.data.annotation.sql.JoinTable", "alias").orElseGet(() -> currentJoinAlias + joinTableName + "_");
            Object object = finalTableName = escape ? this.quote(joinTableName, true) : joinTableName;
            if (StringUtils.isNotEmpty((CharSequence)joinTableSchema)) {
                finalTableName = joinTableSchema + "." + (String)finalTableName;
            }
            this.join(query, queryState.baseQueryDefinition(), joinType, (String)finalTableName, joinTableAlias, lastJoinAlias, ownerJoinColumns, ownerJoinTableColumns);
            query.append(' ');
            this.join(query, queryState.baseQueryDefinition(), joinType, this.getTableName(associatedEntity), currentJoinAlias, joinTableAlias, associationJoinTableColumns, associationJoinColumns);
        } else if (StringUtils.isNotEmpty((CharSequence)mappedBy)) {
            PersistentProperty ownerIdentity = associationOwner.getIdentity();
            if (ownerIdentity == null) {
                throw new IllegalArgumentException("Associated entity [" + String.valueOf(associationOwner) + "] defines no ID. Cannot join.");
            }
            PersistentPropertyPath mappedByPropertyPath = associatedEntity.getPropertyPath(mappedBy);
            if (mappedByPropertyPath == null) {
                throw new MappingException("Foreign key association with mappedBy references a property that doesn't exist [" + mappedBy + "] of entity: " + associatedEntity.getName());
            }
            this.join(query, joinType, queryState, associatedEntity, associationOwner, lastJoinAlias, currentJoinAlias, new PersistentPropertyPath(joinAssociationsPath, ownerIdentity), mappedByPropertyPath);
        } else {
            PersistentProperty associatedProperty = associatedEntity.getIdentity();
            if (associatedProperty == null) {
                throw new IllegalArgumentException("Associated entity [" + associatedEntity.getName() + "] defines no ID. Cannot join.");
            }
            this.join(query, joinType, queryState, associatedEntity, associationOwner, lastJoinAlias, currentJoinAlias, joinAssociation, new PersistentPropertyPath(List.of(), associatedProperty));
        }
        String additionalWhere = this.resolveWhereForAnnotationMetadata(currentJoinAlias, associatedEntity.getAnnotationMetadata());
        if (StringUtils.isNotEmpty((CharSequence)additionalWhere)) {
            query.append(" AND ").append(additionalWhere);
        }
    }

    private void join(StringBuilder sb, String joinType, AbstractSqlLikeQueryBuilder2.QueryState queryState, PersistentEntity associatedEntity, PersistentEntity associationOwner, String leftTableAlias, String rightTableAlias, PersistentPropertyPath leftPropertyPath, PersistentPropertyPath rightPropertyPath) {
        boolean escape = this.shouldEscape(associationOwner);
        ArrayList<String> onLeftColumns = new ArrayList<String>();
        ArrayList<String> onRightColumns = new ArrayList<String>();
        PersistentProperty leftProperty = leftPropertyPath.getProperty();
        PersistentProperty rightProperty = rightPropertyPath.getProperty();
        Association association = null;
        if (leftProperty instanceof Association) {
            Association associationLeft;
            association = associationLeft = (Association)leftProperty;
        } else if (rightProperty instanceof Association) {
            Association associationRight;
            association = associationRight = (Association)rightProperty;
        }
        if (association != null) {
            Optional<Association> inverse = association.getInverseSide().map(Function.identity());
            Association owner = inverse.orElse(association);
            boolean isOwner = leftProperty == owner;
            AnnotationValue joinColumnsHolder = owner.getAnnotationMetadata().getAnnotation("io.micronaut.data.annotation.sql.JoinColumns");
            if (joinColumnsHolder != null) {
                onLeftColumns.addAll(joinColumnsHolder.getAnnotations(VALUE_MEMBER).stream().flatMap(ann -> ann.stringValue(isOwner ? "name" : REFERENCED_COLUMN_NAME).stream()).toList());
                onRightColumns.addAll(joinColumnsHolder.getAnnotations(VALUE_MEMBER).stream().flatMap(ann -> ann.stringValue(isOwner ? REFERENCED_COLUMN_NAME : "name").stream()).toList());
            }
        }
        if (onLeftColumns.isEmpty()) {
            PersistentEntityUtils.traversePersistentProperties(leftProperty, (associations, p) -> {
                String column = this.getMappedName(this.getNamingStrategy(leftProperty.getOwner()), this.merge((List)leftPropertyPath.getAssociations(), (List)associations), (PersistentProperty)p);
                onLeftColumns.add(column);
            });
            if (onLeftColumns.isEmpty()) {
                throw new MappingException("Cannot join on entity [" + leftProperty.getOwner().getName() + "] that has no declared ID");
            }
        }
        if (onRightColumns.isEmpty()) {
            PersistentEntityUtils.traversePersistentProperties(rightProperty, (associations, p) -> {
                String column = this.getMappedName(this.getNamingStrategy(rightProperty.getOwner()), this.merge((List)rightPropertyPath.getAssociations(), (List)associations), (PersistentProperty)p);
                onRightColumns.add(column);
            });
        }
        this.join(sb, queryState.baseQueryDefinition(), joinType, this.getTableName(associatedEntity), rightTableAlias, leftTableAlias, escape ? onLeftColumns.stream().map(this::quote).toList() : onLeftColumns, escape ? onRightColumns.stream().map(this::quote).toList() : onRightColumns);
    }

    private void join(StringBuilder builder, QueryBuilder2.BaseQueryDefinition queryDefinition, String joinType, String tableName, String tableAlias, String onTableName, List<String> onLeftColumns, List<String> onRightColumns) {
        if (onLeftColumns.size() != onRightColumns.size()) {
            throw new IllegalStateException("Un-matching join columns size: " + onLeftColumns.size() + " != " + onRightColumns.size() + BLANK_SPACE + String.valueOf(onLeftColumns) + ", " + String.valueOf(onRightColumns));
        }
        builder.append(joinType).append(tableName).append(' ').append(tableAlias);
        if (queryDefinition instanceof QueryBuilder2.SelectQueryDefinition) {
            QueryBuilder2.SelectQueryDefinition selectQueryDefinition = (QueryBuilder2.SelectQueryDefinition)queryDefinition;
            this.appendForUpdate(AbstractSqlLikeQueryBuilder2.QueryPosition.AFTER_TABLE_NAME, selectQueryDefinition, builder);
        }
        builder.append(" ON ");
        for (int i = 0; i < onLeftColumns.size(); ++i) {
            String leftColumn = onLeftColumns.get(i);
            String rightColumn = onRightColumns.get(i);
            builder.append(onTableName).append('.').append(leftColumn).append('=').append(tableAlias).append('.').append(rightColumn);
            if (i + 1 == onLeftColumns.size()) continue;
            builder.append(" AND ");
        }
    }

    private <T> List<T> merge(List<T> left, List<T> right) {
        if (left.isEmpty()) {
            return right;
        }
        if (right.isEmpty()) {
            return left;
        }
        ArrayList<T> associations = new ArrayList<T>(left.size() + right.size());
        associations.addAll(left);
        associations.addAll(right);
        return associations;
    }

    @Override
    protected String quote(String persistedName, boolean supportsDynamicValues) {
        return switch (this.dialect) {
            case Dialect.H2, Dialect.MYSQL -> "`" + persistedName + "`";
            case Dialect.SQL_SERVER -> "[" + persistedName + "]";
            case Dialect.ORACLE -> {
                String result = supportsDynamicValues ? SqlQueryBuilderUtils.mapPersistedName(persistedName, s -> s.toUpperCase(Locale.ENGLISH)) : persistedName.toUpperCase(Locale.ENGLISH);
                yield "\"" + result + "\"";
            }
            default -> "\"" + persistedName + "\"";
        };
    }

    @Override
    public String getColumnName(PersistentProperty persistentProperty) {
        return persistentProperty.getPersistedName();
    }

    @Override
    protected void appendForUpdate(AbstractSqlLikeQueryBuilder2.QueryPosition queryPosition, QueryBuilder2.SelectQueryDefinition definition, StringBuilder queryBuilder) {
        boolean isSqlServer;
        if (definition.isForUpdate() && ((isSqlServer = Dialect.SQL_SERVER.equals((Object)this.dialect)) && queryPosition.equals((Object)AbstractSqlLikeQueryBuilder2.QueryPosition.AFTER_TABLE_NAME) || !isSqlServer && queryPosition.equals((Object)AbstractSqlLikeQueryBuilder2.QueryPosition.END_OF_QUERY))) {
            queryBuilder.append(isSqlServer ? SQL_SERVER_FOR_UPDATE_CLAUSE : STANDARD_FOR_UPDATE_CLAUSE);
        }
    }

    @Override
    protected boolean computePropertyPaths() {
        return true;
    }

    @Override
    protected boolean isAliasForBatch(PersistentEntity persistentEntity, AnnotationMetadata annotationMetadata) {
        return this.isJsonEntity(annotationMetadata, persistentEntity);
    }

    @Override
    public AbstractSqlLikeQueryBuilder2.Placeholder formatParameter(int index) {
        DialectConfig dialectConfig = this.perDialectConfig.get((Object)this.dialect);
        String name = dialectConfig != null && dialectConfig.positionalNameFormatter != null ? String.format(dialectConfig.positionalNameFormatter, index) : String.valueOf(index);
        if (dialectConfig != null && dialectConfig.positionalFormatter != null) {
            return new AbstractSqlLikeQueryBuilder2.Placeholder(String.format(dialectConfig.positionalFormatter, name), name);
        }
        return new AbstractSqlLikeQueryBuilder2.Placeholder(DEFAULT_POSITIONAL_PARAMETER_MARKER, name);
    }

    protected GeneratedValue.Type selectAutoStrategy(PersistentProperty property) {
        return this.defaultSelectAutoStrategy(property.getDataType(), this.dialect);
    }

    private GeneratedValue.Type defaultSelectAutoStrategy(DataType dataType, Dialect dialect) {
        if (dataType == DataType.UUID) {
            return GeneratedValue.Type.UUID;
        }
        if (dialect == Dialect.ORACLE) {
            return GeneratedValue.Type.SEQUENCE;
        }
        return GeneratedValue.Type.AUTO;
    }

    public final String positionalParameterFormat() {
        DialectConfig dialectConfig = this.perDialectConfig.get((Object)this.dialect);
        if (dialectConfig != null && dialectConfig.positionalFormatter != null) {
            return dialectConfig.positionalFormatter;
        }
        return DEFAULT_POSITIONAL_PARAMETER_MARKER;
    }

    @Override
    protected void appendLimitAndOrder(AnnotationMetadata annotationMetadata, QueryBuilder2.SelectQueryDefinition definition, boolean appendLimit, boolean appendOrder, final AbstractSqlLikeQueryBuilder2.QueryState queryState) {
        Map<Integer, String> parametersInRole;
        if (appendOrder) {
            this.appendOrder(annotationMetadata, definition, queryState);
        }
        if (appendLimit) {
            this.appendLimitAndOffset(this.getDialect(), definition.limit(), definition.offset(), queryState.getQuery());
        }
        if (SqlQueryBuilder2.parameterInRoleModifiesOrder(parametersInRole = definition.parametersInRole()) || SqlQueryBuilder2.parameterInRoleModifiesLimit(parametersInRole)) {
            final Map.Entry<Integer, String> e = parametersInRole.entrySet().iterator().next();
            queryState.pushParameter(new QueryParameterBinding(){

                @Override
                public String getName() {
                    return (String)e.getValue();
                }

                @Override
                public String getKey() {
                    return "";
                }

                @Override
                public int getParameterIndex() {
                    return (Integer)e.getKey();
                }

                @Override
                public DataType getDataType() {
                    return DataType.OBJECT;
                }

                @Override
                public boolean isExpandable() {
                    return true;
                }

                @Override
                public String getRole() {
                    return (String)e.getValue();
                }

                @Override
                public String getTableAlias() {
                    String rootAlias = queryState.getRootAlias();
                    return StringUtils.isNotEmpty((CharSequence)rootAlias) ? rootAlias : null;
                }
            });
        }
    }

    private void appendOrder(AnnotationMetadata annotationMetadata, QueryBuilder2.SelectQueryDefinition definition, AbstractSqlLikeQueryBuilder2.QueryState queryState) {
        List<Order> orders = definition.order();
        if (this.getDialect() == Dialect.SQL_SERVER && orders.isEmpty() && (definition.limit() > 0 || definition.offset() > 0)) {
            PersistentEntity persistentEntity = definition.persistentEntity();
            PersistentProperty identity = persistentEntity.getIdentity();
            if (identity == null) {
                throw new DataAccessException("Pagination requires an entity ID on SQL Server");
            }
            orders = List.of(new DefaultOrder(new DefaultPersistentPropertyPath(identity, List.of(), null), true, false));
        }
        this.appendOrder(annotationMetadata, orders, queryState);
    }

    private <T> void addToCollectionIfNotContains(Collection<T> collection, T item) {
        if (collection.contains(item)) {
            return;
        }
        collection.add(item);
    }

    private static final class DialectConfig {
        Boolean escapeQueries;
        String positionalFormatter;
        String positionalNameFormatter;

        private DialectConfig() {
        }
    }

    protected class SqlSelectionVisitor
    extends AbstractSqlLikeQueryBuilder2.SqlSelectionVisitor {
        public SqlSelectionVisitor(AbstractSqlLikeQueryBuilder2.QueryState queryState, AnnotationMetadata annotationMetadata, boolean distinct) {
            super(SqlQueryBuilder2.this, queryState, annotationMetadata, distinct);
        }

        @Override
        protected void appendRowCount(String logicalName) {
            this.query.append("COUNT(*)");
        }

        @Override
        protected void appendRowCountDistinct(String logicalName) {
            this.query.append("COUNT(DISTINCT(");
            if (this.entity.hasCompositeIdentity()) {
                this.appendConcatProperties(List.of(this.entity.getCompositeIdentity()));
            } else if (this.entity.hasIdentity()) {
                List<PersistentProperty> identityProperties = this.entity.getIdentityProperties();
                if (identityProperties.isEmpty()) {
                    throw new IllegalArgumentException("Cannot query on ID with entity that has no ID");
                }
                long count = identityProperties.stream().mapToInt(PersistentEntityUtils::countPersistentProperties).sum();
                if (count > 1L) {
                    this.appendConcatProperties(identityProperties);
                } else {
                    for (PersistentProperty identity : identityProperties) {
                        this.appendPropertyProjection(SqlQueryBuilder2.this.asQueryPropertyPath(this.tableAlias, identity));
                    }
                }
            } else {
                throw new IllegalArgumentException("Cannot query on ID with entity that has no ID");
            }
            this.query.append("))");
        }

        private void appendConcatProperties(List<PersistentProperty> properties) {
            this.query.append(" CONCAT(");
            Iterator<PersistentProperty> iterator = properties.iterator();
            while (iterator.hasNext()) {
                PersistentProperty identity = iterator.next();
                this.appendPropertyProjection(SqlQueryBuilder2.this.asQueryPropertyPath(this.tableAlias, identity));
                if (!iterator.hasNext()) continue;
                this.query.append(',');
            }
            this.query.append(')');
        }

        @Override
        protected void selectAllColumnsAndJoined() {
            this.selectAllColumns(this.annotationMetadata, this.entity, this.tableAlias);
            Collection<JoinPath> allPaths = this.queryState.baseQueryDefinition().getJoinPaths();
            this.selectAllColumnsFromJoinPaths(allPaths, null);
        }

        @Override
        @Internal
        protected void selectAllColumnsFromJoinPaths(Collection<JoinPath> allPaths, @Nullable Map<JoinPath, String> joinAliasOverride) {
            if (CollectionUtils.isEmpty(allPaths)) {
                return;
            }
            List joinPaths = allPaths.stream().filter(jp -> jp.getJoinType().isFetch()).collect(Collectors.toList());
            Collections.reverse(joinPaths);
            if (CollectionUtils.isEmpty(joinPaths)) {
                return;
            }
            for (JoinPath joinPath : joinPaths) {
                Association association = joinPath.getAssociation();
                if (association.isEmbedded()) continue;
                PersistentEntity associatedEntity = association.getAssociatedEntity();
                NamingStrategy namingStrategy = SqlQueryBuilder2.this.getNamingStrategy(associatedEntity);
                String joinAlias = joinAliasOverride == null ? SqlQueryBuilder2.this.getAliasName(joinPath) : joinAliasOverride.get(joinPath);
                Objects.requireNonNull(joinAlias);
                String joinPathAlias = SqlQueryBuilder2.this.getPathOnlyAliasName(joinPath);
                this.query.append(',');
                boolean includeIdentity = association.isForeignKey();
                PersistentEntityUtils.traversePersistentProperties(associatedEntity, includeIdentity, true, (propertyAssociations, prop) -> {
                    String transformed = SqlQueryBuilder2.this.getDataTransformerReadValue(joinAlias, (PersistentProperty)prop).orElse(null);
                    String columnAlias = SqlQueryBuilder2.this.getColumnAlias((PersistentProperty)prop);
                    String columnName = SqlQueryBuilder2.this.computePropertyPaths() ? SqlQueryBuilder2.this.getMappedName(namingStrategy, (List<Association>)propertyAssociations, (PersistentProperty)prop) : AbstractSqlLikeQueryBuilder2.asPath(propertyAssociations, prop);
                    if (transformed != null) {
                        this.query.append(transformed).append(" AS ");
                    } else {
                        this.query.append(joinAlias).append('.').append(this.queryState.shouldEscape() ? SqlQueryBuilder2.this.quote(columnName) : columnName).append(" AS ");
                    }
                    if (StringUtils.isNotEmpty((CharSequence)columnAlias)) {
                        this.query.append(columnAlias);
                    } else {
                        this.query.append(joinPathAlias).append(columnName);
                    }
                    this.query.append(',');
                });
                this.query.setLength(this.query.length() - 1);
            }
        }

        @Override
        public void selectAllColumns(AnnotationMetadata annotationMetadata, PersistentEntity entity, String alias) {
            if (this.canUseWildcardForSelect(annotationMetadata, entity)) {
                this.selectAllColumns(this.query, alias);
                return;
            }
            boolean escape = SqlQueryBuilder2.this.shouldEscape(entity);
            NamingStrategy namingStrategy = SqlQueryBuilder2.this.getNamingStrategy(entity);
            int length = this.query.length();
            PersistentEntityUtils.traversePersistentProperties(entity, (associations, property) -> this.appendProperty(this.query, (List<Association>)associations, (PersistentProperty)property, namingStrategy, alias, escape));
            int newLength = this.query.length();
            if (newLength == length) {
                this.selectAllColumns(this.query, alias);
            } else {
                this.query.setLength(newLength - 1);
            }
        }

        private void selectAllColumns(StringBuilder sb, String alias) {
            if (alias != null) {
                sb.append(alias).append('.');
            }
            sb.append("*");
        }

        private boolean canUseWildcardForSelect(AnnotationMetadata annotationMetadata, PersistentEntity entity) {
            if (SqlQueryBuilder2.this.isJsonEntity(annotationMetadata, entity)) {
                return true;
            }
            return Stream.concat(entity.getIdentityProperties().stream(), entity.getPersistentProperties().stream()).flatMap(SqlQueryBuilderUtils::flatMapEmbedded).noneMatch(pp -> {
                if (pp instanceof Association) {
                    Association association = (Association)pp;
                    return !association.isForeignKey();
                }
                return true;
            });
        }
    }

    public static final class InsertQueryDefinitionImpl
    implements QueryBuilder2.InsertQueryDefinition {
        private final PersistentEntity persistentEntity;
        private final Selection<?> returningSelection;

        public InsertQueryDefinitionImpl(PersistentEntity persistentEntity) {
            this.persistentEntity = persistentEntity;
            this.returningSelection = null;
        }

        @Override
        public PersistentEntity persistentEntity() {
            return this.persistentEntity;
        }

        @Override
        public Selection<?> returningSelection() {
            return this.returningSelection;
        }
    }
}

