/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.jpa.criteria.impl.predicate;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.model.jpa.criteria.impl.CriteriaUtils;
import jakarta.persistence.criteria.Expression;

@Internal
public enum PredicateUnaryOp {
    IS_NULL,
    IS_NON_NULL,
    IS_TRUE,
    IS_FALSE,
    IS_EMPTY,
    IS_NOT_EMPTY;


    void validate(@NonNull Expression<?> expression) {
        switch (this) {
            case IS_EMPTY: 
            case IS_NOT_EMPTY: {
                CriteriaUtils.requireStringExpression(expression);
                break;
            }
            case IS_TRUE: 
            case IS_FALSE: {
                break;
            }
            case IS_NULL: 
            case IS_NON_NULL: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported predicate: " + this);
            }
        }
    }

    @Nullable
    public PredicateUnaryOp negate() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case IS_NULL -> IS_NON_NULL;
            case IS_NON_NULL -> IS_NULL;
            case IS_TRUE -> IS_FALSE;
            case IS_FALSE -> IS_TRUE;
            case IS_EMPTY -> IS_NOT_EMPTY;
            case IS_NOT_EMPTY -> IS_EMPTY;
        };
    }
}

