/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.data.model.schema.sql;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.data.annotation.GeneratedValue;
import io.micronaut.data.exceptions.MappingException;
import io.micronaut.data.model.DataType;
import io.micronaut.data.model.JsonDataType;
import io.micronaut.data.model.query.builder.sql.Dialect;
import io.micronaut.data.model.schema.sql.SqlDbType;

@Internal
public final class SqlColumnMapping {
    private static final String NUMERIC_TYPE = "NUMERIC";
    private static final String NUMBER_TYPE = "NUMBER";
    private final String name;
    private final DataType dataType;
    private final SqlDbType dbType;
    private final boolean primaryKey;
    @Nullable
    private final Integer length;
    @Nullable
    private final Integer precision;
    @Nullable
    private final Integer scale;
    private final boolean required;
    private final boolean autoGenerated;
    @Nullable
    private final GeneratedValue.Type generatedValueType;
    @Nullable
    private final String definition;
    @Nullable
    private final JsonDataType jsonDataType;
    private String sqlType;

    public SqlColumnMapping(String name, DataType dataType, SqlDbType dbType, boolean primaryKey, Integer length, Integer precision, Integer scale, boolean required, boolean autoGenerated, GeneratedValue.Type generatedValueType, String definition, JsonDataType jsonDataType) {
        this.name = name;
        this.dataType = dataType;
        this.dbType = dbType;
        this.primaryKey = primaryKey;
        this.length = length;
        this.precision = precision;
        this.scale = scale;
        this.required = required;
        this.autoGenerated = autoGenerated;
        this.generatedValueType = generatedValueType;
        this.definition = definition;
        this.jsonDataType = jsonDataType;
    }

    public SqlColumnMapping(String name, DataType dataType, SqlDbType dbType, boolean primaryKey, @Nullable Integer length, boolean required, boolean autoGenerated, GeneratedValue.Type generatedValueType, String definition) {
        this(name, dataType, dbType, primaryKey, length, null, null, required, autoGenerated, generatedValueType, definition, null);
    }

    public SqlColumnMapping(String name, DataType dataType, SqlDbType dbType, boolean primaryKey, @Nullable Integer length, @Nullable Integer precision, boolean required, boolean autoGenerated, GeneratedValue.Type generatedValueType, String definition) {
        this(name, dataType, dbType, primaryKey, length, precision, null, required, autoGenerated, generatedValueType, definition, null);
    }

    public String getName() {
        return this.name;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public SqlDbType getDbType() {
        return this.dbType;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    public GeneratedValue.Type getGeneratedValueType() {
        return this.generatedValueType;
    }

    public String getDefinition() {
        return this.definition;
    }

    @NonNull
    public String getSqlType(Dialect dialect) {
        if (this.sqlType != null) {
            return this.sqlType;
        }
        this.sqlType = switch (this.dataType) {
            case DataType.STRING -> "VARCHAR(" + this.length + ")";
            case DataType.UUID -> {
                if (dialect == Dialect.ORACLE || dialect == Dialect.MYSQL) {
                    yield "VARCHAR(36)";
                }
                if (dialect == Dialect.SQL_SERVER) {
                    yield "UNIQUEIDENTIFIER";
                }
                yield "UUID";
            }
            case DataType.BOOLEAN -> {
                if (dialect == Dialect.ORACLE) {
                    yield "NUMBER(1)";
                }
                if (dialect == Dialect.SQL_SERVER) {
                    yield "BIT";
                }
                yield "BOOLEAN";
            }
            case DataType.TIMESTAMP -> {
                if (dialect == Dialect.ORACLE) {
                    yield "TIMESTAMP";
                }
                if (dialect == Dialect.SQL_SERVER) {
                    yield "DATETIME2";
                }
                if (dialect == Dialect.MYSQL) {
                    yield "TIMESTAMP(6)";
                }
                yield "TIMESTAMP";
            }
            case DataType.DATE -> "DATE";
            case DataType.TIME -> {
                if (dialect == Dialect.ORACLE) {
                    yield "DATE ";
                }
                yield "TIME";
            }
            case DataType.LONG -> {
                if (dialect == Dialect.ORACLE) {
                    yield "NUMBER(19)";
                }
                yield "BIGINT";
            }
            case DataType.CHARACTER -> "CHAR(" + this.length + ")";
            case DataType.INTEGER -> {
                if (this.precision != null) {
                    String numericName = dialect == Dialect.ORACLE ? NUMBER_TYPE : NUMERIC_TYPE;
                    yield numericName + "(" + this.precision + ")";
                }
                if (dialect == Dialect.ORACLE) {
                    yield "NUMBER(10)";
                }
                if (dialect == Dialect.POSTGRES) {
                    yield "INTEGER";
                }
                yield "INT";
            }
            case DataType.BIGDECIMAL -> {
                if (this.precision != null) {
                    if (this.scale != null) {
                        String numericName = dialect == Dialect.ORACLE ? NUMBER_TYPE : NUMERIC_TYPE;
                        yield numericName + "(" + this.precision + "," + this.scale + ")";
                    }
                    yield SqlColumnMapping.floatType(this.precision);
                }
                if (dialect == Dialect.ORACLE) {
                    yield SqlColumnMapping.floatType(126);
                }
                yield "DECIMAL";
            }
            case DataType.FLOAT -> {
                if (this.precision != null) {
                    if (this.scale != null) {
                        String numericName = dialect == Dialect.ORACLE ? NUMBER_TYPE : NUMERIC_TYPE;
                        yield numericName + "(" + this.precision + "," + this.scale + ")";
                    }
                    yield SqlColumnMapping.floatType(this.precision);
                }
                if (dialect == Dialect.ORACLE || dialect == Dialect.SQL_SERVER) {
                    yield SqlColumnMapping.floatType(53);
                }
                if (dialect == Dialect.POSTGRES) {
                    yield "REAL";
                }
                yield "FLOAT";
            }
            case DataType.BYTE_ARRAY -> {
                if (dialect == Dialect.POSTGRES) {
                    yield "BYTEA";
                }
                if (dialect == Dialect.SQL_SERVER) {
                    yield "VARBINARY(MAX)";
                }
                if (dialect == Dialect.ORACLE) {
                    yield "BLOB";
                }
                yield "BLOB";
            }
            case DataType.DOUBLE -> {
                if (this.precision != null) {
                    if (this.scale != null) {
                        String numericName = dialect == Dialect.ORACLE ? NUMBER_TYPE : NUMERIC_TYPE;
                        yield numericName + "(" + this.precision + "," + this.scale + ")";
                    }
                    yield SqlColumnMapping.floatType(this.precision);
                }
                if (dialect == Dialect.ORACLE) {
                    yield SqlColumnMapping.floatType(23);
                }
                if (dialect == Dialect.MYSQL || dialect == Dialect.H2) {
                    yield "DOUBLE";
                }
                yield "DOUBLE PRECISION";
            }
            case DataType.SHORT -> {
                if (dialect == Dialect.ORACLE) {
                    yield "NUMBER(5)";
                }
                yield "SMALLINT";
            }
            case DataType.BYTE -> {
                if (dialect == Dialect.ORACLE) {
                    yield "NUMBER(3)";
                }
                if (dialect == Dialect.POSTGRES) {
                    yield "SMALLINT";
                }
                yield "TINYINT";
            }
            case DataType.JSON -> this.getJsonSqlType(dialect);
            case DataType.STRING_ARRAY, DataType.CHARACTER_ARRAY -> "VARCHAR(255) ARRAY";
            case DataType.SHORT_ARRAY -> {
                if (dialect == Dialect.POSTGRES) {
                    yield "SMALLINT ARRAY";
                }
                yield "TINYINT ARRAY";
            }
            case DataType.INTEGER_ARRAY -> {
                if (dialect == Dialect.POSTGRES || dialect == Dialect.H2) {
                    yield "INTEGER ARRAY";
                }
                yield "INT ARRAY";
            }
            case DataType.LONG_ARRAY -> "BIGINT ARRAY";
            case DataType.FLOAT_ARRAY -> {
                if (dialect == Dialect.H2 || dialect == Dialect.POSTGRES) {
                    yield "REAL ARRAY";
                }
                yield "FLOAT ARRAY";
            }
            case DataType.DOUBLE_ARRAY -> {
                if (dialect == Dialect.POSTGRES || dialect == Dialect.H2) {
                    yield "DOUBLE PRECISION ARRAY";
                }
                yield "DOUBLE ARRAY";
            }
            case DataType.BOOLEAN_ARRAY -> "BOOLEAN ARRAY";
            default -> {
                if (this.dbType == SqlDbType.ENUM) {
                    yield "VARCHAR(255)";
                }
                if (this.dbType == SqlDbType.CLOB) {
                    if (dialect == Dialect.POSTGRES) {
                        yield "TEXT";
                    }
                    yield "CLOB";
                }
                if (this.dbType == SqlDbType.BLOB) {
                    if (dialect == Dialect.POSTGRES) {
                        yield "BYTEA";
                    }
                    yield "BLOB";
                }
                throw new MappingException("Unable to create table column for property [" + this.name + "] with unknown data type: " + this.dataType);
            }
        };
        return this.sqlType;
    }

    private String getJsonSqlType(Dialect dialect) {
        return switch (dialect) {
            case Dialect.POSTGRES -> "JSONB";
            case Dialect.SQL_SERVER -> "NVARCHAR(MAX)";
            case Dialect.ORACLE -> {
                if (this.jsonDataType == JsonDataType.DEFAULT) {
                    yield "JSON";
                }
                if (this.jsonDataType == JsonDataType.BLOB) {
                    yield "BLOB";
                }
                yield "CLOB";
            }
            default -> "JSON";
        };
    }

    private static String floatType(Integer precision) {
        return "FLOAT(" + precision + ")";
    }
}

